/**
 * <copyright>
 * </copyright>
 *
 * $Id: VariableAccess.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.accesses;

import de.fzi.gast.variables.Variable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Variable Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents accesses to variables. It can be distinguished between read and write access.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.VariableAccess#isWrite <em>Write</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.VariableAccess#getTargetVariable <em>Target Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getVariableAccess()
 * @model
 * @generated
 */
public interface VariableAccess extends Access {
	/**
	 * Returns the value of the '<em><b>Write</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if it is a write access and false if it is a read access.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Write</em>' attribute.
	 * @see #setWrite(boolean)
	 * @see de.fzi.gast.accesses.accessesPackage#getVariableAccess_Write()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isWrite();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.VariableAccess#isWrite <em>Write</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Write</em>' attribute.
	 * @see #isWrite()
	 * @generated
	 */
	void setWrite(boolean value);

	/**
	 * Returns the value of the '<em><b>Target Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the reference to the accessed variable.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Target Variable</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getVariableAccess_TargetVariable()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	Variable getTargetVariable();

} // VariableAccess
