/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeAccess.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.types.GASTType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is the root class for all type accesses. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.TypeAccess#getTargetType <em>Target Type</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.TypeAccess#getTypeArguments <em>Type Arguments</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getTypeAccess()
 * @model abstract="true"
 * @generated
 */
public interface TypeAccess extends Access {
	/**
	 * Returns the value of the '<em><b>Target Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the reference to the accessed type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Target Type</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getTypeAccess_TargetType()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	GASTType getTargetType();

	/**
	 * Returns the value of the '<em><b>Type Arguments</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of type arguments in case of an access to a generic type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type Arguments</em>' reference list.
	 * @see de.fzi.gast.accesses.accessesPackage#getTypeAccess_TypeArguments()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GASTType> getTypeArguments();

} // TypeAccess
