/**
 * <copyright>
 * </copyright>
 *
 * $Id: FunctionAccess.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.accesses;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.functions.Function;
import de.fzi.gast.types.GASTType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents function calls. The usage of operators (for example in C/C++) is modelled as function call as well.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.FunctionAccess#getTypeArguments <em>Type Arguments</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.FunctionAccess#getTargetFunction <em>Target Function</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getFunctionAccess()
 * @model
 * @generated
 */
public interface FunctionAccess extends Access {
	/**
	 * Returns the value of the '<em><b>Type Arguments</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This represents the list of the actual type arguments accessed in case of a generic function call.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type Arguments</em>' reference list.
	 * @see de.fzi.gast.accesses.accessesPackage#getFunctionAccess_TypeArguments()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GASTType> getTypeArguments();

	/**
	 * Returns the value of the '<em><b>Target Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This represents the reference to the accessed function.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Target Function</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getFunctionAccess_TargetFunction()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	Function getTargetFunction();

} // FunctionAccess
