/**
 * <copyright>
 * </copyright>
 *
 * $Id: DelegateAccess.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.accesses;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Delegate Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a special case of a function access. Due to the fact that delegates are able to act as "multicast call forwarder", delegate accesses can have several target functions.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.DelegateAccess#getAccessedFunctions <em>Accessed Functions</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.DelegateAccess#getAccessedDelegate <em>Accessed Delegate</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getDelegateAccess()
 * @model
 * @generated
 */
public interface DelegateAccess extends FunctionAccess {
	/**
	 * Returns the value of the '<em><b>Accessed Functions</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Function}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of possible functions accessed via this delegate access. Due to the dynamics of a delegate an exact list of called functions cannot be given. Thus a conservative approach is taken, that means a list of all possible functions is returned.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accessed Functions</em>' reference list.
	 * @see de.fzi.gast.accesses.accessesPackage#getDelegateAccess_AccessedFunctions()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	EList<Function> getAccessedFunctions();

	/**
	 * Returns the value of the '<em><b>Accessed Delegate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the delegate which is accessed.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accessed Delegate</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getDelegateAccess_AccessedDelegate()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	Delegate getAccessedDelegate();

} // DelegateAccess
