/**
 * <copyright>
 * </copyright>
 *
 * $Id: DeclarationTypeAccess.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.accesses;

import de.fzi.gast.functions.Function;
import de.fzi.gast.variables.Variable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Declaration Type Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models variable and return type declarations.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.DeclarationTypeAccess#getFunction <em>Function</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable <em>Surrounding Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getDeclarationTypeAccess()
 * @model
 * @generated
 */
public interface DeclarationTypeAccess extends TypeAccess {
	/**
	 * Returns the value of the '<em><b>Surrounding Variable</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.variables.Variable#getTypeDeclaration <em>Type Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is a reference to the variable which is declared by this access.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Variable</em>' container reference.
	 * @see #setSurroundingVariable(Variable)
	 * @see de.fzi.gast.accesses.accessesPackage#getDeclarationTypeAccess_SurroundingVariable()
	 * @see de.fzi.gast.variables.Variable#getTypeDeclaration
	 * @model opposite="typeDeclaration" transient="false" ordered="false"
	 * @generated
	 */
	Variable getSurroundingVariable();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable <em>Surrounding Variable</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Variable</em>' container reference.
	 * @see #getSurroundingVariable()
	 * @generated
	 */
	void setSurroundingVariable(Variable value);

	/**
	 * Returns the value of the '<em><b>Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Function#getReturnTypeDeclaration <em>Return Type Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Function</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Function</em>' container reference.
	 * @see #setFunction(Function)
	 * @see de.fzi.gast.accesses.accessesPackage#getDeclarationTypeAccess_Function()
	 * @see de.fzi.gast.functions.Function#getReturnTypeDeclaration
	 * @model opposite="returnTypeDeclaration" transient="false" ordered="false"
	 * @generated
	 */
	Function getFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getFunction <em>Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Function</em>' container reference.
	 * @see #getFunction()
	 * @generated
	 */
	void setFunction(Function value);

} // DeclarationTypeAccess
