/**
 * <copyright>
 * </copyright>
 *
 * $Id: CompositeAccess.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.accesses;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Composite Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is a helping construct which represents function type arguments in the case of function calls. It bundles all accesses in the range of one function argument, e. g. in case of method call m(a, b+c) for each function argument one composite access is created. The first contains a variable access to a, the second contains variable accesses to b and c. This construct enables mapping of accesses to function arguments.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.CompositeAccess#getAccesses <em>Accesses</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getCompositeAccess()
 * @model
 * @generated
 */
public interface CompositeAccess extends BaseAccess {
	/**
	 * Returns the value of the '<em><b>Accesses</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.BaseAccess}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess <em>Surrounding Composite Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a collection with references to all contained accesses.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accesses</em>' containment reference list.
	 * @see de.fzi.gast.accesses.accessesPackage#getCompositeAccess_Accesses()
	 * @see de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess
	 * @model opposite="surroundingCompositeAccess" containment="true" ordered="false"
	 * @generated
	 */
	EList<BaseAccess> getAccesses();

} // CompositeAccess
