/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.accesses;

import de.fzi.gast.core.SourceEntity;

import de.fzi.gast.functions.Function;

import de.fzi.gast.statements.Statement;

import de.fzi.gast.types.GASTClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Base Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Base class for complex accesses (the CompositeAccess) and access which directly have a target associated.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.BaseAccess#getParentStatement <em>Parent Statement</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.BaseAccess#getSurroundingStatement <em>Surrounding Statement</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.BaseAccess#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.BaseAccess#getSurroundingFunction <em>Surrounding Function</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess <em>Surrounding Composite Access</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess()
 * @model abstract="true"
 * @generated
 */
public interface BaseAccess extends SourceEntity {
	/**
	 * Returns the value of the '<em><b>Parent Statement</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.statements.Statement#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent Statement</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent Statement</em>' container reference.
	 * @see #setParentStatement(Statement)
	 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess_ParentStatement()
	 * @see de.fzi.gast.statements.Statement#getAccesses
	 * @model opposite="accesses" transient="false" ordered="false"
	 * @generated
	 */
	Statement getParentStatement();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.BaseAccess#getParentStatement <em>Parent Statement</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent Statement</em>' container reference.
	 * @see #getParentStatement()
	 * @generated
	 */
	void setParentStatement(Statement value);

	/**
	 * Returns the value of the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to the statement, which contains the access.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Statement</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess_SurroundingStatement()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	Statement getSurroundingStatement();

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to the class in which this access is contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess_SurroundingClass()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name='' namespace=''"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Returns the value of the '<em><b>Surrounding Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to the function in which this access is contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Function</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess_SurroundingFunction()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name='' namespace=''"
	 * @generated
	 */
	Function getSurroundingFunction();

	/**
	 * Returns the value of the '<em><b>Surrounding Composite Access</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.accesses.CompositeAccess#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the access is placed in a composite access this is a reference to the surrounding composite access. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Composite Access</em>' container reference.
	 * @see #setSurroundingCompositeAccess(CompositeAccess)
	 * @see de.fzi.gast.accesses.accessesPackage#getBaseAccess_SurroundingCompositeAccess()
	 * @see de.fzi.gast.accesses.CompositeAccess#getAccesses
	 * @model opposite="accesses" transient="false" ordered="false"
	 * @generated
	 */
	CompositeAccess getSurroundingCompositeAccess();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.BaseAccess#getSurroundingCompositeAccess <em>Surrounding Composite Access</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Composite Access</em>' container reference.
	 * @see #getSurroundingCompositeAccess()
	 * @generated
	 */
	void setSurroundingCompositeAccess(CompositeAccess value);

} // BaseAccess
