/**
 * <copyright>
 * </copyright>
 *
 * $Id: Access.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.accesses;

import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.functions.Function;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Access</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is the root of the access hierarchy. Accesses represent relationships between program elements, like function calls, variable accesses or type references.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.accesses.Access#getAccessedClass <em>Accessed Class</em>}</li>
 *   <li>{@link de.fzi.gast.accesses.Access#getAccessedTarget <em>Accessed Target</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.accesses.accessesPackage#getAccess()
 * @model abstract="true"
 * @generated
 */
public interface Access extends BaseAccess {
	/**
	 * Returns the value of the '<em><b>Accessed Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents the class in which the access target is located. If the access target is a class itself it is returned.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accessed Class</em>' reference.
	 * @see de.fzi.gast.accesses.accessesPackage#getAccess_AccessedClass()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	GASTClass getAccessedClass();

	/**
	 * Returns the value of the '<em><b>Accessed Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents the accessed model element. It is the staticaly derivable model element, which means that polymorphy etc. is not resolved.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Accessed Target</em>' reference.
	 * @see #setAccessedTarget(ModelElement)
	 * @see de.fzi.gast.accesses.accessesPackage#getAccess_AccessedTarget()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ModelElement getAccessedTarget();

	/**
	 * Sets the value of the '{@link de.fzi.gast.accesses.Access#getAccessedTarget <em>Accessed Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Accessed Target</em>' reference.
	 * @see #getAccessedTarget()
	 * @generated
	 */
	void setAccessedTarget(ModelElement value);

} // Access
