/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.metricresults.util;

import de.fzi.gast.core.Identifier;

import de.fzi.gast.metricresults.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.metricresults.metricresultsPackage
 * @generated
 */
public class metricresultsSwitch<T> {
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static metricresultsPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public metricresultsSwitch() {
        if (modelPackage == null) {
            modelPackage = metricresultsPackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case metricresultsPackage.METRIC: {
                Metric metric = (Metric)theEObject;
                T result = caseMetric(metric);
                if (result == null) result = caseIdentifier(metric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.METRIC_RESULT: {
                MetricResult metricResult = (MetricResult)theEObject;
                T result = caseMetricResult(metricResult);
                if (result == null) result = caseIdentifier(metricResult);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.METRIC_RESULT_ROOT: {
                MetricResultRoot metricResultRoot = (MetricResultRoot)theEObject;
                T result = caseMetricResultRoot(metricResultRoot);
                if (result == null) result = caseIdentifier(metricResultRoot);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.FUNCTION_METRIC: {
                FunctionMetric functionMetric = (FunctionMetric)theEObject;
                T result = caseFunctionMetric(functionMetric);
                if (result == null) result = caseMetric(functionMetric);
                if (result == null) result = caseIdentifier(functionMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.CLASS_METRIC: {
                ClassMetric classMetric = (ClassMetric)theEObject;
                T result = caseClassMetric(classMetric);
                if (result == null) result = caseMetric(classMetric);
                if (result == null) result = caseIdentifier(classMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.PACKAGE_METRIC: {
                PackageMetric packageMetric = (PackageMetric)theEObject;
                T result = casePackageMetric(packageMetric);
                if (result == null) result = caseMetric(packageMetric);
                if (result == null) result = caseIdentifier(packageMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case metricresultsPackage.FILE_METRIC: {
                FileMetric fileMetric = (FileMetric)theEObject;
                T result = caseFileMetric(fileMetric);
                if (result == null) result = caseMetric(fileMetric);
                if (result == null) result = caseIdentifier(fileMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Metric</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMetric(Metric object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Metric Result</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Metric Result</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMetricResult(MetricResult object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Metric Result Root</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Metric Result Root</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseMetricResultRoot(MetricResultRoot object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Function Metric</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Function Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseFunctionMetric(FunctionMetric object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Class Metric</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Class Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseClassMetric(ClassMetric object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Package Metric</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Package Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T casePackageMetric(PackageMetric object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>File Metric</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>File Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseFileMetric(FileMetric object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseIdentifier(Identifier object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    public T defaultCase(EObject object) {
        return null;
    }

} //metricresultsSwitch
