package de.fzi.gast.helpers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

import de.fzi.gast.accesses.impl.accessesPackageImpl;
import de.fzi.gast.annotations.impl.annotationsPackageImpl;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.impl.corePackageImpl;
import de.fzi.gast.expressions.impl.expressionsPackageImpl;
import de.fzi.gast.functions.impl.functionsPackageImpl;
import de.fzi.gast.statements.impl.statementsPackageImpl;
import de.fzi.gast.types.impl.typesPackageImpl;
import de.fzi.gast.variables.impl.variablesPackageImpl;

public class GASTReader {

	//Map from UniqueID to EObject
	private Map<Integer,EObject> GASTMap;
	
	private java.io.File file;
	
	private Resource resourceGAST;
	
	private ResourceSet resourceSet;
	
	private Root root;
	
	private Logger logger = Logger.getLogger(GASTReader.class.getName());
	
	public GASTReader() throws IOException {

		corePackageImpl.eINSTANCE.eClass();
		accessesPackageImpl.eINSTANCE.eClass();
		annotationsPackageImpl.eINSTANCE.eClass();
		functionsPackageImpl.eINSTANCE.eClass();
		statementsPackageImpl.eINSTANCE.eClass();
		typesPackageImpl.eINSTANCE.eClass();
		variablesPackageImpl.eINSTANCE.eClass();
		//Expression-------------------------------
		expressionsPackageImpl.eINSTANCE.eClass();

		// setup resource set
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("gast", new XMLResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
		.put("expressions", new XMLResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
		.put("xml", new XMLResourceFactoryImpl());

	}

	/**
	 * Loads a performance-optimized models instance.
	 * @param filename File to load model from
	 * @throws IOException Thrown if the file is not present in the file system.
	 */
	public void loadFile(String filename) throws IOException {
		// check file existence
		try {
			file = new java.io.File(filename);
		} catch (NullPointerException e) {
			logger.error("Error loading file: " + filename + " Exception: " + e);
			System.err.println("Error loading file: " + filename + " Exception: " + e);
			e.printStackTrace();
		}
//		if(!file.exists()){
//			logger.error("Error loading file; file does not exist: " + filename);
//			System.err.println("Error loading file; file does not exist: " + filename);
//			throw new FileNotFoundException("File \"" + filename + "\" does not exist.");
//		}

		URI fileGAST = URI.createFileURI(file.getAbsolutePath());
		loadFile(fileGAST);
	}
	/**
	 * Loads a performance-optimized models instance.
	 * @param filename File to load model from
	 * @throws IOException Thrown if the file is not present in the file system.
	 */
	public void loadFile(URI fileURI) throws IOException {

		// setup resource
		resourceGAST = new XMLResourceImpl(fileURI);

		Map<Object, Object> loadOptions = ((XMLResourceImpl)resourceGAST).getDefaultLoadOptions();
		loadOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_PARSER_POOL, new XMLParserPoolImpl());
		loadOptions.put(XMLResource.OPTION_USE_XML_NAME_TO_FEATURE_MAP, new HashMap());

		((ResourceImpl)resourceGAST).setIntrinsicIDToEObjectMap(new HashMap());
		
		/*
		 * load GAST
		 */		
		resourceGAST.load(loadOptions);
		
		retrieveRootFromResource(resourceGAST);
		
		setupGASTMap(this.root);
	}
	
	public GASTReader(Root gastRoot) throws IOException {
		this();
		this.root = gastRoot;
		
		setupGASTMap(this.root);
	}

	private void setupGASTMap(Root root) {
		this.GASTMap = new HashMap<Integer,EObject>();
		// add model elements to map: sissyID -> modelElement
		for (Iterator iter = root.eAllContents(); iter.hasNext();) {
			EObject eObject = (EObject) iter.next();
			
			if (eObject instanceof ModelElement){
				GASTMap.put( ((ModelElement) eObject).getSissyId(), eObject);
			}
		}
	}
	
	private void retrieveRootFromResource(Resource res) {
		for (Iterator iter = EcoreUtil.getAllContents(resourceGAST, true); iter.hasNext();) {
			EObject eObject = (EObject) iter.next();
			
			if (eObject instanceof ModelElement){
				if (eObject instanceof Root) {
					root = (Root)eObject;
				}
			}
		}
	}

	public Map<Integer, EObject> getGASTMap() {
		return GASTMap;
	}

	public Resource getResourceGAST() {
		return resourceGAST;
	}

	public ResourceSet getResourceSet() {
		return resourceSet;
	}
	
	public void save() throws IOException {
		this.getResourceGAST().save(null);
	}
	
	public void saveAs(String filename) throws IOException {

		this.getResourceGAST().setURI(URI.createFileURI(filename));
		this.getResourceGAST().save(null);

	}

	public Root getRoot() {
		return root;
	}
	
	public ModelElement getModelElementWithSissyID(String uniqueID) {
		if (uniqueID != null) 
			return (ModelElement)this.getGASTMap().get(Integer.parseInt(uniqueID));
		else 
			return null;
	}

	public void setRoot(Root root) {
		this.root = root;
	}

	
}
