/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.gast.core.Identifier;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.expressions.*;
import de.fzi.gast.expressions.ArrayValueSelection;
import de.fzi.gast.expressions.Assignment;
import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.Atom;
import de.fzi.gast.expressions.BoolLiteral;
import de.fzi.gast.expressions.BooleanExpression;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CharLiteral;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.Comparison;
import de.fzi.gast.expressions.Conditional;
import de.fzi.gast.expressions.DoubleLiteral;
import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.ExpressionsRoot;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.FunctionCallPlaceholder;
import de.fzi.gast.expressions.GASTExpressionProxy;
import de.fzi.gast.expressions.IntLiteral;
import de.fzi.gast.expressions.Lvalue;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.MemberExpression;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.NullLiteral;
import de.fzi.gast.expressions.NumericLiteral;
import de.fzi.gast.expressions.Parenthesis;
import de.fzi.gast.expressions.ParenthesisExpression;
import de.fzi.gast.expressions.Product;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.Reference;
import de.fzi.gast.expressions.SISSyPlaceholder;
import de.fzi.gast.expressions.StringLiteral;
import de.fzi.gast.expressions.Term;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.TypeReferencePlaceholder;
import de.fzi.gast.expressions.Unary;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.VariablePlaceholder;
import de.fzi.gast.expressions.expressionsPackage;
import de.fzi.gast.statements.GASTExpression;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.expressions.expressionsPackage
 * @generated
 */
public class expressionsSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static expressionsPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public expressionsSwitch() {
		if (modelPackage == null) {
			modelPackage = expressionsPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case expressionsPackage.VARIABLE: {
				Variable variable = (Variable)theEObject;
				T result = caseVariable(variable);
				if (result == null) result = caseLvalue(variable);
				if (result == null) result = caseParenthesis(variable);
				if (result == null) result = caseReference(variable);
				if (result == null) result = caseAtom(variable);
				if (result == null) result = caseMemberExpression(variable);
				if (result == null) result = caseUnary(variable);
				if (result == null) result = caseProduct(variable);
				if (result == null) result = caseTerm(variable);
				if (result == null) result = caseComparison(variable);
				if (result == null) result = caseBooleanExpression(variable);
				if (result == null) result = caseAssignment(variable);
				if (result == null) result = caseGASTExpressionProxy(variable);
				if (result == null) result = caseGASTExpression(variable);
				if (result == null) result = caseSourceEntity(variable);
				if (result == null) result = caseModelElement(variable);
				if (result == null) result = caseIdentifier(variable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.ATOM: {
				Atom atom = (Atom)theEObject;
				T result = caseAtom(atom);
				if (result == null) result = caseParenthesis(atom);
				if (result == null) result = caseMemberExpression(atom);
				if (result == null) result = caseUnary(atom);
				if (result == null) result = caseProduct(atom);
				if (result == null) result = caseTerm(atom);
				if (result == null) result = caseComparison(atom);
				if (result == null) result = caseBooleanExpression(atom);
				if (result == null) result = caseAssignment(atom);
				if (result == null) result = caseGASTExpressionProxy(atom);
				if (result == null) result = caseGASTExpression(atom);
				if (result == null) result = caseSourceEntity(atom);
				if (result == null) result = caseModelElement(atom);
				if (result == null) result = caseIdentifier(atom);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.PARENTHESIS: {
				Parenthesis parenthesis = (Parenthesis)theEObject;
				T result = caseParenthesis(parenthesis);
				if (result == null) result = caseMemberExpression(parenthesis);
				if (result == null) result = caseUnary(parenthesis);
				if (result == null) result = caseProduct(parenthesis);
				if (result == null) result = caseTerm(parenthesis);
				if (result == null) result = caseComparison(parenthesis);
				if (result == null) result = caseBooleanExpression(parenthesis);
				if (result == null) result = caseAssignment(parenthesis);
				if (result == null) result = caseGASTExpressionProxy(parenthesis);
				if (result == null) result = caseGASTExpression(parenthesis);
				if (result == null) result = caseSourceEntity(parenthesis);
				if (result == null) result = caseModelElement(parenthesis);
				if (result == null) result = caseIdentifier(parenthesis);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.MEMBER_EXPRESSION: {
				MemberExpression memberExpression = (MemberExpression)theEObject;
				T result = caseMemberExpression(memberExpression);
				if (result == null) result = caseUnary(memberExpression);
				if (result == null) result = caseProduct(memberExpression);
				if (result == null) result = caseTerm(memberExpression);
				if (result == null) result = caseComparison(memberExpression);
				if (result == null) result = caseBooleanExpression(memberExpression);
				if (result == null) result = caseAssignment(memberExpression);
				if (result == null) result = caseGASTExpressionProxy(memberExpression);
				if (result == null) result = caseGASTExpression(memberExpression);
				if (result == null) result = caseSourceEntity(memberExpression);
				if (result == null) result = caseModelElement(memberExpression);
				if (result == null) result = caseIdentifier(memberExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.UNARY: {
				Unary unary = (Unary)theEObject;
				T result = caseUnary(unary);
				if (result == null) result = caseProduct(unary);
				if (result == null) result = caseTerm(unary);
				if (result == null) result = caseComparison(unary);
				if (result == null) result = caseBooleanExpression(unary);
				if (result == null) result = caseAssignment(unary);
				if (result == null) result = caseGASTExpressionProxy(unary);
				if (result == null) result = caseGASTExpression(unary);
				if (result == null) result = caseSourceEntity(unary);
				if (result == null) result = caseModelElement(unary);
				if (result == null) result = caseIdentifier(unary);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.PRODUCT: {
				Product product = (Product)theEObject;
				T result = caseProduct(product);
				if (result == null) result = caseTerm(product);
				if (result == null) result = caseComparison(product);
				if (result == null) result = caseBooleanExpression(product);
				if (result == null) result = caseAssignment(product);
				if (result == null) result = caseGASTExpressionProxy(product);
				if (result == null) result = caseGASTExpression(product);
				if (result == null) result = caseSourceEntity(product);
				if (result == null) result = caseModelElement(product);
				if (result == null) result = caseIdentifier(product);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.TERM: {
				Term term = (Term)theEObject;
				T result = caseTerm(term);
				if (result == null) result = caseComparison(term);
				if (result == null) result = caseBooleanExpression(term);
				if (result == null) result = caseAssignment(term);
				if (result == null) result = caseGASTExpressionProxy(term);
				if (result == null) result = caseGASTExpression(term);
				if (result == null) result = caseSourceEntity(term);
				if (result == null) result = caseModelElement(term);
				if (result == null) result = caseIdentifier(term);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.COMPARISON: {
				Comparison comparison = (Comparison)theEObject;
				T result = caseComparison(comparison);
				if (result == null) result = caseBooleanExpression(comparison);
				if (result == null) result = caseAssignment(comparison);
				if (result == null) result = caseGASTExpressionProxy(comparison);
				if (result == null) result = caseGASTExpression(comparison);
				if (result == null) result = caseSourceEntity(comparison);
				if (result == null) result = caseModelElement(comparison);
				if (result == null) result = caseIdentifier(comparison);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.BOOLEAN_EXPRESSION: {
				BooleanExpression booleanExpression = (BooleanExpression)theEObject;
				T result = caseBooleanExpression(booleanExpression);
				if (result == null) result = caseAssignment(booleanExpression);
				if (result == null) result = caseGASTExpressionProxy(booleanExpression);
				if (result == null) result = caseGASTExpression(booleanExpression);
				if (result == null) result = caseSourceEntity(booleanExpression);
				if (result == null) result = caseModelElement(booleanExpression);
				if (result == null) result = caseIdentifier(booleanExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.ASSIGNMENT: {
				Assignment assignment = (Assignment)theEObject;
				T result = caseAssignment(assignment);
				if (result == null) result = caseGASTExpressionProxy(assignment);
				if (result == null) result = caseGASTExpression(assignment);
				if (result == null) result = caseSourceEntity(assignment);
				if (result == null) result = caseModelElement(assignment);
				if (result == null) result = caseIdentifier(assignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.GAST_EXPRESSION_PROXY: {
				GASTExpressionProxy gastExpressionProxy = (GASTExpressionProxy)theEObject;
				T result = caseGASTExpressionProxy(gastExpressionProxy);
				if (result == null) result = caseGASTExpression(gastExpressionProxy);
				if (result == null) result = caseSourceEntity(gastExpressionProxy);
				if (result == null) result = caseModelElement(gastExpressionProxy);
				if (result == null) result = caseIdentifier(gastExpressionProxy);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.EXP_POSITION: {
				ExpPosition expPosition = (ExpPosition)theEObject;
				T result = caseExpPosition(expPosition);
				if (result == null) result = caseIdentifier(expPosition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.REFERENCE: {
				Reference reference = (Reference)theEObject;
				T result = caseReference(reference);
				if (result == null) result = caseAtom(reference);
				if (result == null) result = caseParenthesis(reference);
				if (result == null) result = caseMemberExpression(reference);
				if (result == null) result = caseUnary(reference);
				if (result == null) result = caseProduct(reference);
				if (result == null) result = caseTerm(reference);
				if (result == null) result = caseComparison(reference);
				if (result == null) result = caseBooleanExpression(reference);
				if (result == null) result = caseAssignment(reference);
				if (result == null) result = caseGASTExpressionProxy(reference);
				if (result == null) result = caseGASTExpression(reference);
				if (result == null) result = caseSourceEntity(reference);
				if (result == null) result = caseModelElement(reference);
				if (result == null) result = caseIdentifier(reference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.LVALUE: {
				Lvalue lvalue = (Lvalue)theEObject;
				T result = caseLvalue(lvalue);
				if (result == null) result = caseReference(lvalue);
				if (result == null) result = caseAtom(lvalue);
				if (result == null) result = caseParenthesis(lvalue);
				if (result == null) result = caseMemberExpression(lvalue);
				if (result == null) result = caseUnary(lvalue);
				if (result == null) result = caseProduct(lvalue);
				if (result == null) result = caseTerm(lvalue);
				if (result == null) result = caseComparison(lvalue);
				if (result == null) result = caseBooleanExpression(lvalue);
				if (result == null) result = caseAssignment(lvalue);
				if (result == null) result = caseGASTExpressionProxy(lvalue);
				if (result == null) result = caseGASTExpression(lvalue);
				if (result == null) result = caseSourceEntity(lvalue);
				if (result == null) result = caseModelElement(lvalue);
				if (result == null) result = caseIdentifier(lvalue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.ARRAY_VALUE_SELECTION: {
				ArrayValueSelection arrayValueSelection = (ArrayValueSelection)theEObject;
				T result = caseArrayValueSelection(arrayValueSelection);
				if (result == null) result = caseReference(arrayValueSelection);
				if (result == null) result = caseAtom(arrayValueSelection);
				if (result == null) result = caseParenthesis(arrayValueSelection);
				if (result == null) result = caseMemberExpression(arrayValueSelection);
				if (result == null) result = caseUnary(arrayValueSelection);
				if (result == null) result = caseProduct(arrayValueSelection);
				if (result == null) result = caseTerm(arrayValueSelection);
				if (result == null) result = caseComparison(arrayValueSelection);
				if (result == null) result = caseBooleanExpression(arrayValueSelection);
				if (result == null) result = caseAssignment(arrayValueSelection);
				if (result == null) result = caseGASTExpressionProxy(arrayValueSelection);
				if (result == null) result = caseGASTExpression(arrayValueSelection);
				if (result == null) result = caseSourceEntity(arrayValueSelection);
				if (result == null) result = caseModelElement(arrayValueSelection);
				if (result == null) result = caseIdentifier(arrayValueSelection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.TERM_EXPRESSION: {
				TermExpression termExpression = (TermExpression)theEObject;
				T result = caseTermExpression(termExpression);
				if (result == null) result = caseTerm(termExpression);
				if (result == null) result = caseComparison(termExpression);
				if (result == null) result = caseBooleanExpression(termExpression);
				if (result == null) result = caseAssignment(termExpression);
				if (result == null) result = caseGASTExpressionProxy(termExpression);
				if (result == null) result = caseGASTExpression(termExpression);
				if (result == null) result = caseSourceEntity(termExpression);
				if (result == null) result = caseModelElement(termExpression);
				if (result == null) result = caseIdentifier(termExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.PRODUCT_EXPRESSION: {
				ProductExpression productExpression = (ProductExpression)theEObject;
				T result = caseProductExpression(productExpression);
				if (result == null) result = caseProduct(productExpression);
				if (result == null) result = caseTerm(productExpression);
				if (result == null) result = caseComparison(productExpression);
				if (result == null) result = caseBooleanExpression(productExpression);
				if (result == null) result = caseAssignment(productExpression);
				if (result == null) result = caseGASTExpressionProxy(productExpression);
				if (result == null) result = caseGASTExpression(productExpression);
				if (result == null) result = caseSourceEntity(productExpression);
				if (result == null) result = caseModelElement(productExpression);
				if (result == null) result = caseIdentifier(productExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.PARENTHESIS_EXPRESSION: {
				ParenthesisExpression parenthesisExpression = (ParenthesisExpression)theEObject;
				T result = caseParenthesisExpression(parenthesisExpression);
				if (result == null) result = caseLvalue(parenthesisExpression);
				if (result == null) result = caseParenthesis(parenthesisExpression);
				if (result == null) result = caseReference(parenthesisExpression);
				if (result == null) result = caseAtom(parenthesisExpression);
				if (result == null) result = caseMemberExpression(parenthesisExpression);
				if (result == null) result = caseUnary(parenthesisExpression);
				if (result == null) result = caseProduct(parenthesisExpression);
				if (result == null) result = caseTerm(parenthesisExpression);
				if (result == null) result = caseComparison(parenthesisExpression);
				if (result == null) result = caseBooleanExpression(parenthesisExpression);
				if (result == null) result = caseAssignment(parenthesisExpression);
				if (result == null) result = caseGASTExpressionProxy(parenthesisExpression);
				if (result == null) result = caseGASTExpression(parenthesisExpression);
				if (result == null) result = caseSourceEntity(parenthesisExpression);
				if (result == null) result = caseModelElement(parenthesisExpression);
				if (result == null) result = caseIdentifier(parenthesisExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.NUMERIC_LITERAL: {
				NumericLiteral numericLiteral = (NumericLiteral)theEObject;
				T result = caseNumericLiteral(numericLiteral);
				if (result == null) result = caseAtom(numericLiteral);
				if (result == null) result = caseParenthesis(numericLiteral);
				if (result == null) result = caseMemberExpression(numericLiteral);
				if (result == null) result = caseUnary(numericLiteral);
				if (result == null) result = caseProduct(numericLiteral);
				if (result == null) result = caseTerm(numericLiteral);
				if (result == null) result = caseComparison(numericLiteral);
				if (result == null) result = caseBooleanExpression(numericLiteral);
				if (result == null) result = caseAssignment(numericLiteral);
				if (result == null) result = caseGASTExpressionProxy(numericLiteral);
				if (result == null) result = caseGASTExpression(numericLiteral);
				if (result == null) result = caseSourceEntity(numericLiteral);
				if (result == null) result = caseModelElement(numericLiteral);
				if (result == null) result = caseIdentifier(numericLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.INT_LITERAL: {
				IntLiteral intLiteral = (IntLiteral)theEObject;
				T result = caseIntLiteral(intLiteral);
				if (result == null) result = caseNumericLiteral(intLiteral);
				if (result == null) result = caseAtom(intLiteral);
				if (result == null) result = caseParenthesis(intLiteral);
				if (result == null) result = caseMemberExpression(intLiteral);
				if (result == null) result = caseUnary(intLiteral);
				if (result == null) result = caseProduct(intLiteral);
				if (result == null) result = caseTerm(intLiteral);
				if (result == null) result = caseComparison(intLiteral);
				if (result == null) result = caseBooleanExpression(intLiteral);
				if (result == null) result = caseAssignment(intLiteral);
				if (result == null) result = caseGASTExpressionProxy(intLiteral);
				if (result == null) result = caseGASTExpression(intLiteral);
				if (result == null) result = caseSourceEntity(intLiteral);
				if (result == null) result = caseModelElement(intLiteral);
				if (result == null) result = caseIdentifier(intLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.DOUBLE_LITERAL: {
				DoubleLiteral doubleLiteral = (DoubleLiteral)theEObject;
				T result = caseDoubleLiteral(doubleLiteral);
				if (result == null) result = caseNumericLiteral(doubleLiteral);
				if (result == null) result = caseAtom(doubleLiteral);
				if (result == null) result = caseParenthesis(doubleLiteral);
				if (result == null) result = caseMemberExpression(doubleLiteral);
				if (result == null) result = caseUnary(doubleLiteral);
				if (result == null) result = caseProduct(doubleLiteral);
				if (result == null) result = caseTerm(doubleLiteral);
				if (result == null) result = caseComparison(doubleLiteral);
				if (result == null) result = caseBooleanExpression(doubleLiteral);
				if (result == null) result = caseAssignment(doubleLiteral);
				if (result == null) result = caseGASTExpressionProxy(doubleLiteral);
				if (result == null) result = caseGASTExpression(doubleLiteral);
				if (result == null) result = caseSourceEntity(doubleLiteral);
				if (result == null) result = caseModelElement(doubleLiteral);
				if (result == null) result = caseIdentifier(doubleLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.COMPARE_EXPRESSION: {
				CompareExpression compareExpression = (CompareExpression)theEObject;
				T result = caseCompareExpression(compareExpression);
				if (result == null) result = caseComparison(compareExpression);
				if (result == null) result = caseBooleanExpression(compareExpression);
				if (result == null) result = caseAssignment(compareExpression);
				if (result == null) result = caseGASTExpressionProxy(compareExpression);
				if (result == null) result = caseGASTExpression(compareExpression);
				if (result == null) result = caseSourceEntity(compareExpression);
				if (result == null) result = caseModelElement(compareExpression);
				if (result == null) result = caseIdentifier(compareExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.BOOL_LITERAL: {
				BoolLiteral boolLiteral = (BoolLiteral)theEObject;
				T result = caseBoolLiteral(boolLiteral);
				if (result == null) result = caseAtom(boolLiteral);
				if (result == null) result = caseParenthesis(boolLiteral);
				if (result == null) result = caseMemberExpression(boolLiteral);
				if (result == null) result = caseUnary(boolLiteral);
				if (result == null) result = caseProduct(boolLiteral);
				if (result == null) result = caseTerm(boolLiteral);
				if (result == null) result = caseComparison(boolLiteral);
				if (result == null) result = caseBooleanExpression(boolLiteral);
				if (result == null) result = caseAssignment(boolLiteral);
				if (result == null) result = caseGASTExpressionProxy(boolLiteral);
				if (result == null) result = caseGASTExpression(boolLiteral);
				if (result == null) result = caseSourceEntity(boolLiteral);
				if (result == null) result = caseModelElement(boolLiteral);
				if (result == null) result = caseIdentifier(boolLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.STRING_LITERAL: {
				StringLiteral stringLiteral = (StringLiteral)theEObject;
				T result = caseStringLiteral(stringLiteral);
				if (result == null) result = caseAtom(stringLiteral);
				if (result == null) result = caseParenthesis(stringLiteral);
				if (result == null) result = caseMemberExpression(stringLiteral);
				if (result == null) result = caseUnary(stringLiteral);
				if (result == null) result = caseProduct(stringLiteral);
				if (result == null) result = caseTerm(stringLiteral);
				if (result == null) result = caseComparison(stringLiteral);
				if (result == null) result = caseBooleanExpression(stringLiteral);
				if (result == null) result = caseAssignment(stringLiteral);
				if (result == null) result = caseGASTExpressionProxy(stringLiteral);
				if (result == null) result = caseGASTExpression(stringLiteral);
				if (result == null) result = caseSourceEntity(stringLiteral);
				if (result == null) result = caseModelElement(stringLiteral);
				if (result == null) result = caseIdentifier(stringLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.BOOLEAN_OPERATOR_EXPRESSION: {
				BooleanOperatorExpression booleanOperatorExpression = (BooleanOperatorExpression)theEObject;
				T result = caseBooleanOperatorExpression(booleanOperatorExpression);
				if (result == null) result = caseBooleanExpression(booleanOperatorExpression);
				if (result == null) result = caseAssignment(booleanOperatorExpression);
				if (result == null) result = caseGASTExpressionProxy(booleanOperatorExpression);
				if (result == null) result = caseGASTExpression(booleanOperatorExpression);
				if (result == null) result = caseSourceEntity(booleanOperatorExpression);
				if (result == null) result = caseModelElement(booleanOperatorExpression);
				if (result == null) result = caseIdentifier(booleanOperatorExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.NOT_EXPRESSION: {
				NotExpression notExpression = (NotExpression)theEObject;
				T result = caseNotExpression(notExpression);
				if (result == null) result = caseUnary(notExpression);
				if (result == null) result = caseProduct(notExpression);
				if (result == null) result = caseTerm(notExpression);
				if (result == null) result = caseComparison(notExpression);
				if (result == null) result = caseBooleanExpression(notExpression);
				if (result == null) result = caseAssignment(notExpression);
				if (result == null) result = caseGASTExpressionProxy(notExpression);
				if (result == null) result = caseGASTExpression(notExpression);
				if (result == null) result = caseSourceEntity(notExpression);
				if (result == null) result = caseModelElement(notExpression);
				if (result == null) result = caseIdentifier(notExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.UNARY_ARITHMETIC_EXPRESSION: {
				UnaryArithmeticExpression unaryArithmeticExpression = (UnaryArithmeticExpression)theEObject;
				T result = caseUnaryArithmeticExpression(unaryArithmeticExpression);
				if (result == null) result = caseLvalue(unaryArithmeticExpression);
				if (result == null) result = caseReference(unaryArithmeticExpression);
				if (result == null) result = caseAtom(unaryArithmeticExpression);
				if (result == null) result = caseParenthesis(unaryArithmeticExpression);
				if (result == null) result = caseMemberExpression(unaryArithmeticExpression);
				if (result == null) result = caseUnary(unaryArithmeticExpression);
				if (result == null) result = caseProduct(unaryArithmeticExpression);
				if (result == null) result = caseTerm(unaryArithmeticExpression);
				if (result == null) result = caseComparison(unaryArithmeticExpression);
				if (result == null) result = caseBooleanExpression(unaryArithmeticExpression);
				if (result == null) result = caseAssignment(unaryArithmeticExpression);
				if (result == null) result = caseGASTExpressionProxy(unaryArithmeticExpression);
				if (result == null) result = caseGASTExpression(unaryArithmeticExpression);
				if (result == null) result = caseSourceEntity(unaryArithmeticExpression);
				if (result == null) result = caseModelElement(unaryArithmeticExpression);
				if (result == null) result = caseIdentifier(unaryArithmeticExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.FUNCTION_CALL: {
				FunctionCall functionCall = (FunctionCall)theEObject;
				T result = caseFunctionCall(functionCall);
				if (result == null) result = caseLvalue(functionCall);
				if (result == null) result = caseParenthesis(functionCall);
				if (result == null) result = caseReference(functionCall);
				if (result == null) result = caseAtom(functionCall);
				if (result == null) result = caseMemberExpression(functionCall);
				if (result == null) result = caseUnary(functionCall);
				if (result == null) result = caseProduct(functionCall);
				if (result == null) result = caseTerm(functionCall);
				if (result == null) result = caseComparison(functionCall);
				if (result == null) result = caseBooleanExpression(functionCall);
				if (result == null) result = caseAssignment(functionCall);
				if (result == null) result = caseGASTExpressionProxy(functionCall);
				if (result == null) result = caseGASTExpression(functionCall);
				if (result == null) result = caseSourceEntity(functionCall);
				if (result == null) result = caseModelElement(functionCall);
				if (result == null) result = caseIdentifier(functionCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.CONDITIONAL: {
				Conditional conditional = (Conditional)theEObject;
				T result = caseConditional(conditional);
				if (result == null) result = caseBooleanExpression(conditional);
				if (result == null) result = caseAssignment(conditional);
				if (result == null) result = caseGASTExpressionProxy(conditional);
				if (result == null) result = caseGASTExpression(conditional);
				if (result == null) result = caseSourceEntity(conditional);
				if (result == null) result = caseModelElement(conditional);
				if (result == null) result = caseIdentifier(conditional);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.MEMBER_ACCESSOR: {
				MemberAccessor memberAccessor = (MemberAccessor)theEObject;
				T result = caseMemberAccessor(memberAccessor);
				if (result == null) result = caseLvalue(memberAccessor);
				if (result == null) result = caseReference(memberAccessor);
				if (result == null) result = caseAtom(memberAccessor);
				if (result == null) result = caseParenthesis(memberAccessor);
				if (result == null) result = caseMemberExpression(memberAccessor);
				if (result == null) result = caseUnary(memberAccessor);
				if (result == null) result = caseProduct(memberAccessor);
				if (result == null) result = caseTerm(memberAccessor);
				if (result == null) result = caseComparison(memberAccessor);
				if (result == null) result = caseBooleanExpression(memberAccessor);
				if (result == null) result = caseAssignment(memberAccessor);
				if (result == null) result = caseGASTExpressionProxy(memberAccessor);
				if (result == null) result = caseGASTExpression(memberAccessor);
				if (result == null) result = caseSourceEntity(memberAccessor);
				if (result == null) result = caseModelElement(memberAccessor);
				if (result == null) result = caseIdentifier(memberAccessor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.TYPE_REFERENCE: {
				TypeReference typeReference = (TypeReference)theEObject;
				T result = caseTypeReference(typeReference);
				if (result == null) result = caseReference(typeReference);
				if (result == null) result = caseAtom(typeReference);
				if (result == null) result = caseParenthesis(typeReference);
				if (result == null) result = caseMemberExpression(typeReference);
				if (result == null) result = caseUnary(typeReference);
				if (result == null) result = caseProduct(typeReference);
				if (result == null) result = caseTerm(typeReference);
				if (result == null) result = caseComparison(typeReference);
				if (result == null) result = caseBooleanExpression(typeReference);
				if (result == null) result = caseAssignment(typeReference);
				if (result == null) result = caseGASTExpressionProxy(typeReference);
				if (result == null) result = caseGASTExpression(typeReference);
				if (result == null) result = caseSourceEntity(typeReference);
				if (result == null) result = caseModelElement(typeReference);
				if (result == null) result = caseIdentifier(typeReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.CAST_EXPRESSION: {
				CastExpression castExpression = (CastExpression)theEObject;
				T result = caseCastExpression(castExpression);
				if (result == null) result = caseTerm(castExpression);
				if (result == null) result = caseComparison(castExpression);
				if (result == null) result = caseBooleanExpression(castExpression);
				if (result == null) result = caseAssignment(castExpression);
				if (result == null) result = caseGASTExpressionProxy(castExpression);
				if (result == null) result = caseGASTExpression(castExpression);
				if (result == null) result = caseSourceEntity(castExpression);
				if (result == null) result = caseModelElement(castExpression);
				if (result == null) result = caseIdentifier(castExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.ASSIGNMENT_OPERATOR_EXPRESSION: {
				AssignmentOperatorExpression assignmentOperatorExpression = (AssignmentOperatorExpression)theEObject;
				T result = caseAssignmentOperatorExpression(assignmentOperatorExpression);
				if (result == null) result = caseAssignment(assignmentOperatorExpression);
				if (result == null) result = caseGASTExpressionProxy(assignmentOperatorExpression);
				if (result == null) result = caseGASTExpression(assignmentOperatorExpression);
				if (result == null) result = caseSourceEntity(assignmentOperatorExpression);
				if (result == null) result = caseModelElement(assignmentOperatorExpression);
				if (result == null) result = caseIdentifier(assignmentOperatorExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.CHAR_LITERAL: {
				CharLiteral charLiteral = (CharLiteral)theEObject;
				T result = caseCharLiteral(charLiteral);
				if (result == null) result = caseAtom(charLiteral);
				if (result == null) result = caseParenthesis(charLiteral);
				if (result == null) result = caseMemberExpression(charLiteral);
				if (result == null) result = caseUnary(charLiteral);
				if (result == null) result = caseProduct(charLiteral);
				if (result == null) result = caseTerm(charLiteral);
				if (result == null) result = caseComparison(charLiteral);
				if (result == null) result = caseBooleanExpression(charLiteral);
				if (result == null) result = caseAssignment(charLiteral);
				if (result == null) result = caseGASTExpressionProxy(charLiteral);
				if (result == null) result = caseGASTExpression(charLiteral);
				if (result == null) result = caseSourceEntity(charLiteral);
				if (result == null) result = caseModelElement(charLiteral);
				if (result == null) result = caseIdentifier(charLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.VARIABLE_PLACEHOLDER: {
				VariablePlaceholder variablePlaceholder = (VariablePlaceholder)theEObject;
				T result = caseVariablePlaceholder(variablePlaceholder);
				if (result == null) result = caseVariable(variablePlaceholder);
				if (result == null) result = caseSISSyPlaceholder(variablePlaceholder);
				if (result == null) result = caseLvalue(variablePlaceholder);
				if (result == null) result = caseParenthesis(variablePlaceholder);
				if (result == null) result = caseReference(variablePlaceholder);
				if (result == null) result = caseAtom(variablePlaceholder);
				if (result == null) result = caseMemberExpression(variablePlaceholder);
				if (result == null) result = caseUnary(variablePlaceholder);
				if (result == null) result = caseProduct(variablePlaceholder);
				if (result == null) result = caseTerm(variablePlaceholder);
				if (result == null) result = caseComparison(variablePlaceholder);
				if (result == null) result = caseBooleanExpression(variablePlaceholder);
				if (result == null) result = caseAssignment(variablePlaceholder);
				if (result == null) result = caseGASTExpressionProxy(variablePlaceholder);
				if (result == null) result = caseGASTExpression(variablePlaceholder);
				if (result == null) result = caseSourceEntity(variablePlaceholder);
				if (result == null) result = caseModelElement(variablePlaceholder);
				if (result == null) result = caseIdentifier(variablePlaceholder);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.SIS_SY_PLACEHOLDER: {
				SISSyPlaceholder sisSyPlaceholder = (SISSyPlaceholder)theEObject;
				T result = caseSISSyPlaceholder(sisSyPlaceholder);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.FUNCTION_CALL_PLACEHOLDER: {
				FunctionCallPlaceholder functionCallPlaceholder = (FunctionCallPlaceholder)theEObject;
				T result = caseFunctionCallPlaceholder(functionCallPlaceholder);
				if (result == null) result = caseFunctionCall(functionCallPlaceholder);
				if (result == null) result = caseSISSyPlaceholder(functionCallPlaceholder);
				if (result == null) result = caseLvalue(functionCallPlaceholder);
				if (result == null) result = caseParenthesis(functionCallPlaceholder);
				if (result == null) result = caseReference(functionCallPlaceholder);
				if (result == null) result = caseAtom(functionCallPlaceholder);
				if (result == null) result = caseMemberExpression(functionCallPlaceholder);
				if (result == null) result = caseUnary(functionCallPlaceholder);
				if (result == null) result = caseProduct(functionCallPlaceholder);
				if (result == null) result = caseTerm(functionCallPlaceholder);
				if (result == null) result = caseComparison(functionCallPlaceholder);
				if (result == null) result = caseBooleanExpression(functionCallPlaceholder);
				if (result == null) result = caseAssignment(functionCallPlaceholder);
				if (result == null) result = caseGASTExpressionProxy(functionCallPlaceholder);
				if (result == null) result = caseGASTExpression(functionCallPlaceholder);
				if (result == null) result = caseSourceEntity(functionCallPlaceholder);
				if (result == null) result = caseModelElement(functionCallPlaceholder);
				if (result == null) result = caseIdentifier(functionCallPlaceholder);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.TYPE_REFERENCE_PLACEHOLDER: {
				TypeReferencePlaceholder typeReferencePlaceholder = (TypeReferencePlaceholder)theEObject;
				T result = caseTypeReferencePlaceholder(typeReferencePlaceholder);
				if (result == null) result = caseTypeReference(typeReferencePlaceholder);
				if (result == null) result = caseSISSyPlaceholder(typeReferencePlaceholder);
				if (result == null) result = caseReference(typeReferencePlaceholder);
				if (result == null) result = caseAtom(typeReferencePlaceholder);
				if (result == null) result = caseParenthesis(typeReferencePlaceholder);
				if (result == null) result = caseMemberExpression(typeReferencePlaceholder);
				if (result == null) result = caseUnary(typeReferencePlaceholder);
				if (result == null) result = caseProduct(typeReferencePlaceholder);
				if (result == null) result = caseTerm(typeReferencePlaceholder);
				if (result == null) result = caseComparison(typeReferencePlaceholder);
				if (result == null) result = caseBooleanExpression(typeReferencePlaceholder);
				if (result == null) result = caseAssignment(typeReferencePlaceholder);
				if (result == null) result = caseGASTExpressionProxy(typeReferencePlaceholder);
				if (result == null) result = caseGASTExpression(typeReferencePlaceholder);
				if (result == null) result = caseSourceEntity(typeReferencePlaceholder);
				if (result == null) result = caseModelElement(typeReferencePlaceholder);
				if (result == null) result = caseIdentifier(typeReferencePlaceholder);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.EXPRESSION_ANCHOR: {
				ExpressionAnchor expressionAnchor = (ExpressionAnchor)theEObject;
				T result = caseExpressionAnchor(expressionAnchor);
				if (result == null) result = caseIdentifier(expressionAnchor);
				if (result == null) result = caseSISSyPlaceholder(expressionAnchor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.EXPRESSIONS_ROOT: {
				ExpressionsRoot expressionsRoot = (ExpressionsRoot)theEObject;
				T result = caseExpressionsRoot(expressionsRoot);
				if (result == null) result = caseIdentifier(expressionsRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case expressionsPackage.NULL_LITERAL: {
				NullLiteral nullLiteral = (NullLiteral)theEObject;
				T result = caseNullLiteral(nullLiteral);
				if (result == null) result = caseAtom(nullLiteral);
				if (result == null) result = caseParenthesis(nullLiteral);
				if (result == null) result = caseMemberExpression(nullLiteral);
				if (result == null) result = caseUnary(nullLiteral);
				if (result == null) result = caseProduct(nullLiteral);
				if (result == null) result = caseTerm(nullLiteral);
				if (result == null) result = caseComparison(nullLiteral);
				if (result == null) result = caseBooleanExpression(nullLiteral);
				if (result == null) result = caseAssignment(nullLiteral);
				if (result == null) result = caseGASTExpressionProxy(nullLiteral);
				if (result == null) result = caseGASTExpression(nullLiteral);
				if (result == null) result = caseSourceEntity(nullLiteral);
				if (result == null) result = caseModelElement(nullLiteral);
				if (result == null) result = caseIdentifier(nullLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariable(Variable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Atom</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Atom</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAtom(Atom object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parenthesis</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parenthesis</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParenthesis(Parenthesis object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemberExpression(MemberExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnary(Unary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Product</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProduct(Product object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Term</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Term</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTerm(Term object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comparison</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comparison</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComparison(Comparison object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Boolean Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Boolean Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBooleanExpression(BooleanExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignment(Assignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Expression Proxy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Expression Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTExpressionProxy(GASTExpressionProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Exp Position</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Exp Position</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpPosition(ExpPosition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReference(Reference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Lvalue</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Lvalue</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLvalue(Lvalue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Array Value Selection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Array Value Selection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArrayValueSelection(ArrayValueSelection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Term Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Term Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTermExpression(TermExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Product Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Product Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProductExpression(ProductExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parenthesis Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parenthesis Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParenthesisExpression(ParenthesisExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Numeric Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Numeric Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNumericLiteral(NumericLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntLiteral(IntLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Double Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Double Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDoubleLiteral(DoubleLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Compare Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Compare Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCompareExpression(CompareExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bool Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bool Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBoolLiteral(BoolLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringLiteral(StringLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Boolean Operator Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Boolean Operator Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBooleanOperatorExpression(BooleanOperatorExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Not Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Not Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNotExpression(NotExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Arithmetic Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Arithmetic Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryArithmeticExpression(UnaryArithmeticExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionCall(FunctionCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Conditional</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Conditional</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConditional(Conditional object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member Accessor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member Accessor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemberAccessor(MemberAccessor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeReference(TypeReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cast Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cast Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCastExpression(CastExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assignment Operator Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assignment Operator Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignmentOperatorExpression(AssignmentOperatorExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Char Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Char Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCharLiteral(CharLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable Placeholder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable Placeholder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariablePlaceholder(VariablePlaceholder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>SIS Sy Placeholder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>SIS Sy Placeholder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSISSyPlaceholder(SISSyPlaceholder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Call Placeholder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Call Placeholder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionCallPlaceholder(FunctionCallPlaceholder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Reference Placeholder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Reference Placeholder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeReferencePlaceholder(TypeReferencePlaceholder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression Anchor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression Anchor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpressionAnchor(ExpressionAnchor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expressions Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expressions Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpressionsRoot(ExpressionsRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Null Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Null Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullLiteral(NullLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSourceEntity(SourceEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTExpression(GASTExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //expressionsSwitch
