/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.annotations.annotationsPackage;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.expressions.ArrayValueSelection;
import de.fzi.gast.expressions.Assignment;
import de.fzi.gast.expressions.AssignmentOperations;
import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.Atom;
import de.fzi.gast.expressions.BoolLiteral;
import de.fzi.gast.expressions.BooleanExpression;
import de.fzi.gast.expressions.BooleanOperations;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CharLiteral;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.CompareOperations;
import de.fzi.gast.expressions.Comparison;
import de.fzi.gast.expressions.Conditional;
import de.fzi.gast.expressions.DoubleLiteral;
import de.fzi.gast.expressions.ExpPosition;
import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.ExpressionAnchorKind;
import de.fzi.gast.expressions.ExpressionsRoot;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.FunctionCallPlaceholder;
import de.fzi.gast.expressions.GASTExpressionProxy;
import de.fzi.gast.expressions.IntLiteral;
import de.fzi.gast.expressions.Lvalue;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.MemberExpression;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.NullLiteral;
import de.fzi.gast.expressions.NumericLiteral;
import de.fzi.gast.expressions.Parenthesis;
import de.fzi.gast.expressions.ParenthesisExpression;
import de.fzi.gast.expressions.Product;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.ProductOperations;
import de.fzi.gast.expressions.Reference;
import de.fzi.gast.expressions.SISSyPlaceholder;
import de.fzi.gast.expressions.StringLiteral;
import de.fzi.gast.expressions.Term;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TermOperations;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.TypeReferencePlaceholder;
import de.fzi.gast.expressions.Unary;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.UnaryOperations;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.VariablePlaceholder;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.expressions.expressionsPackage;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.statements.statementsPackage;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class expressionsPackageImpl extends EPackageImpl implements expressionsPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variableEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass atomEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass parenthesisEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memberExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass productEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass termEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass comparisonEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass booleanExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass assignmentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass gastExpressionProxyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass expPositionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lvalueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayValueSelectionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass termExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass productExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass parenthesisExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass numericLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass intLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doubleLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compareExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass boolLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass booleanOperatorExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass notExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryArithmeticExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass functionCallEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass conditionalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memberAccessorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeReferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass castExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass assignmentOperatorExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass charLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variablePlaceholderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sisSyPlaceholderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass functionCallPlaceholderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeReferencePlaceholderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass expressionAnchorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass expressionsRootEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nullLiteralEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum termOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum productOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum compareOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum booleanOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum unaryOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum assignmentOperationsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum expressionAnchorKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.fzi.gast.expressions.expressionsPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private expressionsPackageImpl() {
		super(eNS_URI, expressionsFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link expressionsPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static expressionsPackage init() {
		if (isInited) return (expressionsPackage)EPackage.Registry.INSTANCE.getEPackage(expressionsPackage.eNS_URI);

		// Obtain or create and register package
		expressionsPackageImpl theexpressionsPackage = (expressionsPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof expressionsPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new expressionsPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		statementsPackage.eINSTANCE.eClass();
		corePackage.eINSTANCE.eClass();
		annotationsPackage.eINSTANCE.eClass();
		typesPackage.eINSTANCE.eClass();
		accessesPackage.eINSTANCE.eClass();
		functionsPackage.eINSTANCE.eClass();
		variablesPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theexpressionsPackage.createPackageContents();

		// Initialize created meta-data
		theexpressionsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theexpressionsPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(expressionsPackage.eNS_URI, theexpressionsPackage);
		return theexpressionsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVariable() {
		return variableEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVariable_VariableAccess() {
		return (EReference)variableEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVariable_Arrayvalueselection() {
		return (EReference)variableEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAtom() {
		return atomEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getParenthesis() {
		return parenthesisEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemberExpression() {
		return memberExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnary() {
		return unaryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProduct() {
		return productEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTerm() {
		return termEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComparison() {
		return comparisonEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBooleanExpression() {
		return booleanExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAssignment() {
		return assignmentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGASTExpressionProxy() {
		return gastExpressionProxyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getGASTExpressionProxy_ExpPosition() {
		return (EReference)gastExpressionProxyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExpPosition() {
		return expPositionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpPosition_StartLine() {
		return (EAttribute)expPositionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpPosition_EndLine() {
		return (EAttribute)expPositionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpPosition_StartColumn() {
		return (EAttribute)expPositionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpPosition_EndColumn() {
		return (EAttribute)expPositionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpPosition_FileSissyID() {
		return (EAttribute)expPositionEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExpPosition_File() {
		return (EReference)expPositionEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReference() {
		return referenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLvalue() {
		return lvalueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayValueSelection() {
		return arrayValueSelectionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayValueSelection_Index() {
		return (EReference)arrayValueSelectionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTermExpression() {
		return termExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTermExpression_Operation() {
		return (EAttribute)termExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTermExpression_Left() {
		return (EReference)termExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTermExpression_Right() {
		return (EReference)termExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProductExpression() {
		return productExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProductExpression_Operation() {
		return (EAttribute)productExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProductExpression_Left() {
		return (EReference)productExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProductExpression_Right() {
		return (EReference)productExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getParenthesisExpression() {
		return parenthesisExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getParenthesisExpression_Inner() {
		return (EReference)parenthesisExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNumericLiteral() {
		return numericLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIntLiteral() {
		return intLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIntLiteral_Value() {
		return (EAttribute)intLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoubleLiteral() {
		return doubleLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDoubleLiteral_Value() {
		return (EAttribute)doubleLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCompareExpression() {
		return compareExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCompareExpression_Operation() {
		return (EAttribute)compareExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCompareExpression_Left() {
		return (EReference)compareExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCompareExpression_Right() {
		return (EReference)compareExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBoolLiteral() {
		return boolLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBoolLiteral_Value() {
		return (EAttribute)boolLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringLiteral() {
		return stringLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStringLiteral_Value() {
		return (EAttribute)stringLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBooleanOperatorExpression() {
		return booleanOperatorExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBooleanOperatorExpression_Operation() {
		return (EAttribute)booleanOperatorExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBooleanOperatorExpression_Left() {
		return (EReference)booleanOperatorExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBooleanOperatorExpression_Right() {
		return (EReference)booleanOperatorExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNotExpression() {
		return notExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNotExpression_Inner() {
		return (EReference)notExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnaryArithmeticExpression() {
		return unaryArithmeticExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getUnaryArithmeticExpression_Operation() {
		return (EAttribute)unaryArithmeticExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnaryArithmeticExpression_Inner() {
		return (EReference)unaryArithmeticExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFunctionCall() {
		return functionCallEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFunctionCall_Function() {
		return (EReference)functionCallEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFunctionCall_Parameterexpression() {
		return (EReference)functionCallEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFunctionCall_Arrayvalueselection() {
		return (EReference)functionCallEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConditional() {
		return conditionalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditional_Condition() {
		return (EReference)conditionalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditional_Then() {
		return (EReference)conditionalEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditional_Else() {
		return (EReference)conditionalEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemberAccessor() {
		return memberAccessorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMemberAccessor_Right() {
		return (EReference)memberAccessorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMemberAccessor_Left() {
		return (EReference)memberAccessorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeReference() {
		return typeReferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeReference_Typeaccess() {
		return (EReference)typeReferenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCastExpression() {
		return castExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCastExpression_Type() {
		return (EReference)castExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCastExpression_Expression() {
		return (EReference)castExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAssignmentOperatorExpression() {
		return assignmentOperatorExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssignmentOperatorExpression_Left() {
		return (EReference)assignmentOperatorExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssignmentOperatorExpression_Right() {
		return (EReference)assignmentOperatorExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAssignmentOperatorExpression_Operation() {
		return (EAttribute)assignmentOperatorExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCharLiteral() {
		return charLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCharLiteral_Value() {
		return (EAttribute)charLiteralEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVariablePlaceholder() {
		return variablePlaceholderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSISSyPlaceholder() {
		return sisSyPlaceholderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSISSyPlaceholder_SissyModelElementID() {
		return (EAttribute)sisSyPlaceholderEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFunctionCallPlaceholder() {
		return functionCallPlaceholderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeReferencePlaceholder() {
		return typeReferencePlaceholderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExpressionAnchor() {
		return expressionAnchorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExpressionAnchor_Gastexpressionproxy() {
		return (EReference)expressionAnchorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExpressionAnchor_Expressionanchorkind() {
		return (EAttribute)expressionAnchorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExpressionsRoot() {
		return expressionsRootEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExpressionsRoot_Expressionanchors() {
		return (EReference)expressionsRootEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNullLiteral() {
		return nullLiteralEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getTermOperations() {
		return termOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getProductOperations() {
		return productOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getCompareOperations() {
		return compareOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getBooleanOperations() {
		return booleanOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getUnaryOperations() {
		return unaryOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getAssignmentOperations() {
		return assignmentOperationsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getExpressionAnchorKind() {
		return expressionAnchorKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public expressionsFactory getexpressionsFactory() {
		return (expressionsFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		variableEClass = createEClass(VARIABLE);
		createEReference(variableEClass, VARIABLE__VARIABLE_ACCESS);
		createEReference(variableEClass, VARIABLE__ARRAYVALUESELECTION);

		atomEClass = createEClass(ATOM);

		parenthesisEClass = createEClass(PARENTHESIS);

		memberExpressionEClass = createEClass(MEMBER_EXPRESSION);

		unaryEClass = createEClass(UNARY);

		productEClass = createEClass(PRODUCT);

		termEClass = createEClass(TERM);

		comparisonEClass = createEClass(COMPARISON);

		booleanExpressionEClass = createEClass(BOOLEAN_EXPRESSION);

		assignmentEClass = createEClass(ASSIGNMENT);

		gastExpressionProxyEClass = createEClass(GAST_EXPRESSION_PROXY);
		createEReference(gastExpressionProxyEClass, GAST_EXPRESSION_PROXY__EXP_POSITION);

		expPositionEClass = createEClass(EXP_POSITION);
		createEAttribute(expPositionEClass, EXP_POSITION__START_LINE);
		createEAttribute(expPositionEClass, EXP_POSITION__END_LINE);
		createEAttribute(expPositionEClass, EXP_POSITION__START_COLUMN);
		createEAttribute(expPositionEClass, EXP_POSITION__END_COLUMN);
		createEAttribute(expPositionEClass, EXP_POSITION__FILE_SISSY_ID);
		createEReference(expPositionEClass, EXP_POSITION__FILE);

		referenceEClass = createEClass(REFERENCE);

		lvalueEClass = createEClass(LVALUE);

		arrayValueSelectionEClass = createEClass(ARRAY_VALUE_SELECTION);
		createEReference(arrayValueSelectionEClass, ARRAY_VALUE_SELECTION__INDEX);

		termExpressionEClass = createEClass(TERM_EXPRESSION);
		createEAttribute(termExpressionEClass, TERM_EXPRESSION__OPERATION);
		createEReference(termExpressionEClass, TERM_EXPRESSION__LEFT);
		createEReference(termExpressionEClass, TERM_EXPRESSION__RIGHT);

		productExpressionEClass = createEClass(PRODUCT_EXPRESSION);
		createEAttribute(productExpressionEClass, PRODUCT_EXPRESSION__OPERATION);
		createEReference(productExpressionEClass, PRODUCT_EXPRESSION__LEFT);
		createEReference(productExpressionEClass, PRODUCT_EXPRESSION__RIGHT);

		parenthesisExpressionEClass = createEClass(PARENTHESIS_EXPRESSION);
		createEReference(parenthesisExpressionEClass, PARENTHESIS_EXPRESSION__INNER);

		numericLiteralEClass = createEClass(NUMERIC_LITERAL);

		intLiteralEClass = createEClass(INT_LITERAL);
		createEAttribute(intLiteralEClass, INT_LITERAL__VALUE);

		doubleLiteralEClass = createEClass(DOUBLE_LITERAL);
		createEAttribute(doubleLiteralEClass, DOUBLE_LITERAL__VALUE);

		compareExpressionEClass = createEClass(COMPARE_EXPRESSION);
		createEAttribute(compareExpressionEClass, COMPARE_EXPRESSION__OPERATION);
		createEReference(compareExpressionEClass, COMPARE_EXPRESSION__LEFT);
		createEReference(compareExpressionEClass, COMPARE_EXPRESSION__RIGHT);

		boolLiteralEClass = createEClass(BOOL_LITERAL);
		createEAttribute(boolLiteralEClass, BOOL_LITERAL__VALUE);

		stringLiteralEClass = createEClass(STRING_LITERAL);
		createEAttribute(stringLiteralEClass, STRING_LITERAL__VALUE);

		booleanOperatorExpressionEClass = createEClass(BOOLEAN_OPERATOR_EXPRESSION);
		createEAttribute(booleanOperatorExpressionEClass, BOOLEAN_OPERATOR_EXPRESSION__OPERATION);
		createEReference(booleanOperatorExpressionEClass, BOOLEAN_OPERATOR_EXPRESSION__LEFT);
		createEReference(booleanOperatorExpressionEClass, BOOLEAN_OPERATOR_EXPRESSION__RIGHT);

		notExpressionEClass = createEClass(NOT_EXPRESSION);
		createEReference(notExpressionEClass, NOT_EXPRESSION__INNER);

		unaryArithmeticExpressionEClass = createEClass(UNARY_ARITHMETIC_EXPRESSION);
		createEAttribute(unaryArithmeticExpressionEClass, UNARY_ARITHMETIC_EXPRESSION__OPERATION);
		createEReference(unaryArithmeticExpressionEClass, UNARY_ARITHMETIC_EXPRESSION__INNER);

		functionCallEClass = createEClass(FUNCTION_CALL);
		createEReference(functionCallEClass, FUNCTION_CALL__FUNCTION);
		createEReference(functionCallEClass, FUNCTION_CALL__PARAMETEREXPRESSION);
		createEReference(functionCallEClass, FUNCTION_CALL__ARRAYVALUESELECTION);

		conditionalEClass = createEClass(CONDITIONAL);
		createEReference(conditionalEClass, CONDITIONAL__CONDITION);
		createEReference(conditionalEClass, CONDITIONAL__THEN);
		createEReference(conditionalEClass, CONDITIONAL__ELSE);

		memberAccessorEClass = createEClass(MEMBER_ACCESSOR);
		createEReference(memberAccessorEClass, MEMBER_ACCESSOR__RIGHT);
		createEReference(memberAccessorEClass, MEMBER_ACCESSOR__LEFT);

		typeReferenceEClass = createEClass(TYPE_REFERENCE);
		createEReference(typeReferenceEClass, TYPE_REFERENCE__TYPEACCESS);

		castExpressionEClass = createEClass(CAST_EXPRESSION);
		createEReference(castExpressionEClass, CAST_EXPRESSION__TYPE);
		createEReference(castExpressionEClass, CAST_EXPRESSION__EXPRESSION);

		assignmentOperatorExpressionEClass = createEClass(ASSIGNMENT_OPERATOR_EXPRESSION);
		createEReference(assignmentOperatorExpressionEClass, ASSIGNMENT_OPERATOR_EXPRESSION__LEFT);
		createEReference(assignmentOperatorExpressionEClass, ASSIGNMENT_OPERATOR_EXPRESSION__RIGHT);
		createEAttribute(assignmentOperatorExpressionEClass, ASSIGNMENT_OPERATOR_EXPRESSION__OPERATION);

		charLiteralEClass = createEClass(CHAR_LITERAL);
		createEAttribute(charLiteralEClass, CHAR_LITERAL__VALUE);

		variablePlaceholderEClass = createEClass(VARIABLE_PLACEHOLDER);

		sisSyPlaceholderEClass = createEClass(SIS_SY_PLACEHOLDER);
		createEAttribute(sisSyPlaceholderEClass, SIS_SY_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID);

		functionCallPlaceholderEClass = createEClass(FUNCTION_CALL_PLACEHOLDER);

		typeReferencePlaceholderEClass = createEClass(TYPE_REFERENCE_PLACEHOLDER);

		expressionAnchorEClass = createEClass(EXPRESSION_ANCHOR);
		createEReference(expressionAnchorEClass, EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY);
		createEAttribute(expressionAnchorEClass, EXPRESSION_ANCHOR__EXPRESSIONANCHORKIND);

		expressionsRootEClass = createEClass(EXPRESSIONS_ROOT);
		createEReference(expressionsRootEClass, EXPRESSIONS_ROOT__EXPRESSIONANCHORS);

		nullLiteralEClass = createEClass(NULL_LITERAL);

		// Create enums
		termOperationsEEnum = createEEnum(TERM_OPERATIONS);
		productOperationsEEnum = createEEnum(PRODUCT_OPERATIONS);
		compareOperationsEEnum = createEEnum(COMPARE_OPERATIONS);
		booleanOperationsEEnum = createEEnum(BOOLEAN_OPERATIONS);
		unaryOperationsEEnum = createEEnum(UNARY_OPERATIONS);
		assignmentOperationsEEnum = createEEnum(ASSIGNMENT_OPERATIONS);
		expressionAnchorKindEEnum = createEEnum(EXPRESSION_ANCHOR_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		accessesPackage theaccessesPackage = (accessesPackage)EPackage.Registry.INSTANCE.getEPackage(accessesPackage.eNS_URI);
		statementsPackage thestatementsPackage = (statementsPackage)EPackage.Registry.INSTANCE.getEPackage(statementsPackage.eNS_URI);
		corePackage thecorePackage = (corePackage)EPackage.Registry.INSTANCE.getEPackage(corePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		variableEClass.getESuperTypes().add(this.getAtom());
		variableEClass.getESuperTypes().add(this.getLvalue());
		variableEClass.getESuperTypes().add(this.getReference());
		atomEClass.getESuperTypes().add(this.getParenthesis());
		parenthesisEClass.getESuperTypes().add(this.getMemberExpression());
		memberExpressionEClass.getESuperTypes().add(this.getUnary());
		unaryEClass.getESuperTypes().add(this.getProduct());
		productEClass.getESuperTypes().add(this.getTerm());
		termEClass.getESuperTypes().add(this.getComparison());
		comparisonEClass.getESuperTypes().add(this.getBooleanExpression());
		booleanExpressionEClass.getESuperTypes().add(this.getAssignment());
		assignmentEClass.getESuperTypes().add(this.getGASTExpressionProxy());
		gastExpressionProxyEClass.getESuperTypes().add(thestatementsPackage.getGASTExpression());
		expPositionEClass.getESuperTypes().add(thecorePackage.getIdentifier());
		referenceEClass.getESuperTypes().add(this.getAtom());
		lvalueEClass.getESuperTypes().add(this.getReference());
		arrayValueSelectionEClass.getESuperTypes().add(this.getReference());
		termExpressionEClass.getESuperTypes().add(this.getTerm());
		productExpressionEClass.getESuperTypes().add(this.getProduct());
		parenthesisExpressionEClass.getESuperTypes().add(this.getAtom());
		parenthesisExpressionEClass.getESuperTypes().add(this.getLvalue());
		numericLiteralEClass.getESuperTypes().add(this.getAtom());
		intLiteralEClass.getESuperTypes().add(this.getNumericLiteral());
		doubleLiteralEClass.getESuperTypes().add(this.getNumericLiteral());
		compareExpressionEClass.getESuperTypes().add(this.getComparison());
		boolLiteralEClass.getESuperTypes().add(this.getAtom());
		stringLiteralEClass.getESuperTypes().add(this.getAtom());
		booleanOperatorExpressionEClass.getESuperTypes().add(this.getBooleanExpression());
		notExpressionEClass.getESuperTypes().add(this.getUnary());
		unaryArithmeticExpressionEClass.getESuperTypes().add(this.getLvalue());
		unaryArithmeticExpressionEClass.getESuperTypes().add(this.getUnary());
		functionCallEClass.getESuperTypes().add(this.getAtom());
		functionCallEClass.getESuperTypes().add(this.getLvalue());
		functionCallEClass.getESuperTypes().add(this.getReference());
		conditionalEClass.getESuperTypes().add(this.getBooleanExpression());
		memberAccessorEClass.getESuperTypes().add(this.getLvalue());
		memberAccessorEClass.getESuperTypes().add(this.getReference());
		typeReferenceEClass.getESuperTypes().add(this.getReference());
		castExpressionEClass.getESuperTypes().add(this.getTerm());
		assignmentOperatorExpressionEClass.getESuperTypes().add(this.getAssignment());
		charLiteralEClass.getESuperTypes().add(this.getAtom());
		variablePlaceholderEClass.getESuperTypes().add(this.getVariable());
		variablePlaceholderEClass.getESuperTypes().add(this.getSISSyPlaceholder());
		functionCallPlaceholderEClass.getESuperTypes().add(this.getFunctionCall());
		functionCallPlaceholderEClass.getESuperTypes().add(this.getSISSyPlaceholder());
		typeReferencePlaceholderEClass.getESuperTypes().add(this.getTypeReference());
		typeReferencePlaceholderEClass.getESuperTypes().add(this.getSISSyPlaceholder());
		expressionAnchorEClass.getESuperTypes().add(thecorePackage.getIdentifier());
		expressionAnchorEClass.getESuperTypes().add(this.getSISSyPlaceholder());
		expressionsRootEClass.getESuperTypes().add(thecorePackage.getIdentifier());
		nullLiteralEClass.getESuperTypes().add(this.getAtom());

		// Initialize classes and features; add operations and parameters
		initEClass(variableEClass, Variable.class, "Variable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVariable_VariableAccess(), theaccessesPackage.getVariableAccess(), null, "variableAccess", null, 0, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getVariable_Arrayvalueselection(), this.getArrayValueSelection(), null, "arrayvalueselection", null, 0, 1, Variable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(atomEClass, Atom.class, "Atom", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(parenthesisEClass, Parenthesis.class, "Parenthesis", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(memberExpressionEClass, MemberExpression.class, "MemberExpression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unaryEClass, Unary.class, "Unary", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(productEClass, Product.class, "Product", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(termEClass, Term.class, "Term", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(comparisonEClass, Comparison.class, "Comparison", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(booleanExpressionEClass, BooleanExpression.class, "BooleanExpression", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(assignmentEClass, Assignment.class, "Assignment", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(gastExpressionProxyEClass, GASTExpressionProxy.class, "GASTExpressionProxy", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGASTExpressionProxy_ExpPosition(), this.getExpPosition(), null, "expPosition", null, 1, 1, GASTExpressionProxy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(expPositionEClass, ExpPosition.class, "ExpPosition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getExpPosition_StartLine(), ecorePackage.getEInt(), "startLine", null, 1, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExpPosition_EndLine(), ecorePackage.getEInt(), "endLine", null, 1, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExpPosition_StartColumn(), ecorePackage.getEInt(), "startColumn", null, 1, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExpPosition_EndColumn(), ecorePackage.getEInt(), "endColumn", null, 1, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExpPosition_FileSissyID(), ecorePackage.getEString(), "fileSissyID", null, 1, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getExpPosition_File(), thecorePackage.getFile(), null, "file", null, 0, 1, ExpPosition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(referenceEClass, Reference.class, "Reference", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lvalueEClass, Lvalue.class, "Lvalue", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(arrayValueSelectionEClass, ArrayValueSelection.class, "ArrayValueSelection", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayValueSelection_Index(), this.getTerm(), null, "index", null, 1, -1, ArrayValueSelection.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(termExpressionEClass, TermExpression.class, "TermExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTermExpression_Operation(), this.getTermOperations(), "operation", null, 1, 1, TermExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getTermExpression_Left(), this.getTerm(), null, "left", null, 1, 1, TermExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getTermExpression_Right(), this.getTerm(), null, "right", null, 1, 1, TermExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(productExpressionEClass, ProductExpression.class, "ProductExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProductExpression_Operation(), this.getProductOperations(), "operation", null, 1, 1, ProductExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getProductExpression_Left(), this.getProduct(), null, "left", null, 1, 1, ProductExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getProductExpression_Right(), this.getProduct(), null, "right", null, 1, 1, ProductExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(parenthesisExpressionEClass, ParenthesisExpression.class, "ParenthesisExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getParenthesisExpression_Inner(), this.getAssignment(), null, "inner", null, 1, 1, ParenthesisExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(numericLiteralEClass, NumericLiteral.class, "NumericLiteral", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(intLiteralEClass, IntLiteral.class, "IntLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getIntLiteral_Value(), ecorePackage.getELong(), "value", null, 1, 1, IntLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(doubleLiteralEClass, DoubleLiteral.class, "DoubleLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDoubleLiteral_Value(), ecorePackage.getEDouble(), "value", null, 1, 1, DoubleLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(compareExpressionEClass, CompareExpression.class, "CompareExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCompareExpression_Operation(), this.getCompareOperations(), "operation", null, 1, 1, CompareExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getCompareExpression_Left(), this.getTerm(), null, "left", null, 1, 1, CompareExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getCompareExpression_Right(), this.getTerm(), null, "right", null, 1, 1, CompareExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(boolLiteralEClass, BoolLiteral.class, "BoolLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBoolLiteral_Value(), ecorePackage.getEBoolean(), "value", null, 1, 1, BoolLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(stringLiteralEClass, StringLiteral.class, "StringLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStringLiteral_Value(), ecorePackage.getEString(), "value", null, 1, 1, StringLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(booleanOperatorExpressionEClass, BooleanOperatorExpression.class, "BooleanOperatorExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBooleanOperatorExpression_Operation(), this.getBooleanOperations(), "operation", null, 1, 1, BooleanOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getBooleanOperatorExpression_Left(), this.getBooleanExpression(), null, "left", null, 1, 1, BooleanOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getBooleanOperatorExpression_Right(), this.getBooleanExpression(), null, "right", null, 1, 1, BooleanOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(notExpressionEClass, NotExpression.class, "NotExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getNotExpression_Inner(), this.getBooleanExpression(), null, "inner", null, 1, 1, NotExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(unaryArithmeticExpressionEClass, UnaryArithmeticExpression.class, "UnaryArithmeticExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUnaryArithmeticExpression_Operation(), this.getUnaryOperations(), "operation", null, 1, 1, UnaryArithmeticExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getUnaryArithmeticExpression_Inner(), this.getTerm(), null, "inner", null, 1, 1, UnaryArithmeticExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(functionCallEClass, FunctionCall.class, "FunctionCall", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFunctionCall_Function(), theaccessesPackage.getFunctionAccess(), null, "function", null, 0, 1, FunctionCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getFunctionCall_Parameterexpression(), this.getAssignment(), null, "parameterexpression", null, 0, -1, FunctionCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getFunctionCall_Arrayvalueselection(), this.getArrayValueSelection(), null, "arrayvalueselection", null, 0, 1, FunctionCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(conditionalEClass, Conditional.class, "Conditional", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConditional_Condition(), this.getBooleanExpression(), null, "condition", null, 1, 1, Conditional.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getConditional_Then(), this.getBooleanExpression(), null, "then", null, 1, 1, Conditional.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getConditional_Else(), this.getBooleanExpression(), null, "else", null, 1, 1, Conditional.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(memberAccessorEClass, MemberAccessor.class, "MemberAccessor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMemberAccessor_Right(), this.getReference(), null, "right", null, 1, 1, MemberAccessor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getMemberAccessor_Left(), this.getMemberExpression(), null, "left", null, 1, 1, MemberAccessor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(typeReferenceEClass, TypeReference.class, "TypeReference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTypeReference_Typeaccess(), theaccessesPackage.getTypeAccess(), null, "typeaccess", null, 0, 1, TypeReference.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(castExpressionEClass, CastExpression.class, "CastExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCastExpression_Type(), this.getTypeReference(), null, "type", null, 1, 1, CastExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getCastExpression_Expression(), this.getBooleanExpression(), null, "expression", null, 1, 1, CastExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(assignmentOperatorExpressionEClass, AssignmentOperatorExpression.class, "AssignmentOperatorExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAssignmentOperatorExpression_Left(), this.getLvalue(), null, "left", null, 1, 1, AssignmentOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getAssignmentOperatorExpression_Right(), this.getAssignment(), null, "right", null, 0, 1, AssignmentOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getAssignmentOperatorExpression_Operation(), this.getAssignmentOperations(), "operation", null, 1, 1, AssignmentOperatorExpression.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(charLiteralEClass, CharLiteral.class, "CharLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCharLiteral_Value(), ecorePackage.getEInt(), "value", null, 1, 1, CharLiteral.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(variablePlaceholderEClass, VariablePlaceholder.class, "VariablePlaceholder", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sisSyPlaceholderEClass, SISSyPlaceholder.class, "SISSyPlaceholder", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSISSyPlaceholder_SissyModelElementID(), ecorePackage.getEString(), "SissyModelElementID", null, 1, 1, SISSyPlaceholder.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(functionCallPlaceholderEClass, FunctionCallPlaceholder.class, "FunctionCallPlaceholder", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(typeReferencePlaceholderEClass, TypeReferencePlaceholder.class, "TypeReferencePlaceholder", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(expressionAnchorEClass, ExpressionAnchor.class, "ExpressionAnchor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExpressionAnchor_Gastexpressionproxy(), this.getGASTExpressionProxy(), null, "gastexpressionproxy", null, 0, 1, ExpressionAnchor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExpressionAnchor_Expressionanchorkind(), this.getExpressionAnchorKind(), "expressionanchorkind", null, 1, 1, ExpressionAnchor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(expressionsRootEClass, ExpressionsRoot.class, "ExpressionsRoot", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExpressionsRoot_Expressionanchors(), this.getExpressionAnchor(), null, "expressionanchors", null, 0, -1, ExpressionsRoot.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(nullLiteralEClass, NullLiteral.class, "NullLiteral", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(termOperationsEEnum, TermOperations.class, "TermOperations");
		addEEnumLiteral(termOperationsEEnum, TermOperations.ADD);
		addEEnumLiteral(termOperationsEEnum, TermOperations.SUB);

		initEEnum(productOperationsEEnum, ProductOperations.class, "ProductOperations");
		addEEnumLiteral(productOperationsEEnum, ProductOperations.MULT);
		addEEnumLiteral(productOperationsEEnum, ProductOperations.DIV);
		addEEnumLiteral(productOperationsEEnum, ProductOperations.MOD);

		initEEnum(compareOperationsEEnum, CompareOperations.class, "CompareOperations");
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.INSTANCEOF);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.GREATER);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.EQUAL);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.LESS);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.NOTEQUAL);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.LESSEQUAL);
		addEEnumLiteral(compareOperationsEEnum, CompareOperations.GREATEREQUAL);

		initEEnum(booleanOperationsEEnum, BooleanOperations.class, "BooleanOperations");
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.AND);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.OR);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.XOR);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.BITAND);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.BITOR);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.BITXOR);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.SHIFTLEFT);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.SHIFTRIGHT);
		addEEnumLiteral(booleanOperationsEEnum, BooleanOperations.UNSIGNEDSHIFTRIGHT);

		initEEnum(unaryOperationsEEnum, UnaryOperations.class, "UnaryOperations");
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.ARRAYLENGTH);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.PREINCREMENT);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.PREDECREMENT);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.NEGATION);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.POSTINCREMENT);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.POSTDECREMENT);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.DEREFERENCE);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.REFERENCE);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.SIZEOF);
		addEEnumLiteral(unaryOperationsEEnum, UnaryOperations.UNARYMINUS);

		initEEnum(assignmentOperationsEEnum, AssignmentOperations.class, "AssignmentOperations");
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.UNSIGNEDSHIFTRIGHTASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.ASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.ADDASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.SUBASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.MULASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.DIVASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.MODASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.BITANDASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.BITORASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.BITXORASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.SHIFTLEFTASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.SHIFTRIGHTASSIGN);
		addEEnumLiteral(assignmentOperationsEEnum, AssignmentOperations.ROTATERIGHTASSIGN);

		initEEnum(expressionAnchorKindEEnum, ExpressionAnchorKind.class, "ExpressionAnchorKind");
		addEEnumLiteral(expressionAnchorKindEEnum, ExpressionAnchorKind.CONDITION);
		addEEnumLiteral(expressionAnchorKindEEnum, ExpressionAnchorKind.INCREMENT);
		addEEnumLiteral(expressionAnchorKindEEnum, ExpressionAnchorKind.INIT);

		// Create resource
		createResource(eNS_URI);
	}

} //expressionsPackageImpl
