/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions.impl;

import de.fzi.gast.expressions.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.fzi.gast.expressions.ArrayValueSelection;
import de.fzi.gast.expressions.AssignmentOperations;
import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.BoolLiteral;
import de.fzi.gast.expressions.BooleanOperations;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CharLiteral;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.CompareOperations;
import de.fzi.gast.expressions.Conditional;
import de.fzi.gast.expressions.DoubleLiteral;
import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.ExpressionAnchorKind;
import de.fzi.gast.expressions.ExpressionsRoot;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.FunctionCallPlaceholder;
import de.fzi.gast.expressions.IntLiteral;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.NullLiteral;
import de.fzi.gast.expressions.ParenthesisExpression;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.ProductOperations;
import de.fzi.gast.expressions.StringLiteral;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TermOperations;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.TypeReferencePlaceholder;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.UnaryOperations;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.VariablePlaceholder;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.expressions.expressionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class expressionsFactoryImpl extends EFactoryImpl implements expressionsFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static expressionsFactory init() {
		try {
			expressionsFactory theexpressionsFactory = (expressionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fzi.de/gast/expressions"); 
			if (theexpressionsFactory != null) {
				return theexpressionsFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new expressionsFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public expressionsFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case expressionsPackage.VARIABLE: return createVariable();
			case expressionsPackage.EXP_POSITION: return createExpPosition();
			case expressionsPackage.ARRAY_VALUE_SELECTION: return createArrayValueSelection();
			case expressionsPackage.TERM_EXPRESSION: return createTermExpression();
			case expressionsPackage.PRODUCT_EXPRESSION: return createProductExpression();
			case expressionsPackage.PARENTHESIS_EXPRESSION: return createParenthesisExpression();
			case expressionsPackage.INT_LITERAL: return createIntLiteral();
			case expressionsPackage.DOUBLE_LITERAL: return createDoubleLiteral();
			case expressionsPackage.COMPARE_EXPRESSION: return createCompareExpression();
			case expressionsPackage.BOOL_LITERAL: return createBoolLiteral();
			case expressionsPackage.STRING_LITERAL: return createStringLiteral();
			case expressionsPackage.BOOLEAN_OPERATOR_EXPRESSION: return createBooleanOperatorExpression();
			case expressionsPackage.NOT_EXPRESSION: return createNotExpression();
			case expressionsPackage.UNARY_ARITHMETIC_EXPRESSION: return createUnaryArithmeticExpression();
			case expressionsPackage.FUNCTION_CALL: return createFunctionCall();
			case expressionsPackage.CONDITIONAL: return createConditional();
			case expressionsPackage.MEMBER_ACCESSOR: return createMemberAccessor();
			case expressionsPackage.TYPE_REFERENCE: return createTypeReference();
			case expressionsPackage.CAST_EXPRESSION: return createCastExpression();
			case expressionsPackage.ASSIGNMENT_OPERATOR_EXPRESSION: return createAssignmentOperatorExpression();
			case expressionsPackage.CHAR_LITERAL: return createCharLiteral();
			case expressionsPackage.VARIABLE_PLACEHOLDER: return createVariablePlaceholder();
			case expressionsPackage.FUNCTION_CALL_PLACEHOLDER: return createFunctionCallPlaceholder();
			case expressionsPackage.TYPE_REFERENCE_PLACEHOLDER: return createTypeReferencePlaceholder();
			case expressionsPackage.EXPRESSION_ANCHOR: return createExpressionAnchor();
			case expressionsPackage.EXPRESSIONS_ROOT: return createExpressionsRoot();
			case expressionsPackage.NULL_LITERAL: return createNullLiteral();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case expressionsPackage.TERM_OPERATIONS:
				return createTermOperationsFromString(eDataType, initialValue);
			case expressionsPackage.PRODUCT_OPERATIONS:
				return createProductOperationsFromString(eDataType, initialValue);
			case expressionsPackage.COMPARE_OPERATIONS:
				return createCompareOperationsFromString(eDataType, initialValue);
			case expressionsPackage.BOOLEAN_OPERATIONS:
				return createBooleanOperationsFromString(eDataType, initialValue);
			case expressionsPackage.UNARY_OPERATIONS:
				return createUnaryOperationsFromString(eDataType, initialValue);
			case expressionsPackage.ASSIGNMENT_OPERATIONS:
				return createAssignmentOperationsFromString(eDataType, initialValue);
			case expressionsPackage.EXPRESSION_ANCHOR_KIND:
				return createExpressionAnchorKindFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case expressionsPackage.TERM_OPERATIONS:
				return convertTermOperationsToString(eDataType, instanceValue);
			case expressionsPackage.PRODUCT_OPERATIONS:
				return convertProductOperationsToString(eDataType, instanceValue);
			case expressionsPackage.COMPARE_OPERATIONS:
				return convertCompareOperationsToString(eDataType, instanceValue);
			case expressionsPackage.BOOLEAN_OPERATIONS:
				return convertBooleanOperationsToString(eDataType, instanceValue);
			case expressionsPackage.UNARY_OPERATIONS:
				return convertUnaryOperationsToString(eDataType, instanceValue);
			case expressionsPackage.ASSIGNMENT_OPERATIONS:
				return convertAssignmentOperationsToString(eDataType, instanceValue);
			case expressionsPackage.EXPRESSION_ANCHOR_KIND:
				return convertExpressionAnchorKindToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variable createVariable() {
		VariableImpl variable = new VariableImpl();
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpPosition createExpPosition() {
		ExpPositionImpl expPosition = new ExpPositionImpl();
		return expPosition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayValueSelection createArrayValueSelection() {
		ArrayValueSelectionImpl arrayValueSelection = new ArrayValueSelectionImpl();
		return arrayValueSelection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TermExpression createTermExpression() {
		TermExpressionImpl termExpression = new TermExpressionImpl();
		return termExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProductExpression createProductExpression() {
		ProductExpressionImpl productExpression = new ProductExpressionImpl();
		return productExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParenthesisExpression createParenthesisExpression() {
		ParenthesisExpressionImpl parenthesisExpression = new ParenthesisExpressionImpl();
		return parenthesisExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntLiteral createIntLiteral() {
		IntLiteralImpl intLiteral = new IntLiteralImpl();
		return intLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DoubleLiteral createDoubleLiteral() {
		DoubleLiteralImpl doubleLiteral = new DoubleLiteralImpl();
		return doubleLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompareExpression createCompareExpression() {
		CompareExpressionImpl compareExpression = new CompareExpressionImpl();
		return compareExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BoolLiteral createBoolLiteral() {
		BoolLiteralImpl boolLiteral = new BoolLiteralImpl();
		return boolLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringLiteral createStringLiteral() {
		StringLiteralImpl stringLiteral = new StringLiteralImpl();
		return stringLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BooleanOperatorExpression createBooleanOperatorExpression() {
		BooleanOperatorExpressionImpl booleanOperatorExpression = new BooleanOperatorExpressionImpl();
		return booleanOperatorExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotExpression createNotExpression() {
		NotExpressionImpl notExpression = new NotExpressionImpl();
		return notExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryArithmeticExpression createUnaryArithmeticExpression() {
		UnaryArithmeticExpressionImpl unaryArithmeticExpression = new UnaryArithmeticExpressionImpl();
		return unaryArithmeticExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FunctionCall createFunctionCall() {
		FunctionCallImpl functionCall = new FunctionCallImpl();
		return functionCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Conditional createConditional() {
		ConditionalImpl conditional = new ConditionalImpl();
		return conditional;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemberAccessor createMemberAccessor() {
		MemberAccessorImpl memberAccessor = new MemberAccessorImpl();
		return memberAccessor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeReference createTypeReference() {
		TypeReferenceImpl typeReference = new TypeReferenceImpl();
		return typeReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CastExpression createCastExpression() {
		CastExpressionImpl castExpression = new CastExpressionImpl();
		return castExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssignmentOperatorExpression createAssignmentOperatorExpression() {
		AssignmentOperatorExpressionImpl assignmentOperatorExpression = new AssignmentOperatorExpressionImpl();
		return assignmentOperatorExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CharLiteral createCharLiteral() {
		CharLiteralImpl charLiteral = new CharLiteralImpl();
		return charLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariablePlaceholder createVariablePlaceholder() {
		VariablePlaceholderImpl variablePlaceholder = new VariablePlaceholderImpl();
		return variablePlaceholder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FunctionCallPlaceholder createFunctionCallPlaceholder() {
		FunctionCallPlaceholderImpl functionCallPlaceholder = new FunctionCallPlaceholderImpl();
		return functionCallPlaceholder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeReferencePlaceholder createTypeReferencePlaceholder() {
		TypeReferencePlaceholderImpl typeReferencePlaceholder = new TypeReferencePlaceholderImpl();
		return typeReferencePlaceholder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionAnchor createExpressionAnchor() {
		ExpressionAnchorImpl expressionAnchor = new ExpressionAnchorImpl();
		return expressionAnchor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionsRoot createExpressionsRoot() {
		ExpressionsRootImpl expressionsRoot = new ExpressionsRootImpl();
		return expressionsRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NullLiteral createNullLiteral() {
		NullLiteralImpl nullLiteral = new NullLiteralImpl();
		return nullLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TermOperations createTermOperationsFromString(EDataType eDataType, String initialValue) {
		TermOperations result = TermOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTermOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProductOperations createProductOperationsFromString(EDataType eDataType, String initialValue) {
		ProductOperations result = ProductOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertProductOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompareOperations createCompareOperationsFromString(EDataType eDataType, String initialValue) {
		CompareOperations result = CompareOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCompareOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BooleanOperations createBooleanOperationsFromString(EDataType eDataType, String initialValue) {
		BooleanOperations result = BooleanOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertBooleanOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryOperations createUnaryOperationsFromString(EDataType eDataType, String initialValue) {
		UnaryOperations result = UnaryOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertUnaryOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssignmentOperations createAssignmentOperationsFromString(EDataType eDataType, String initialValue) {
		AssignmentOperations result = AssignmentOperations.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAssignmentOperationsToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionAnchorKind createExpressionAnchorKindFromString(EDataType eDataType, String initialValue) {
		ExpressionAnchorKind result = ExpressionAnchorKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExpressionAnchorKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public expressionsPackage getexpressionsPackage() {
		return (expressionsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static expressionsPackage getPackage() {
		return expressionsPackage.eINSTANCE;
	}

} //expressionsFactoryImpl
