/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;

import de.fzi.gast.core.corePackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.statements.statementsPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.gast.expressions.expressionsFactory
 * @model kind="package"
 * @generated
 */
public interface expressionsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "expressions";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/expressions";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "expressions";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	expressionsPackage eINSTANCE = de.fzi.gast.expressions.impl.expressionsPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.GASTExpressionProxyImpl <em>GAST Expression Proxy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.GASTExpressionProxyImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getGASTExpressionProxy()
	 * @generated
	 */
	int GAST_EXPRESSION_PROXY = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__ID = statementsPackage.GAST_EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__ANNOTATIONS = statementsPackage.GAST_EXPRESSION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__STATUS = statementsPackage.GAST_EXPRESSION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__SISSY_ID = statementsPackage.GAST_EXPRESSION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__POSITION = statementsPackage.GAST_EXPRESSION__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY__EXP_POSITION = statementsPackage.GAST_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>GAST Expression Proxy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_PROXY_FEATURE_COUNT = statementsPackage.GAST_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.AssignmentImpl <em>Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.AssignmentImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__ID = GAST_EXPRESSION_PROXY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__ANNOTATIONS = GAST_EXPRESSION_PROXY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__STATUS = GAST_EXPRESSION_PROXY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__SISSY_ID = GAST_EXPRESSION_PROXY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__POSITION = GAST_EXPRESSION_PROXY__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__EXP_POSITION = GAST_EXPRESSION_PROXY__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT = GAST_EXPRESSION_PROXY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.BooleanExpressionImpl <em>Boolean Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.BooleanExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanExpression()
	 * @generated
	 */
	int BOOLEAN_EXPRESSION = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__ID = ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__ANNOTATIONS = ASSIGNMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__STATUS = ASSIGNMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__SISSY_ID = ASSIGNMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__POSITION = ASSIGNMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION__EXP_POSITION = ASSIGNMENT__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Boolean Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXPRESSION_FEATURE_COUNT = ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ComparisonImpl <em>Comparison</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ComparisonImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getComparison()
	 * @generated
	 */
	int COMPARISON = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__ID = BOOLEAN_EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__ANNOTATIONS = BOOLEAN_EXPRESSION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__STATUS = BOOLEAN_EXPRESSION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__SISSY_ID = BOOLEAN_EXPRESSION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__POSITION = BOOLEAN_EXPRESSION__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON__EXP_POSITION = BOOLEAN_EXPRESSION__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Comparison</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_FEATURE_COUNT = BOOLEAN_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.TermImpl <em>Term</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.TermImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTerm()
	 * @generated
	 */
	int TERM = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__ID = COMPARISON__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__ANNOTATIONS = COMPARISON__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__STATUS = COMPARISON__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__SISSY_ID = COMPARISON__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__POSITION = COMPARISON__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__EXP_POSITION = COMPARISON__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Term</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_FEATURE_COUNT = COMPARISON_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ProductImpl <em>Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ProductImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProduct()
	 * @generated
	 */
	int PRODUCT = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__ANNOTATIONS = TERM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__STATUS = TERM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__SISSY_ID = TERM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__POSITION = TERM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__EXP_POSITION = TERM__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_FEATURE_COUNT = TERM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.UnaryImpl <em>Unary</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.UnaryImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnary()
	 * @generated
	 */
	int UNARY = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__ID = PRODUCT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__ANNOTATIONS = PRODUCT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__STATUS = PRODUCT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__SISSY_ID = PRODUCT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__POSITION = PRODUCT__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY__EXP_POSITION = PRODUCT__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Unary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FEATURE_COUNT = PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.MemberExpressionImpl <em>Member Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.MemberExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getMemberExpression()
	 * @generated
	 */
	int MEMBER_EXPRESSION = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__ID = UNARY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__ANNOTATIONS = UNARY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__STATUS = UNARY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__SISSY_ID = UNARY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__POSITION = UNARY__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION__EXP_POSITION = UNARY__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Member Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_EXPRESSION_FEATURE_COUNT = UNARY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ParenthesisImpl <em>Parenthesis</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ParenthesisImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getParenthesis()
	 * @generated
	 */
	int PARENTHESIS = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__ID = MEMBER_EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__ANNOTATIONS = MEMBER_EXPRESSION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__STATUS = MEMBER_EXPRESSION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__SISSY_ID = MEMBER_EXPRESSION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__POSITION = MEMBER_EXPRESSION__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS__EXP_POSITION = MEMBER_EXPRESSION__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Parenthesis</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_FEATURE_COUNT = MEMBER_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.AtomImpl <em>Atom</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.AtomImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAtom()
	 * @generated
	 */
	int ATOM = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__ID = PARENTHESIS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__ANNOTATIONS = PARENTHESIS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__STATUS = PARENTHESIS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__SISSY_ID = PARENTHESIS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__POSITION = PARENTHESIS__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM__EXP_POSITION = PARENTHESIS__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Atom</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATOM_FEATURE_COUNT = PARENTHESIS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.VariableImpl <em>Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.VariableImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getVariable()
	 * @generated
	 */
	int VARIABLE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Variable Access</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__VARIABLE_ACCESS = ATOM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arrayvalueselection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE__ARRAYVALUESELECTION = ATOM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_FEATURE_COUNT = ATOM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ExpPositionImpl <em>Exp Position</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ExpPositionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpPosition()
	 * @generated
	 */
	int EXP_POSITION = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__ID = corePackage.IDENTIFIER__ID;

	/**
	 * The feature id for the '<em><b>Start Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__START_LINE = corePackage.IDENTIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__END_LINE = corePackage.IDENTIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Start Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__START_COLUMN = corePackage.IDENTIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>End Column</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__END_COLUMN = corePackage.IDENTIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>File Sissy ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__FILE_SISSY_ID = corePackage.IDENTIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>File</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION__FILE = corePackage.IDENTIFIER_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Exp Position</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_POSITION_FEATURE_COUNT = corePackage.IDENTIFIER_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ReferenceImpl <em>Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ReferenceImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getReference()
	 * @generated
	 */
	int REFERENCE = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_FEATURE_COUNT = ATOM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.LvalueImpl <em>Lvalue</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.LvalueImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getLvalue()
	 * @generated
	 */
	int LVALUE = 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__ID = REFERENCE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__ANNOTATIONS = REFERENCE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__STATUS = REFERENCE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__SISSY_ID = REFERENCE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__POSITION = REFERENCE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE__EXP_POSITION = REFERENCE__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Lvalue</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LVALUE_FEATURE_COUNT = REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ArrayValueSelectionImpl <em>Array Value Selection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ArrayValueSelectionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getArrayValueSelection()
	 * @generated
	 */
	int ARRAY_VALUE_SELECTION = 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__ID = REFERENCE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__ANNOTATIONS = REFERENCE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__STATUS = REFERENCE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__SISSY_ID = REFERENCE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__POSITION = REFERENCE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__EXP_POSITION = REFERENCE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Index</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION__INDEX = REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Array Value Selection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_VALUE_SELECTION_FEATURE_COUNT = REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.TermExpressionImpl <em>Term Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.TermExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTermExpression()
	 * @generated
	 */
	int TERM_EXPRESSION = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__ANNOTATIONS = TERM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__STATUS = TERM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__SISSY_ID = TERM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__POSITION = TERM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__EXP_POSITION = TERM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__OPERATION = TERM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__LEFT = TERM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION__RIGHT = TERM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Term Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_EXPRESSION_FEATURE_COUNT = TERM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ProductExpressionImpl <em>Product Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ProductExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProductExpression()
	 * @generated
	 */
	int PRODUCT_EXPRESSION = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__ID = PRODUCT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__ANNOTATIONS = PRODUCT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__STATUS = PRODUCT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__SISSY_ID = PRODUCT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__POSITION = PRODUCT__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__EXP_POSITION = PRODUCT__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__OPERATION = PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__LEFT = PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION__RIGHT = PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Product Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_EXPRESSION_FEATURE_COUNT = PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ParenthesisExpressionImpl <em>Parenthesis Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ParenthesisExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getParenthesisExpression()
	 * @generated
	 */
	int PARENTHESIS_EXPRESSION = 17;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION__INNER = ATOM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parenthesis Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENTHESIS_EXPRESSION_FEATURE_COUNT = ATOM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.NumericLiteralImpl <em>Numeric Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.NumericLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNumericLiteral()
	 * @generated
	 */
	int NUMERIC_LITERAL = 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Numeric Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_LITERAL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.IntLiteralImpl <em>Int Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.IntLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getIntLiteral()
	 * @generated
	 */
	int INT_LITERAL = 19;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__ID = NUMERIC_LITERAL__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__ANNOTATIONS = NUMERIC_LITERAL__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__STATUS = NUMERIC_LITERAL__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__SISSY_ID = NUMERIC_LITERAL__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__POSITION = NUMERIC_LITERAL__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__EXP_POSITION = NUMERIC_LITERAL__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL__VALUE = NUMERIC_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Int Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL_FEATURE_COUNT = NUMERIC_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.DoubleLiteralImpl <em>Double Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.DoubleLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getDoubleLiteral()
	 * @generated
	 */
	int DOUBLE_LITERAL = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__ID = NUMERIC_LITERAL__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__ANNOTATIONS = NUMERIC_LITERAL__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__STATUS = NUMERIC_LITERAL__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__SISSY_ID = NUMERIC_LITERAL__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__POSITION = NUMERIC_LITERAL__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__EXP_POSITION = NUMERIC_LITERAL__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__VALUE = NUMERIC_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Double Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL_FEATURE_COUNT = NUMERIC_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.CompareExpressionImpl <em>Compare Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.CompareExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCompareExpression()
	 * @generated
	 */
	int COMPARE_EXPRESSION = 21;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__ID = COMPARISON__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__ANNOTATIONS = COMPARISON__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__STATUS = COMPARISON__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__SISSY_ID = COMPARISON__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__POSITION = COMPARISON__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__EXP_POSITION = COMPARISON__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__OPERATION = COMPARISON_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__LEFT = COMPARISON_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION__RIGHT = COMPARISON_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Compare Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARE_EXPRESSION_FEATURE_COUNT = COMPARISON_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.BoolLiteralImpl <em>Bool Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.BoolLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBoolLiteral()
	 * @generated
	 */
	int BOOL_LITERAL = 22;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL__VALUE = ATOM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Bool Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOL_LITERAL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.StringLiteralImpl <em>String Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.StringLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getStringLiteral()
	 * @generated
	 */
	int STRING_LITERAL = 23;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL__VALUE = ATOM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.BooleanOperatorExpressionImpl <em>Boolean Operator Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.BooleanOperatorExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanOperatorExpression()
	 * @generated
	 */
	int BOOLEAN_OPERATOR_EXPRESSION = 24;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__ID = BOOLEAN_EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__ANNOTATIONS = BOOLEAN_EXPRESSION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__STATUS = BOOLEAN_EXPRESSION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__SISSY_ID = BOOLEAN_EXPRESSION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__POSITION = BOOLEAN_EXPRESSION__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__EXP_POSITION = BOOLEAN_EXPRESSION__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__OPERATION = BOOLEAN_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__LEFT = BOOLEAN_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION__RIGHT = BOOLEAN_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Boolean Operator Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OPERATOR_EXPRESSION_FEATURE_COUNT = BOOLEAN_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.NotExpressionImpl <em>Not Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.NotExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNotExpression()
	 * @generated
	 */
	int NOT_EXPRESSION = 25;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__ID = UNARY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__ANNOTATIONS = UNARY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__STATUS = UNARY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__SISSY_ID = UNARY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__POSITION = UNARY__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__EXP_POSITION = UNARY__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION__INNER = UNARY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Not Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EXPRESSION_FEATURE_COUNT = UNARY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.UnaryArithmeticExpressionImpl <em>Unary Arithmetic Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.UnaryArithmeticExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnaryArithmeticExpression()
	 * @generated
	 */
	int UNARY_ARITHMETIC_EXPRESSION = 26;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__ID = LVALUE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__ANNOTATIONS = LVALUE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__STATUS = LVALUE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__SISSY_ID = LVALUE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__POSITION = LVALUE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__EXP_POSITION = LVALUE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__OPERATION = LVALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION__INNER = LVALUE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Unary Arithmetic Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_ARITHMETIC_EXPRESSION_FEATURE_COUNT = LVALUE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.FunctionCallImpl <em>Function Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.FunctionCallImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getFunctionCall()
	 * @generated
	 */
	int FUNCTION_CALL = 27;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__FUNCTION = ATOM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameterexpression</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__PARAMETEREXPRESSION = ATOM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Arrayvalueselection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL__ARRAYVALUESELECTION = ATOM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Function Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ConditionalImpl <em>Conditional</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ConditionalImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getConditional()
	 * @generated
	 */
	int CONDITIONAL = 28;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__ID = BOOLEAN_EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__ANNOTATIONS = BOOLEAN_EXPRESSION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__STATUS = BOOLEAN_EXPRESSION__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__SISSY_ID = BOOLEAN_EXPRESSION__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__POSITION = BOOLEAN_EXPRESSION__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__EXP_POSITION = BOOLEAN_EXPRESSION__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__CONDITION = BOOLEAN_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Then</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__THEN = BOOLEAN_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Else</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL__ELSE = BOOLEAN_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Conditional</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_FEATURE_COUNT = BOOLEAN_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.MemberAccessorImpl <em>Member Accessor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.MemberAccessorImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getMemberAccessor()
	 * @generated
	 */
	int MEMBER_ACCESSOR = 29;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__ID = LVALUE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__ANNOTATIONS = LVALUE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__STATUS = LVALUE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__SISSY_ID = LVALUE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__POSITION = LVALUE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__EXP_POSITION = LVALUE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__RIGHT = LVALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR__LEFT = LVALUE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Member Accessor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_ACCESSOR_FEATURE_COUNT = LVALUE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.TypeReferenceImpl <em>Type Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.TypeReferenceImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTypeReference()
	 * @generated
	 */
	int TYPE_REFERENCE = 30;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__ID = REFERENCE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__ANNOTATIONS = REFERENCE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__STATUS = REFERENCE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__SISSY_ID = REFERENCE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__POSITION = REFERENCE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__EXP_POSITION = REFERENCE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Typeaccess</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE__TYPEACCESS = REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Type Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_FEATURE_COUNT = REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.CastExpressionImpl <em>Cast Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.CastExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCastExpression()
	 * @generated
	 */
	int CAST_EXPRESSION = 31;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__ANNOTATIONS = TERM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__STATUS = TERM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__SISSY_ID = TERM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__POSITION = TERM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__EXP_POSITION = TERM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__TYPE = TERM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__EXPRESSION = TERM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Cast Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION_FEATURE_COUNT = TERM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.AssignmentOperatorExpressionImpl <em>Assignment Operator Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.AssignmentOperatorExpressionImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignmentOperatorExpression()
	 * @generated
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION = 32;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__ID = ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__ANNOTATIONS = ASSIGNMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__STATUS = ASSIGNMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__SISSY_ID = ASSIGNMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__POSITION = ASSIGNMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__EXP_POSITION = ASSIGNMENT__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__LEFT = ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__RIGHT = ASSIGNMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION__OPERATION = ASSIGNMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Assignment Operator Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATOR_EXPRESSION_FEATURE_COUNT = ASSIGNMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.CharLiteralImpl <em>Char Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.CharLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCharLiteral()
	 * @generated
	 */
	int CHAR_LITERAL = 33;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL__VALUE = ATOM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Char Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAR_LITERAL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.VariablePlaceholderImpl <em>Variable Placeholder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.VariablePlaceholderImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getVariablePlaceholder()
	 * @generated
	 */
	int VARIABLE_PLACEHOLDER = 34;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__ID = VARIABLE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__ANNOTATIONS = VARIABLE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__STATUS = VARIABLE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__SISSY_ID = VARIABLE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__POSITION = VARIABLE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__EXP_POSITION = VARIABLE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Variable Access</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__VARIABLE_ACCESS = VARIABLE__VARIABLE_ACCESS;

	/**
	 * The feature id for the '<em><b>Arrayvalueselection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__ARRAYVALUESELECTION = VARIABLE__ARRAYVALUESELECTION;

	/**
	 * The feature id for the '<em><b>Sissy Model Element ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID = VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Variable Placeholder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_PLACEHOLDER_FEATURE_COUNT = VARIABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.SISSyPlaceholderImpl <em>SIS Sy Placeholder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.SISSyPlaceholderImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getSISSyPlaceholder()
	 * @generated
	 */
	int SIS_SY_PLACEHOLDER = 35;

	/**
	 * The feature id for the '<em><b>Sissy Model Element ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIS_SY_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID = 0;

	/**
	 * The number of structural features of the '<em>SIS Sy Placeholder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIS_SY_PLACEHOLDER_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.FunctionCallPlaceholderImpl <em>Function Call Placeholder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.FunctionCallPlaceholderImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getFunctionCallPlaceholder()
	 * @generated
	 */
	int FUNCTION_CALL_PLACEHOLDER = 36;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__ID = FUNCTION_CALL__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__ANNOTATIONS = FUNCTION_CALL__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__STATUS = FUNCTION_CALL__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__SISSY_ID = FUNCTION_CALL__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__POSITION = FUNCTION_CALL__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__EXP_POSITION = FUNCTION_CALL__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__FUNCTION = FUNCTION_CALL__FUNCTION;

	/**
	 * The feature id for the '<em><b>Parameterexpression</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__PARAMETEREXPRESSION = FUNCTION_CALL__PARAMETEREXPRESSION;

	/**
	 * The feature id for the '<em><b>Arrayvalueselection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__ARRAYVALUESELECTION = FUNCTION_CALL__ARRAYVALUESELECTION;

	/**
	 * The feature id for the '<em><b>Sissy Model Element ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID = FUNCTION_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Function Call Placeholder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_CALL_PLACEHOLDER_FEATURE_COUNT = FUNCTION_CALL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.TypeReferencePlaceholderImpl <em>Type Reference Placeholder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.TypeReferencePlaceholderImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTypeReferencePlaceholder()
	 * @generated
	 */
	int TYPE_REFERENCE_PLACEHOLDER = 37;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__ID = TYPE_REFERENCE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__ANNOTATIONS = TYPE_REFERENCE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__STATUS = TYPE_REFERENCE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__SISSY_ID = TYPE_REFERENCE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__POSITION = TYPE_REFERENCE__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__EXP_POSITION = TYPE_REFERENCE__EXP_POSITION;

	/**
	 * The feature id for the '<em><b>Typeaccess</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__TYPEACCESS = TYPE_REFERENCE__TYPEACCESS;

	/**
	 * The feature id for the '<em><b>Sissy Model Element ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID = TYPE_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Type Reference Placeholder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REFERENCE_PLACEHOLDER_FEATURE_COUNT = TYPE_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ExpressionAnchorImpl <em>Expression Anchor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ExpressionAnchorImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionAnchor()
	 * @generated
	 */
	int EXPRESSION_ANCHOR = 38;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_ANCHOR__ID = corePackage.IDENTIFIER__ID;

	/**
	 * The feature id for the '<em><b>Sissy Model Element ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_ANCHOR__SISSY_MODEL_ELEMENT_ID = corePackage.IDENTIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Gastexpressionproxy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY = corePackage.IDENTIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expressionanchorkind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_ANCHOR__EXPRESSIONANCHORKIND = corePackage.IDENTIFIER_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Expression Anchor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_ANCHOR_FEATURE_COUNT = corePackage.IDENTIFIER_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.ExpressionsRootImpl <em>Expressions Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.ExpressionsRootImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionsRoot()
	 * @generated
	 */
	int EXPRESSIONS_ROOT = 39;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSIONS_ROOT__ID = corePackage.IDENTIFIER__ID;

	/**
	 * The feature id for the '<em><b>Expressionanchors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSIONS_ROOT__EXPRESSIONANCHORS = corePackage.IDENTIFIER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Expressions Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSIONS_ROOT_FEATURE_COUNT = corePackage.IDENTIFIER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.impl.NullLiteralImpl <em>Null Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.impl.NullLiteralImpl
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNullLiteral()
	 * @generated
	 */
	int NULL_LITERAL = 40;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__ID = ATOM__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__ANNOTATIONS = ATOM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__STATUS = ATOM__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__SISSY_ID = ATOM__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__POSITION = ATOM__POSITION;

	/**
	 * The feature id for the '<em><b>Exp Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__EXP_POSITION = ATOM__EXP_POSITION;

	/**
	 * The number of structural features of the '<em>Null Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL_FEATURE_COUNT = ATOM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.TermOperations <em>Term Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.TermOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTermOperations()
	 * @generated
	 */
	int TERM_OPERATIONS = 41;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.ProductOperations <em>Product Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.ProductOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProductOperations()
	 * @generated
	 */
	int PRODUCT_OPERATIONS = 42;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.CompareOperations <em>Compare Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.CompareOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCompareOperations()
	 * @generated
	 */
	int COMPARE_OPERATIONS = 43;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.BooleanOperations <em>Boolean Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.BooleanOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanOperations()
	 * @generated
	 */
	int BOOLEAN_OPERATIONS = 44;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.UnaryOperations <em>Unary Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.UnaryOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnaryOperations()
	 * @generated
	 */
	int UNARY_OPERATIONS = 45;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.AssignmentOperations <em>Assignment Operations</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.AssignmentOperations
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignmentOperations()
	 * @generated
	 */
	int ASSIGNMENT_OPERATIONS = 46;

	/**
	 * The meta object id for the '{@link de.fzi.gast.expressions.ExpressionAnchorKind <em>Expression Anchor Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.expressions.ExpressionAnchorKind
	 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionAnchorKind()
	 * @generated
	 */
	int EXPRESSION_ANCHOR_KIND = 47;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable</em>'.
	 * @see de.fzi.gast.expressions.Variable
	 * @generated
	 */
	EClass getVariable();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.Variable#getVariableAccess <em>Variable Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Variable Access</em>'.
	 * @see de.fzi.gast.expressions.Variable#getVariableAccess()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_VariableAccess();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.Variable#getArrayvalueselection <em>Arrayvalueselection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Arrayvalueselection</em>'.
	 * @see de.fzi.gast.expressions.Variable#getArrayvalueselection()
	 * @see #getVariable()
	 * @generated
	 */
	EReference getVariable_Arrayvalueselection();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Atom <em>Atom</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Atom</em>'.
	 * @see de.fzi.gast.expressions.Atom
	 * @generated
	 */
	EClass getAtom();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Parenthesis <em>Parenthesis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parenthesis</em>'.
	 * @see de.fzi.gast.expressions.Parenthesis
	 * @generated
	 */
	EClass getParenthesis();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.MemberExpression <em>Member Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member Expression</em>'.
	 * @see de.fzi.gast.expressions.MemberExpression
	 * @generated
	 */
	EClass getMemberExpression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Unary <em>Unary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary</em>'.
	 * @see de.fzi.gast.expressions.Unary
	 * @generated
	 */
	EClass getUnary();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Product <em>Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Product</em>'.
	 * @see de.fzi.gast.expressions.Product
	 * @generated
	 */
	EClass getProduct();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Term <em>Term</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Term</em>'.
	 * @see de.fzi.gast.expressions.Term
	 * @generated
	 */
	EClass getTerm();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Comparison <em>Comparison</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comparison</em>'.
	 * @see de.fzi.gast.expressions.Comparison
	 * @generated
	 */
	EClass getComparison();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.BooleanExpression <em>Boolean Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Expression</em>'.
	 * @see de.fzi.gast.expressions.BooleanExpression
	 * @generated
	 */
	EClass getBooleanExpression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see de.fzi.gast.expressions.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.GASTExpressionProxy <em>GAST Expression Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Expression Proxy</em>'.
	 * @see de.fzi.gast.expressions.GASTExpressionProxy
	 * @generated
	 */
	EClass getGASTExpressionProxy();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.GASTExpressionProxy#getExpPosition <em>Exp Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Exp Position</em>'.
	 * @see de.fzi.gast.expressions.GASTExpressionProxy#getExpPosition()
	 * @see #getGASTExpressionProxy()
	 * @generated
	 */
	EReference getGASTExpressionProxy_ExpPosition();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ExpPosition <em>Exp Position</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Exp Position</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition
	 * @generated
	 */
	EClass getExpPosition();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpPosition#getStartLine <em>Start Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Line</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getStartLine()
	 * @see #getExpPosition()
	 * @generated
	 */
	EAttribute getExpPosition_StartLine();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpPosition#getEndLine <em>End Line</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Line</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getEndLine()
	 * @see #getExpPosition()
	 * @generated
	 */
	EAttribute getExpPosition_EndLine();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpPosition#getStartColumn <em>Start Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Column</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getStartColumn()
	 * @see #getExpPosition()
	 * @generated
	 */
	EAttribute getExpPosition_StartColumn();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpPosition#getEndColumn <em>End Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Column</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getEndColumn()
	 * @see #getExpPosition()
	 * @generated
	 */
	EAttribute getExpPosition_EndColumn();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpPosition#getFileSissyID <em>File Sissy ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>File Sissy ID</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getFileSissyID()
	 * @see #getExpPosition()
	 * @generated
	 */
	EAttribute getExpPosition_FileSissyID();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.expressions.ExpPosition#getFile <em>File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>File</em>'.
	 * @see de.fzi.gast.expressions.ExpPosition#getFile()
	 * @see #getExpPosition()
	 * @generated
	 */
	EReference getExpPosition_File();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Reference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference</em>'.
	 * @see de.fzi.gast.expressions.Reference
	 * @generated
	 */
	EClass getReference();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Lvalue <em>Lvalue</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Lvalue</em>'.
	 * @see de.fzi.gast.expressions.Lvalue
	 * @generated
	 */
	EClass getLvalue();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ArrayValueSelection <em>Array Value Selection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Value Selection</em>'.
	 * @see de.fzi.gast.expressions.ArrayValueSelection
	 * @generated
	 */
	EClass getArrayValueSelection();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.expressions.ArrayValueSelection#getIndex <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Index</em>'.
	 * @see de.fzi.gast.expressions.ArrayValueSelection#getIndex()
	 * @see #getArrayValueSelection()
	 * @generated
	 */
	EReference getArrayValueSelection_Index();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.TermExpression <em>Term Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Term Expression</em>'.
	 * @see de.fzi.gast.expressions.TermExpression
	 * @generated
	 */
	EClass getTermExpression();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.TermExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.TermExpression#getOperation()
	 * @see #getTermExpression()
	 * @generated
	 */
	EAttribute getTermExpression_Operation();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.TermExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.TermExpression#getLeft()
	 * @see #getTermExpression()
	 * @generated
	 */
	EReference getTermExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.TermExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.TermExpression#getRight()
	 * @see #getTermExpression()
	 * @generated
	 */
	EReference getTermExpression_Right();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ProductExpression <em>Product Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Product Expression</em>'.
	 * @see de.fzi.gast.expressions.ProductExpression
	 * @generated
	 */
	EClass getProductExpression();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ProductExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.ProductExpression#getOperation()
	 * @see #getProductExpression()
	 * @generated
	 */
	EAttribute getProductExpression_Operation();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.ProductExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.ProductExpression#getLeft()
	 * @see #getProductExpression()
	 * @generated
	 */
	EReference getProductExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.ProductExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.ProductExpression#getRight()
	 * @see #getProductExpression()
	 * @generated
	 */
	EReference getProductExpression_Right();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ParenthesisExpression <em>Parenthesis Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parenthesis Expression</em>'.
	 * @see de.fzi.gast.expressions.ParenthesisExpression
	 * @generated
	 */
	EClass getParenthesisExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.ParenthesisExpression#getInner <em>Inner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Inner</em>'.
	 * @see de.fzi.gast.expressions.ParenthesisExpression#getInner()
	 * @see #getParenthesisExpression()
	 * @generated
	 */
	EReference getParenthesisExpression_Inner();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.NumericLiteral <em>Numeric Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Numeric Literal</em>'.
	 * @see de.fzi.gast.expressions.NumericLiteral
	 * @generated
	 */
	EClass getNumericLiteral();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.IntLiteral <em>Int Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Literal</em>'.
	 * @see de.fzi.gast.expressions.IntLiteral
	 * @generated
	 */
	EClass getIntLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.IntLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.fzi.gast.expressions.IntLiteral#getValue()
	 * @see #getIntLiteral()
	 * @generated
	 */
	EAttribute getIntLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.DoubleLiteral <em>Double Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Double Literal</em>'.
	 * @see de.fzi.gast.expressions.DoubleLiteral
	 * @generated
	 */
	EClass getDoubleLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.DoubleLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.fzi.gast.expressions.DoubleLiteral#getValue()
	 * @see #getDoubleLiteral()
	 * @generated
	 */
	EAttribute getDoubleLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.CompareExpression <em>Compare Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Compare Expression</em>'.
	 * @see de.fzi.gast.expressions.CompareExpression
	 * @generated
	 */
	EClass getCompareExpression();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.CompareExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.CompareExpression#getOperation()
	 * @see #getCompareExpression()
	 * @generated
	 */
	EAttribute getCompareExpression_Operation();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.CompareExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.CompareExpression#getLeft()
	 * @see #getCompareExpression()
	 * @generated
	 */
	EReference getCompareExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.CompareExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.CompareExpression#getRight()
	 * @see #getCompareExpression()
	 * @generated
	 */
	EReference getCompareExpression_Right();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.BoolLiteral <em>Bool Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bool Literal</em>'.
	 * @see de.fzi.gast.expressions.BoolLiteral
	 * @generated
	 */
	EClass getBoolLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.BoolLiteral#isValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.fzi.gast.expressions.BoolLiteral#isValue()
	 * @see #getBoolLiteral()
	 * @generated
	 */
	EAttribute getBoolLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.StringLiteral <em>String Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Literal</em>'.
	 * @see de.fzi.gast.expressions.StringLiteral
	 * @generated
	 */
	EClass getStringLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.StringLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.fzi.gast.expressions.StringLiteral#getValue()
	 * @see #getStringLiteral()
	 * @generated
	 */
	EAttribute getStringLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.BooleanOperatorExpression <em>Boolean Operator Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Operator Expression</em>'.
	 * @see de.fzi.gast.expressions.BooleanOperatorExpression
	 * @generated
	 */
	EClass getBooleanOperatorExpression();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.BooleanOperatorExpression#getOperation()
	 * @see #getBooleanOperatorExpression()
	 * @generated
	 */
	EAttribute getBooleanOperatorExpression_Operation();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.BooleanOperatorExpression#getLeft()
	 * @see #getBooleanOperatorExpression()
	 * @generated
	 */
	EReference getBooleanOperatorExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.BooleanOperatorExpression#getRight()
	 * @see #getBooleanOperatorExpression()
	 * @generated
	 */
	EReference getBooleanOperatorExpression_Right();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.NotExpression <em>Not Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Not Expression</em>'.
	 * @see de.fzi.gast.expressions.NotExpression
	 * @generated
	 */
	EClass getNotExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.NotExpression#getInner <em>Inner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Inner</em>'.
	 * @see de.fzi.gast.expressions.NotExpression#getInner()
	 * @see #getNotExpression()
	 * @generated
	 */
	EReference getNotExpression_Inner();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.UnaryArithmeticExpression <em>Unary Arithmetic Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Arithmetic Expression</em>'.
	 * @see de.fzi.gast.expressions.UnaryArithmeticExpression
	 * @generated
	 */
	EClass getUnaryArithmeticExpression();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.UnaryArithmeticExpression#getOperation()
	 * @see #getUnaryArithmeticExpression()
	 * @generated
	 */
	EAttribute getUnaryArithmeticExpression_Operation();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getInner <em>Inner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Inner</em>'.
	 * @see de.fzi.gast.expressions.UnaryArithmeticExpression#getInner()
	 * @see #getUnaryArithmeticExpression()
	 * @generated
	 */
	EReference getUnaryArithmeticExpression_Inner();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.FunctionCall <em>Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Call</em>'.
	 * @see de.fzi.gast.expressions.FunctionCall
	 * @generated
	 */
	EClass getFunctionCall();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.FunctionCall#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Function</em>'.
	 * @see de.fzi.gast.expressions.FunctionCall#getFunction()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EReference getFunctionCall_Function();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.expressions.FunctionCall#getParameterexpression <em>Parameterexpression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameterexpression</em>'.
	 * @see de.fzi.gast.expressions.FunctionCall#getParameterexpression()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EReference getFunctionCall_Parameterexpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.FunctionCall#getArrayvalueselection <em>Arrayvalueselection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Arrayvalueselection</em>'.
	 * @see de.fzi.gast.expressions.FunctionCall#getArrayvalueselection()
	 * @see #getFunctionCall()
	 * @generated
	 */
	EReference getFunctionCall_Arrayvalueselection();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.Conditional <em>Conditional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Conditional</em>'.
	 * @see de.fzi.gast.expressions.Conditional
	 * @generated
	 */
	EClass getConditional();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.Conditional#getCondition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Condition</em>'.
	 * @see de.fzi.gast.expressions.Conditional#getCondition()
	 * @see #getConditional()
	 * @generated
	 */
	EReference getConditional_Condition();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.Conditional#getThen <em>Then</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Then</em>'.
	 * @see de.fzi.gast.expressions.Conditional#getThen()
	 * @see #getConditional()
	 * @generated
	 */
	EReference getConditional_Then();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.Conditional#getElse <em>Else</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Else</em>'.
	 * @see de.fzi.gast.expressions.Conditional#getElse()
	 * @see #getConditional()
	 * @generated
	 */
	EReference getConditional_Else();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.MemberAccessor <em>Member Accessor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member Accessor</em>'.
	 * @see de.fzi.gast.expressions.MemberAccessor
	 * @generated
	 */
	EClass getMemberAccessor();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.MemberAccessor#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.MemberAccessor#getRight()
	 * @see #getMemberAccessor()
	 * @generated
	 */
	EReference getMemberAccessor_Right();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.MemberAccessor#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.MemberAccessor#getLeft()
	 * @see #getMemberAccessor()
	 * @generated
	 */
	EReference getMemberAccessor_Left();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.TypeReference <em>Type Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Reference</em>'.
	 * @see de.fzi.gast.expressions.TypeReference
	 * @generated
	 */
	EClass getTypeReference();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.TypeReference#getTypeaccess <em>Typeaccess</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Typeaccess</em>'.
	 * @see de.fzi.gast.expressions.TypeReference#getTypeaccess()
	 * @see #getTypeReference()
	 * @generated
	 */
	EReference getTypeReference_Typeaccess();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.CastExpression <em>Cast Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cast Expression</em>'.
	 * @see de.fzi.gast.expressions.CastExpression
	 * @generated
	 */
	EClass getCastExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.CastExpression#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see de.fzi.gast.expressions.CastExpression#getType()
	 * @see #getCastExpression()
	 * @generated
	 */
	EReference getCastExpression_Type();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.CastExpression#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see de.fzi.gast.expressions.CastExpression#getExpression()
	 * @see #getCastExpression()
	 * @generated
	 */
	EReference getCastExpression_Expression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.AssignmentOperatorExpression <em>Assignment Operator Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment Operator Expression</em>'.
	 * @see de.fzi.gast.expressions.AssignmentOperatorExpression
	 * @generated
	 */
	EClass getAssignmentOperatorExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see de.fzi.gast.expressions.AssignmentOperatorExpression#getLeft()
	 * @see #getAssignmentOperatorExpression()
	 * @generated
	 */
	EReference getAssignmentOperatorExpression_Left();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see de.fzi.gast.expressions.AssignmentOperatorExpression#getRight()
	 * @see #getAssignmentOperatorExpression()
	 * @generated
	 */
	EReference getAssignmentOperatorExpression_Right();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see de.fzi.gast.expressions.AssignmentOperatorExpression#getOperation()
	 * @see #getAssignmentOperatorExpression()
	 * @generated
	 */
	EAttribute getAssignmentOperatorExpression_Operation();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.CharLiteral <em>Char Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Char Literal</em>'.
	 * @see de.fzi.gast.expressions.CharLiteral
	 * @generated
	 */
	EClass getCharLiteral();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.CharLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see de.fzi.gast.expressions.CharLiteral#getValue()
	 * @see #getCharLiteral()
	 * @generated
	 */
	EAttribute getCharLiteral_Value();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.VariablePlaceholder <em>Variable Placeholder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variable Placeholder</em>'.
	 * @see de.fzi.gast.expressions.VariablePlaceholder
	 * @generated
	 */
	EClass getVariablePlaceholder();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.SISSyPlaceholder <em>SIS Sy Placeholder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SIS Sy Placeholder</em>'.
	 * @see de.fzi.gast.expressions.SISSyPlaceholder
	 * @generated
	 */
	EClass getSISSyPlaceholder();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.SISSyPlaceholder#getSissyModelElementID <em>Sissy Model Element ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sissy Model Element ID</em>'.
	 * @see de.fzi.gast.expressions.SISSyPlaceholder#getSissyModelElementID()
	 * @see #getSISSyPlaceholder()
	 * @generated
	 */
	EAttribute getSISSyPlaceholder_SissyModelElementID();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.FunctionCallPlaceholder <em>Function Call Placeholder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function Call Placeholder</em>'.
	 * @see de.fzi.gast.expressions.FunctionCallPlaceholder
	 * @generated
	 */
	EClass getFunctionCallPlaceholder();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.TypeReferencePlaceholder <em>Type Reference Placeholder</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Reference Placeholder</em>'.
	 * @see de.fzi.gast.expressions.TypeReferencePlaceholder
	 * @generated
	 */
	EClass getTypeReferencePlaceholder();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ExpressionAnchor <em>Expression Anchor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expression Anchor</em>'.
	 * @see de.fzi.gast.expressions.ExpressionAnchor
	 * @generated
	 */
	EClass getExpressionAnchor();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.expressions.ExpressionAnchor#getGastexpressionproxy <em>Gastexpressionproxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Gastexpressionproxy</em>'.
	 * @see de.fzi.gast.expressions.ExpressionAnchor#getGastexpressionproxy()
	 * @see #getExpressionAnchor()
	 * @generated
	 */
	EReference getExpressionAnchor_Gastexpressionproxy();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.expressions.ExpressionAnchor#getExpressionanchorkind <em>Expressionanchorkind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Expressionanchorkind</em>'.
	 * @see de.fzi.gast.expressions.ExpressionAnchor#getExpressionanchorkind()
	 * @see #getExpressionAnchor()
	 * @generated
	 */
	EAttribute getExpressionAnchor_Expressionanchorkind();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.ExpressionsRoot <em>Expressions Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expressions Root</em>'.
	 * @see de.fzi.gast.expressions.ExpressionsRoot
	 * @generated
	 */
	EClass getExpressionsRoot();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.expressions.ExpressionsRoot#getExpressionanchors <em>Expressionanchors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expressionanchors</em>'.
	 * @see de.fzi.gast.expressions.ExpressionsRoot#getExpressionanchors()
	 * @see #getExpressionsRoot()
	 * @generated
	 */
	EReference getExpressionsRoot_Expressionanchors();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.expressions.NullLiteral <em>Null Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Literal</em>'.
	 * @see de.fzi.gast.expressions.NullLiteral
	 * @generated
	 */
	EClass getNullLiteral();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.TermOperations <em>Term Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Term Operations</em>'.
	 * @see de.fzi.gast.expressions.TermOperations
	 * @generated
	 */
	EEnum getTermOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.ProductOperations <em>Product Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Product Operations</em>'.
	 * @see de.fzi.gast.expressions.ProductOperations
	 * @generated
	 */
	EEnum getProductOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.CompareOperations <em>Compare Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Compare Operations</em>'.
	 * @see de.fzi.gast.expressions.CompareOperations
	 * @generated
	 */
	EEnum getCompareOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.BooleanOperations <em>Boolean Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Boolean Operations</em>'.
	 * @see de.fzi.gast.expressions.BooleanOperations
	 * @generated
	 */
	EEnum getBooleanOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.UnaryOperations <em>Unary Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Unary Operations</em>'.
	 * @see de.fzi.gast.expressions.UnaryOperations
	 * @generated
	 */
	EEnum getUnaryOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.AssignmentOperations <em>Assignment Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Assignment Operations</em>'.
	 * @see de.fzi.gast.expressions.AssignmentOperations
	 * @generated
	 */
	EEnum getAssignmentOperations();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.expressions.ExpressionAnchorKind <em>Expression Anchor Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Expression Anchor Kind</em>'.
	 * @see de.fzi.gast.expressions.ExpressionAnchorKind
	 * @generated
	 */
	EEnum getExpressionAnchorKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	expressionsFactory getexpressionsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.VariableImpl <em>Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.VariableImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getVariable()
		 * @generated
		 */
		EClass VARIABLE = eINSTANCE.getVariable();

		/**
		 * The meta object literal for the '<em><b>Variable Access</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__VARIABLE_ACCESS = eINSTANCE.getVariable_VariableAccess();

		/**
		 * The meta object literal for the '<em><b>Arrayvalueselection</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VARIABLE__ARRAYVALUESELECTION = eINSTANCE.getVariable_Arrayvalueselection();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.AtomImpl <em>Atom</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.AtomImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAtom()
		 * @generated
		 */
		EClass ATOM = eINSTANCE.getAtom();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ParenthesisImpl <em>Parenthesis</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ParenthesisImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getParenthesis()
		 * @generated
		 */
		EClass PARENTHESIS = eINSTANCE.getParenthesis();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.MemberExpressionImpl <em>Member Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.MemberExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getMemberExpression()
		 * @generated
		 */
		EClass MEMBER_EXPRESSION = eINSTANCE.getMemberExpression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.UnaryImpl <em>Unary</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.UnaryImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnary()
		 * @generated
		 */
		EClass UNARY = eINSTANCE.getUnary();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ProductImpl <em>Product</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ProductImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProduct()
		 * @generated
		 */
		EClass PRODUCT = eINSTANCE.getProduct();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.TermImpl <em>Term</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.TermImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTerm()
		 * @generated
		 */
		EClass TERM = eINSTANCE.getTerm();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ComparisonImpl <em>Comparison</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ComparisonImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getComparison()
		 * @generated
		 */
		EClass COMPARISON = eINSTANCE.getComparison();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.BooleanExpressionImpl <em>Boolean Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.BooleanExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanExpression()
		 * @generated
		 */
		EClass BOOLEAN_EXPRESSION = eINSTANCE.getBooleanExpression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.AssignmentImpl <em>Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.AssignmentImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT = eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.GASTExpressionProxyImpl <em>GAST Expression Proxy</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.GASTExpressionProxyImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getGASTExpressionProxy()
		 * @generated
		 */
		EClass GAST_EXPRESSION_PROXY = eINSTANCE.getGASTExpressionProxy();

		/**
		 * The meta object literal for the '<em><b>Exp Position</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_EXPRESSION_PROXY__EXP_POSITION = eINSTANCE.getGASTExpressionProxy_ExpPosition();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ExpPositionImpl <em>Exp Position</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ExpPositionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpPosition()
		 * @generated
		 */
		EClass EXP_POSITION = eINSTANCE.getExpPosition();

		/**
		 * The meta object literal for the '<em><b>Start Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXP_POSITION__START_LINE = eINSTANCE.getExpPosition_StartLine();

		/**
		 * The meta object literal for the '<em><b>End Line</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXP_POSITION__END_LINE = eINSTANCE.getExpPosition_EndLine();

		/**
		 * The meta object literal for the '<em><b>Start Column</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXP_POSITION__START_COLUMN = eINSTANCE.getExpPosition_StartColumn();

		/**
		 * The meta object literal for the '<em><b>End Column</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXP_POSITION__END_COLUMN = eINSTANCE.getExpPosition_EndColumn();

		/**
		 * The meta object literal for the '<em><b>File Sissy ID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXP_POSITION__FILE_SISSY_ID = eINSTANCE.getExpPosition_FileSissyID();

		/**
		 * The meta object literal for the '<em><b>File</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXP_POSITION__FILE = eINSTANCE.getExpPosition_File();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ReferenceImpl <em>Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ReferenceImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getReference()
		 * @generated
		 */
		EClass REFERENCE = eINSTANCE.getReference();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.LvalueImpl <em>Lvalue</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.LvalueImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getLvalue()
		 * @generated
		 */
		EClass LVALUE = eINSTANCE.getLvalue();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ArrayValueSelectionImpl <em>Array Value Selection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ArrayValueSelectionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getArrayValueSelection()
		 * @generated
		 */
		EClass ARRAY_VALUE_SELECTION = eINSTANCE.getArrayValueSelection();

		/**
		 * The meta object literal for the '<em><b>Index</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ARRAY_VALUE_SELECTION__INDEX = eINSTANCE.getArrayValueSelection_Index();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.TermExpressionImpl <em>Term Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.TermExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTermExpression()
		 * @generated
		 */
		EClass TERM_EXPRESSION = eINSTANCE.getTermExpression();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TERM_EXPRESSION__OPERATION = eINSTANCE.getTermExpression_Operation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TERM_EXPRESSION__LEFT = eINSTANCE.getTermExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TERM_EXPRESSION__RIGHT = eINSTANCE.getTermExpression_Right();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ProductExpressionImpl <em>Product Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ProductExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProductExpression()
		 * @generated
		 */
		EClass PRODUCT_EXPRESSION = eINSTANCE.getProductExpression();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRODUCT_EXPRESSION__OPERATION = eINSTANCE.getProductExpression_Operation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRODUCT_EXPRESSION__LEFT = eINSTANCE.getProductExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRODUCT_EXPRESSION__RIGHT = eINSTANCE.getProductExpression_Right();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ParenthesisExpressionImpl <em>Parenthesis Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ParenthesisExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getParenthesisExpression()
		 * @generated
		 */
		EClass PARENTHESIS_EXPRESSION = eINSTANCE.getParenthesisExpression();

		/**
		 * The meta object literal for the '<em><b>Inner</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARENTHESIS_EXPRESSION__INNER = eINSTANCE.getParenthesisExpression_Inner();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.NumericLiteralImpl <em>Numeric Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.NumericLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNumericLiteral()
		 * @generated
		 */
		EClass NUMERIC_LITERAL = eINSTANCE.getNumericLiteral();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.IntLiteralImpl <em>Int Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.IntLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getIntLiteral()
		 * @generated
		 */
		EClass INT_LITERAL = eINSTANCE.getIntLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_LITERAL__VALUE = eINSTANCE.getIntLiteral_Value();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.DoubleLiteralImpl <em>Double Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.DoubleLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getDoubleLiteral()
		 * @generated
		 */
		EClass DOUBLE_LITERAL = eINSTANCE.getDoubleLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOUBLE_LITERAL__VALUE = eINSTANCE.getDoubleLiteral_Value();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.CompareExpressionImpl <em>Compare Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.CompareExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCompareExpression()
		 * @generated
		 */
		EClass COMPARE_EXPRESSION = eINSTANCE.getCompareExpression();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COMPARE_EXPRESSION__OPERATION = eINSTANCE.getCompareExpression_Operation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPARE_EXPRESSION__LEFT = eINSTANCE.getCompareExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPARE_EXPRESSION__RIGHT = eINSTANCE.getCompareExpression_Right();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.BoolLiteralImpl <em>Bool Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.BoolLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBoolLiteral()
		 * @generated
		 */
		EClass BOOL_LITERAL = eINSTANCE.getBoolLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BOOL_LITERAL__VALUE = eINSTANCE.getBoolLiteral_Value();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.StringLiteralImpl <em>String Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.StringLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getStringLiteral()
		 * @generated
		 */
		EClass STRING_LITERAL = eINSTANCE.getStringLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_LITERAL__VALUE = eINSTANCE.getStringLiteral_Value();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.BooleanOperatorExpressionImpl <em>Boolean Operator Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.BooleanOperatorExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanOperatorExpression()
		 * @generated
		 */
		EClass BOOLEAN_OPERATOR_EXPRESSION = eINSTANCE.getBooleanOperatorExpression();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BOOLEAN_OPERATOR_EXPRESSION__OPERATION = eINSTANCE.getBooleanOperatorExpression_Operation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BOOLEAN_OPERATOR_EXPRESSION__LEFT = eINSTANCE.getBooleanOperatorExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BOOLEAN_OPERATOR_EXPRESSION__RIGHT = eINSTANCE.getBooleanOperatorExpression_Right();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.NotExpressionImpl <em>Not Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.NotExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNotExpression()
		 * @generated
		 */
		EClass NOT_EXPRESSION = eINSTANCE.getNotExpression();

		/**
		 * The meta object literal for the '<em><b>Inner</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOT_EXPRESSION__INNER = eINSTANCE.getNotExpression_Inner();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.UnaryArithmeticExpressionImpl <em>Unary Arithmetic Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.UnaryArithmeticExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnaryArithmeticExpression()
		 * @generated
		 */
		EClass UNARY_ARITHMETIC_EXPRESSION = eINSTANCE.getUnaryArithmeticExpression();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UNARY_ARITHMETIC_EXPRESSION__OPERATION = eINSTANCE.getUnaryArithmeticExpression_Operation();

		/**
		 * The meta object literal for the '<em><b>Inner</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UNARY_ARITHMETIC_EXPRESSION__INNER = eINSTANCE.getUnaryArithmeticExpression_Inner();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.FunctionCallImpl <em>Function Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.FunctionCallImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getFunctionCall()
		 * @generated
		 */
		EClass FUNCTION_CALL = eINSTANCE.getFunctionCall();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_CALL__FUNCTION = eINSTANCE.getFunctionCall_Function();

		/**
		 * The meta object literal for the '<em><b>Parameterexpression</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_CALL__PARAMETEREXPRESSION = eINSTANCE.getFunctionCall_Parameterexpression();

		/**
		 * The meta object literal for the '<em><b>Arrayvalueselection</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION_CALL__ARRAYVALUESELECTION = eINSTANCE.getFunctionCall_Arrayvalueselection();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ConditionalImpl <em>Conditional</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ConditionalImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getConditional()
		 * @generated
		 */
		EClass CONDITIONAL = eINSTANCE.getConditional();

		/**
		 * The meta object literal for the '<em><b>Condition</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONDITIONAL__CONDITION = eINSTANCE.getConditional_Condition();

		/**
		 * The meta object literal for the '<em><b>Then</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONDITIONAL__THEN = eINSTANCE.getConditional_Then();

		/**
		 * The meta object literal for the '<em><b>Else</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONDITIONAL__ELSE = eINSTANCE.getConditional_Else();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.MemberAccessorImpl <em>Member Accessor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.MemberAccessorImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getMemberAccessor()
		 * @generated
		 */
		EClass MEMBER_ACCESSOR = eINSTANCE.getMemberAccessor();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_ACCESSOR__RIGHT = eINSTANCE.getMemberAccessor_Right();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER_ACCESSOR__LEFT = eINSTANCE.getMemberAccessor_Left();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.TypeReferenceImpl <em>Type Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.TypeReferenceImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTypeReference()
		 * @generated
		 */
		EClass TYPE_REFERENCE = eINSTANCE.getTypeReference();

		/**
		 * The meta object literal for the '<em><b>Typeaccess</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_REFERENCE__TYPEACCESS = eINSTANCE.getTypeReference_Typeaccess();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.CastExpressionImpl <em>Cast Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.CastExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCastExpression()
		 * @generated
		 */
		EClass CAST_EXPRESSION = eINSTANCE.getCastExpression();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAST_EXPRESSION__TYPE = eINSTANCE.getCastExpression_Type();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAST_EXPRESSION__EXPRESSION = eINSTANCE.getCastExpression_Expression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.AssignmentOperatorExpressionImpl <em>Assignment Operator Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.AssignmentOperatorExpressionImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignmentOperatorExpression()
		 * @generated
		 */
		EClass ASSIGNMENT_OPERATOR_EXPRESSION = eINSTANCE.getAssignmentOperatorExpression();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT_OPERATOR_EXPRESSION__LEFT = eINSTANCE.getAssignmentOperatorExpression_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT_OPERATOR_EXPRESSION__RIGHT = eINSTANCE.getAssignmentOperatorExpression_Right();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSIGNMENT_OPERATOR_EXPRESSION__OPERATION = eINSTANCE.getAssignmentOperatorExpression_Operation();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.CharLiteralImpl <em>Char Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.CharLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCharLiteral()
		 * @generated
		 */
		EClass CHAR_LITERAL = eINSTANCE.getCharLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHAR_LITERAL__VALUE = eINSTANCE.getCharLiteral_Value();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.VariablePlaceholderImpl <em>Variable Placeholder</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.VariablePlaceholderImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getVariablePlaceholder()
		 * @generated
		 */
		EClass VARIABLE_PLACEHOLDER = eINSTANCE.getVariablePlaceholder();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.SISSyPlaceholderImpl <em>SIS Sy Placeholder</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.SISSyPlaceholderImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getSISSyPlaceholder()
		 * @generated
		 */
		EClass SIS_SY_PLACEHOLDER = eINSTANCE.getSISSyPlaceholder();

		/**
		 * The meta object literal for the '<em><b>Sissy Model Element ID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIS_SY_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID = eINSTANCE.getSISSyPlaceholder_SissyModelElementID();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.FunctionCallPlaceholderImpl <em>Function Call Placeholder</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.FunctionCallPlaceholderImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getFunctionCallPlaceholder()
		 * @generated
		 */
		EClass FUNCTION_CALL_PLACEHOLDER = eINSTANCE.getFunctionCallPlaceholder();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.TypeReferencePlaceholderImpl <em>Type Reference Placeholder</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.TypeReferencePlaceholderImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTypeReferencePlaceholder()
		 * @generated
		 */
		EClass TYPE_REFERENCE_PLACEHOLDER = eINSTANCE.getTypeReferencePlaceholder();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ExpressionAnchorImpl <em>Expression Anchor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ExpressionAnchorImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionAnchor()
		 * @generated
		 */
		EClass EXPRESSION_ANCHOR = eINSTANCE.getExpressionAnchor();

		/**
		 * The meta object literal for the '<em><b>Gastexpressionproxy</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY = eINSTANCE.getExpressionAnchor_Gastexpressionproxy();

		/**
		 * The meta object literal for the '<em><b>Expressionanchorkind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXPRESSION_ANCHOR__EXPRESSIONANCHORKIND = eINSTANCE.getExpressionAnchor_Expressionanchorkind();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.ExpressionsRootImpl <em>Expressions Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.ExpressionsRootImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionsRoot()
		 * @generated
		 */
		EClass EXPRESSIONS_ROOT = eINSTANCE.getExpressionsRoot();

		/**
		 * The meta object literal for the '<em><b>Expressionanchors</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXPRESSIONS_ROOT__EXPRESSIONANCHORS = eINSTANCE.getExpressionsRoot_Expressionanchors();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.impl.NullLiteralImpl <em>Null Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.impl.NullLiteralImpl
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getNullLiteral()
		 * @generated
		 */
		EClass NULL_LITERAL = eINSTANCE.getNullLiteral();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.TermOperations <em>Term Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.TermOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getTermOperations()
		 * @generated
		 */
		EEnum TERM_OPERATIONS = eINSTANCE.getTermOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.ProductOperations <em>Product Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.ProductOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getProductOperations()
		 * @generated
		 */
		EEnum PRODUCT_OPERATIONS = eINSTANCE.getProductOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.CompareOperations <em>Compare Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.CompareOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getCompareOperations()
		 * @generated
		 */
		EEnum COMPARE_OPERATIONS = eINSTANCE.getCompareOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.BooleanOperations <em>Boolean Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.BooleanOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getBooleanOperations()
		 * @generated
		 */
		EEnum BOOLEAN_OPERATIONS = eINSTANCE.getBooleanOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.UnaryOperations <em>Unary Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.UnaryOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getUnaryOperations()
		 * @generated
		 */
		EEnum UNARY_OPERATIONS = eINSTANCE.getUnaryOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.AssignmentOperations <em>Assignment Operations</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.AssignmentOperations
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getAssignmentOperations()
		 * @generated
		 */
		EEnum ASSIGNMENT_OPERATIONS = eINSTANCE.getAssignmentOperations();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.expressions.ExpressionAnchorKind <em>Expression Anchor Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.expressions.ExpressionAnchorKind
		 * @see de.fzi.gast.expressions.impl.expressionsPackageImpl#getExpressionAnchorKind()
		 * @generated
		 */
		EEnum EXPRESSION_ANCHOR_KIND = eINSTANCE.getExpressionAnchorKind();

	}

} //expressionsPackage
