/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Unary Operations</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration holds the values specifying various unary operations, like predecrement --a, postincrement a++ or negation ~a.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.expressions.expressionsPackage#getUnaryOperations()
 * @model
 * @generated
 */
public enum UnaryOperations implements Enumerator {
	/**
	 * The '<em><b>ARRAYLENGTH</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ARRAYLENGTH_VALUE
	 * @generated
	 * @ordered
	 */
	ARRAYLENGTH(0, "ARRAYLENGTH", "ARRAYLENGTH"), /**
	 * The '<em><b>PREINCREMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PREINCREMENT_VALUE
	 * @generated
	 * @ordered
	 */
	PREINCREMENT(1, "PREINCREMENT", "PREINCREMENT"),

	/**
	 * The '<em><b>PREDECREMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PREDECREMENT_VALUE
	 * @generated
	 * @ordered
	 */
	PREDECREMENT(2, "PREDECREMENT", "PREDECREMENT"),

	/**
	 * The '<em><b>NEGATION</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NEGATION_VALUE
	 * @generated
	 * @ordered
	 */
	NEGATION(3, "NEGATION", "NEGATION"),

	/**
	 * The '<em><b>POSTINCREMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POSTINCREMENT_VALUE
	 * @generated
	 * @ordered
	 */
	POSTINCREMENT(4, "POSTINCREMENT", "POSTINCREMENT"),

	/**
	 * The '<em><b>POSTDECREMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POSTDECREMENT_VALUE
	 * @generated
	 * @ordered
	 */
	POSTDECREMENT(5, "POSTDECREMENT", "POSTDECREMENT"),

	/**
	 * The '<em><b>DEREFERENCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEREFERENCE_VALUE
	 * @generated
	 * @ordered
	 */
	DEREFERENCE(6, "DEREFERENCE", "DEREFERENCE"),

	/**
	 * The '<em><b>REFERENCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REFERENCE_VALUE
	 * @generated
	 * @ordered
	 */
	REFERENCE(7, "REFERENCE", "REFERENCE"),

	/**
	 * The '<em><b>SIZEOF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIZEOF_VALUE
	 * @generated
	 * @ordered
	 */
	SIZEOF(8, "SIZEOF", "SIZEOF"),

	/**
	 * The '<em><b>UNARYMINUS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNARYMINUS_VALUE
	 * @generated
	 * @ordered
	 */
	UNARYMINUS(9, "UNARYMINUS", "UNARYMINUS");

	/**
	 * The '<em><b>ARRAYLENGTH</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ARRAYLENGTH</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ARRAYLENGTH
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ARRAYLENGTH_VALUE = 0;

	/**
	 * The '<em><b>PREINCREMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PREINCREMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PREINCREMENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PREINCREMENT_VALUE = 1;

	/**
	 * The '<em><b>PREDECREMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PREDECREMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PREDECREMENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PREDECREMENT_VALUE = 2;

	/**
	 * The '<em><b>NEGATION</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NEGATION</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NEGATION
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NEGATION_VALUE = 3;

	/**
	 * The '<em><b>POSTINCREMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>POSTINCREMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POSTINCREMENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int POSTINCREMENT_VALUE = 4;

	/**
	 * The '<em><b>POSTDECREMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>POSTDECREMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POSTDECREMENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int POSTDECREMENT_VALUE = 5;

	/**
	 * The '<em><b>DEREFERENCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEREFERENCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEREFERENCE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEREFERENCE_VALUE = 6;

	/**
	 * The '<em><b>REFERENCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REFERENCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REFERENCE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REFERENCE_VALUE = 7;

	/**
	 * The '<em><b>SIZEOF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SIZEOF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SIZEOF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SIZEOF_VALUE = 8;

	/**
	 * The '<em><b>UNARYMINUS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>UNARYMINUS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNARYMINUS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNARYMINUS_VALUE = 9;

	/**
	 * An array of all the '<em><b>Unary Operations</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final UnaryOperations[] VALUES_ARRAY =
		new UnaryOperations[] {
			ARRAYLENGTH,
			PREINCREMENT,
			PREDECREMENT,
			NEGATION,
			POSTINCREMENT,
			POSTDECREMENT,
			DEREFERENCE,
			REFERENCE,
			SIZEOF,
			UNARYMINUS,
		};

	/**
	 * A public read-only list of all the '<em><b>Unary Operations</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<UnaryOperations> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Unary Operations</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static UnaryOperations get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			UnaryOperations result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Unary Operations</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static UnaryOperations getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			UnaryOperations result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Unary Operations</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static UnaryOperations get(int value) {
		switch (value) {
			case ARRAYLENGTH_VALUE: return ARRAYLENGTH;
			case PREINCREMENT_VALUE: return PREINCREMENT;
			case PREDECREMENT_VALUE: return PREDECREMENT;
			case NEGATION_VALUE: return NEGATION;
			case POSTINCREMENT_VALUE: return POSTINCREMENT;
			case POSTDECREMENT_VALUE: return POSTDECREMENT;
			case DEREFERENCE_VALUE: return DEREFERENCE;
			case REFERENCE_VALUE: return REFERENCE;
			case SIZEOF_VALUE: return SIZEOF;
			case UNARYMINUS_VALUE: return UNARYMINUS;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private UnaryOperations(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //UnaryOperations
