/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Unary Arithmetic Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents negated expressions, e.g., -a where a is a term.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getInner <em>Inner</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getUnaryArithmeticExpression()
 * @model
 * @generated
 */
public interface UnaryArithmeticExpression extends Lvalue, Unary {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.UnaryOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute specifies the actual unary operation that is being applied on the operand, such as preincrement and postdecrement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.UnaryOperations
	 * @see #setOperation(UnaryOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getUnaryArithmeticExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	UnaryOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.UnaryOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(UnaryOperations value);

	/**
	 * Returns the value of the '<em><b>Inner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the term that is to be turned to negative.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner</em>' containment reference.
	 * @see #setInner(Term)
	 * @see de.fzi.gast.expressions.expressionsPackage#getUnaryArithmeticExpression_Inner()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Term getInner();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.UnaryArithmeticExpression#getInner <em>Inner</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inner</em>' containment reference.
	 * @see #getInner()
	 * @generated
	 */
	void setInner(Term value);

} // UnaryArithmeticExpression
