/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Term Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a term expression which consists of an operation with a right and a left side term.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.TermExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.TermExpression#getLeft <em>Left</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.TermExpression#getRight <em>Right</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getTermExpression()
 * @model
 * @generated
 */
public interface TermExpression extends Term {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.TermOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The operation attribute specifies the actual operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.TermOperations
	 * @see #setOperation(TermOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getTermExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	TermOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.TermExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.TermOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(TermOperations value);

	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the left operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(Term)
	 * @see de.fzi.gast.expressions.expressionsPackage#getTermExpression_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Term getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.TermExpression#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(Term value);

	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the right operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(Term)
	 * @see de.fzi.gast.expressions.expressionsPackage#getTermExpression_Right()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Term getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.TermExpression#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(Term value);

} // TermExpression
