/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Product Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a product expression, i.e., an expression being a product operation. The actual operation is specified by the operation attribute.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.ProductExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.ProductExpression#getLeft <em>Left</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.ProductExpression#getRight <em>Right</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getProductExpression()
 * @model
 * @generated
 */
public interface ProductExpression extends Product {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.ProductOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The operation attribute specifies the actual operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.ProductOperations
	 * @see #setOperation(ProductOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getProductExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ProductOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.ProductExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.ProductOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(ProductOperations value);

	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the left operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(Product)
	 * @see de.fzi.gast.expressions.expressionsPackage#getProductExpression_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Product getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.ProductExpression#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(Product value);

	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the right operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(Product)
	 * @see de.fzi.gast.expressions.expressionsPackage#getProductExpression_Right()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Product getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.ProductExpression#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(Product value);

} // ProductExpression
