/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Member Accessor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an expression accessing a member of a structure/class.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.MemberAccessor#getRight <em>Right</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.MemberAccessor#getLeft <em>Left</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getMemberAccessor()
 * @model
 * @generated
 */
public interface MemberAccessor extends Lvalue, Reference {
	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The right hand side of the expression, i.e., 'b' in case of a.b.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(Reference)
	 * @see de.fzi.gast.expressions.expressionsPackage#getMemberAccessor_Right()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Reference getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.MemberAccessor#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(Reference value);

	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The left hand side of the expression, i.e, 'a' in case of a.b.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(MemberExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getMemberAccessor_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	MemberExpression getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.MemberAccessor#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(MemberExpression value);

} // MemberAccessor
