/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.FunctionAccess;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Function Call</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a function. It is a wrapper for the function element in the function package.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.FunctionCall#getFunction <em>Function</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.FunctionCall#getParameterexpression <em>Parameterexpression</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.FunctionCall#getArrayvalueselection <em>Arrayvalueselection</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getFunctionCall()
 * @model
 * @generated
 */
public interface FunctionCall extends Atom, Lvalue, Reference {
	/**
	 * Returns the value of the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The function access from the accesses package that is wrapped by this element.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Function</em>' containment reference.
	 * @see #setFunction(FunctionAccess)
	 * @see de.fzi.gast.expressions.expressionsPackage#getFunctionCall_Function()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	FunctionAccess getFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.FunctionCall#getFunction <em>Function</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Function</em>' containment reference.
	 * @see #getFunction()
	 * @generated
	 */
	void setFunction(FunctionAccess value);

	/**
	 * Returns the value of the '<em><b>Parameterexpression</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.expressions.Assignment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is list of expressions. For each formal parameter of the function there is one entry contained in the list.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parameterexpression</em>' containment reference list.
	 * @see de.fzi.gast.expressions.expressionsPackage#getFunctionCall_Parameterexpression()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Assignment> getParameterexpression();

	/**
	 * Returns the value of the '<em><b>Arrayvalueselection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This association represents the index (indices) specifying the actual position within the array.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Arrayvalueselection</em>' containment reference.
	 * @see #setArrayvalueselection(ArrayValueSelection)
	 * @see de.fzi.gast.expressions.expressionsPackage#getFunctionCall_Arrayvalueselection()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	ArrayValueSelection getArrayvalueselection();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.FunctionCall#getArrayvalueselection <em>Arrayvalueselection</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Arrayvalueselection</em>' containment reference.
	 * @see #getArrayvalueselection()
	 * @generated
	 */
	void setArrayvalueselection(ArrayValueSelection value);

} // FunctionCall
