/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Conditional</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents the ternary conditional expression, i.e., (cond) ? x : y. cond is a boolean expression, while x and y are arbitrary terms of the same type.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.Conditional#getCondition <em>Condition</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.Conditional#getThen <em>Then</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.Conditional#getElse <em>Else</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getConditional()
 * @model
 * @generated
 */
public interface Conditional extends BooleanExpression {
	/**
	 * Returns the value of the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represent the condition of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Condition</em>' containment reference.
	 * @see #setCondition(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getConditional_Condition()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getCondition();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.Conditional#getCondition <em>Condition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition</em>' containment reference.
	 * @see #getCondition()
	 * @generated
	 */
	void setCondition(BooleanExpression value);

	/**
	 * Returns the value of the '<em><b>Then</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This term represents the "then" branch of the conditional expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Then</em>' containment reference.
	 * @see #setThen(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getConditional_Then()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getThen();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.Conditional#getThen <em>Then</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Then</em>' containment reference.
	 * @see #getThen()
	 * @generated
	 */
	void setThen(BooleanExpression value);

	/**
	 * Returns the value of the '<em><b>Else</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This term represents the "else" branch of the conditional expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Else</em>' containment reference.
	 * @see #setElse(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getConditional_Else()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getElse();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.Conditional#getElse <em>Else</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Else</em>' containment reference.
	 * @see #getElse()
	 * @generated
	 */
	void setElse(BooleanExpression value);

} // Conditional
