/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Compare Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an expression formed by a comparison of two terms, e. g. a op b, where a and b are boolean expressions and op is a boolean operator defined as member of boolean operations.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.CompareExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.CompareExpression#getLeft <em>Left</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.CompareExpression#getRight <em>Right</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getCompareExpression()
 * @model
 * @generated
 */
public interface CompareExpression extends Comparison {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.CompareOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The operation attribute specifies the actual operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.CompareOperations
	 * @see #setOperation(CompareOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getCompareExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	CompareOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.CompareExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.CompareOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(CompareOperations value);

	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the left operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(Term)
	 * @see de.fzi.gast.expressions.expressionsPackage#getCompareExpression_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Term getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.CompareExpression#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(Term value);

	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the right operand of the expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(Term)
	 * @see de.fzi.gast.expressions.expressionsPackage#getCompareExpression_Right()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Term getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.CompareExpression#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(Term value);

} // CompareExpression
