/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Cast Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represented a cast expression, i.e., expressions in the form (Type)expression.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.CastExpression#getType <em>Type</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.CastExpression#getExpression <em>Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getCastExpression()
 * @model
 * @generated
 */
public interface CastExpression extends Term {
	/**
	 * Returns the value of the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the type to which the expression is casted.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' containment reference.
	 * @see #setType(TypeReference)
	 * @see de.fzi.gast.expressions.expressionsPackage#getCastExpression_Type()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	TypeReference getType();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.CastExpression#getType <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' containment reference.
	 * @see #getType()
	 * @generated
	 */
	void setType(TypeReference value);

	/**
	 * Returns the value of the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the expression that is casted to a specific type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Expression</em>' containment reference.
	 * @see #setExpression(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getCastExpression_Expression()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getExpression();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.CastExpression#getExpression <em>Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expression</em>' containment reference.
	 * @see #getExpression()
	 * @generated
	 */
	void setExpression(BooleanExpression value);

} // CastExpression
