/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Boolean Operator Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an expression formed by a boolean operation, e.g. a AND b, where a and b are of type boolean expression. The actual operation is stored as an attribute of this class.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.BooleanOperatorExpression#getOperation <em>Operation</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.BooleanOperatorExpression#getLeft <em>Left</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.BooleanOperatorExpression#getRight <em>Right</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getBooleanOperatorExpression()
 * @model
 * @generated
 */
public interface BooleanOperatorExpression extends BooleanExpression {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.BooleanOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The operation attribute specifies the actual operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.BooleanOperations
	 * @see #setOperation(BooleanOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getBooleanOperatorExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	BooleanOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.BooleanOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(BooleanOperations value);

	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the left operand of the operation expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getBooleanOperatorExpression_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(BooleanExpression value);

	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the right operand of the operation expression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(BooleanExpression)
	 * @see de.fzi.gast.expressions.expressionsPackage#getBooleanOperatorExpression_Right()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	BooleanExpression getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.BooleanOperatorExpression#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(BooleanExpression value);

} // BooleanOperatorExpression
