/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Assignment Operator Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an expression formed by an assignment operation, e.g. a = b and a += b, where a is of an Lvalue type and b is of the Assignment type. The actual operation is stored as an attribute of this class.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getLeft <em>Left</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getRight <em>Right</em>}</li>
 *   <li>{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getOperation <em>Operation</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.expressions.expressionsPackage#getAssignmentOperatorExpression()
 * @model
 * @generated
 */
public interface AssignmentOperatorExpression extends Assignment {
	/**
	 * Returns the value of the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute represents the left hand side of the assignment expression, i.e., in most cases the variable to which it is being assigned.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Left</em>' containment reference.
	 * @see #setLeft(Lvalue)
	 * @see de.fzi.gast.expressions.expressionsPackage#getAssignmentOperatorExpression_Left()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Lvalue getLeft();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getLeft <em>Left</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Left</em>' containment reference.
	 * @see #getLeft()
	 * @generated
	 */
	void setLeft(Lvalue value);

	/**
	 * Returns the value of the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute specifies the expression, whose value is stored into the left hand side attribute of the assignment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Right</em>' containment reference.
	 * @see #setRight(Assignment)
	 * @see de.fzi.gast.expressions.expressionsPackage#getAssignmentOperatorExpression_Right()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	Assignment getRight();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getRight <em>Right</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right</em>' containment reference.
	 * @see #getRight()
	 * @generated
	 */
	void setRight(Assignment value);

	/**
	 * Returns the value of the '<em><b>Operation</b></em>' attribute.
	 * The literals are from the enumeration {@link de.fzi.gast.expressions.AssignmentOperations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute specifies the actual assignment operation, e.g. +=, -=, etc.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.AssignmentOperations
	 * @see #setOperation(AssignmentOperations)
	 * @see de.fzi.gast.expressions.expressionsPackage#getAssignmentOperatorExpression_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	AssignmentOperations getOperation();

	/**
	 * Sets the value of the '{@link de.fzi.gast.expressions.AssignmentOperatorExpression#getOperation <em>Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' attribute.
	 * @see de.fzi.gast.expressions.AssignmentOperations
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(AssignmentOperations value);

} // AssignmentOperatorExpression
