/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Assignment Operations</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration holds values for various types of assignment operations, such as +=, /=, and >>>=.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.expressions.expressionsPackage#getAssignmentOperations()
 * @model
 * @generated
 */
public enum AssignmentOperations implements Enumerator {
	/**
	 * The '<em><b>UNSIGNEDSHIFTRIGHTASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNSIGNEDSHIFTRIGHTASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	UNSIGNEDSHIFTRIGHTASSIGN(0, "UNSIGNEDSHIFTRIGHTASSIGN", "UNSIGNEDSHIFTRIGHTASSIGN"), /**
	 * The '<em><b>ASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	ASSIGN(1, "ASSIGN", "ASSIGN"),

	/**
	 * The '<em><b>ADDASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ADDASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	ADDASSIGN(2, "ADDASSIGN", "ADDASSIGN"),

	/**
	 * The '<em><b>SUBASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUBASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	SUBASSIGN(3, "SUBASSIGN", "SUBASSIGN"),

	/**
	 * The '<em><b>MULASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MULASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	MULASSIGN(4, "MULASSIGN", "MULASSIGN"),

	/**
	 * The '<em><b>DIVASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DIVASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	DIVASSIGN(5, "DIVASSIGN", "DIVASSIGN"),

	/**
	 * The '<em><b>MODASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MODASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	MODASSIGN(6, "MODASSIGN", "MODASSIGN"),

	/**
	 * The '<em><b>BITANDASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BITANDASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	BITANDASSIGN(7, "BITANDASSIGN", "BITANDASSIGN"),

	/**
	 * The '<em><b>BITORASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BITORASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	BITORASSIGN(8, "BITORASSIGN", "BITORASSIGN"),

	/**
	 * The '<em><b>BITXORASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BITXORASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	BITXORASSIGN(9, "BITXORASSIGN", "BITXORASSIGN"),

	/**
	 * The '<em><b>SHIFTLEFTASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SHIFTLEFTASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	SHIFTLEFTASSIGN(10, "SHIFTLEFTASSIGN", "SHIFTLEFTASSIGN"),

	/**
	 * The '<em><b>SHIFTRIGHTASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SHIFTRIGHTASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	SHIFTRIGHTASSIGN(11, "SHIFTRIGHTASSIGN", "SHIFTRIGHTASSIGN"),

	/**
	 * The '<em><b>ROTATERIGHTASSIGN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROTATERIGHTASSIGN_VALUE
	 * @generated
	 * @ordered
	 */
	ROTATERIGHTASSIGN(12, "ROTATERIGHTASSIGN", "ROTATERIGHTASSIGN");

	/**
	 * The '<em><b>UNSIGNEDSHIFTRIGHTASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>UNSIGNEDSHIFTRIGHTASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNSIGNEDSHIFTRIGHTASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNSIGNEDSHIFTRIGHTASSIGN_VALUE = 0;

	/**
	 * The '<em><b>ASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ASSIGN_VALUE = 1;

	/**
	 * The '<em><b>ADDASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ADDASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ADDASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ADDASSIGN_VALUE = 2;

	/**
	 * The '<em><b>SUBASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SUBASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SUBASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SUBASSIGN_VALUE = 3;

	/**
	 * The '<em><b>MULASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MULASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MULASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MULASSIGN_VALUE = 4;

	/**
	 * The '<em><b>DIVASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DIVASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DIVASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DIVASSIGN_VALUE = 5;

	/**
	 * The '<em><b>MODASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MODASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MODASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MODASSIGN_VALUE = 6;

	/**
	 * The '<em><b>BITANDASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BITANDASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BITANDASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BITANDASSIGN_VALUE = 7;

	/**
	 * The '<em><b>BITORASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BITORASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BITORASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BITORASSIGN_VALUE = 8;

	/**
	 * The '<em><b>BITXORASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BITXORASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BITXORASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BITXORASSIGN_VALUE = 9;

	/**
	 * The '<em><b>SHIFTLEFTASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SHIFTLEFTASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SHIFTLEFTASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SHIFTLEFTASSIGN_VALUE = 10;

	/**
	 * The '<em><b>SHIFTRIGHTASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SHIFTRIGHTASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SHIFTRIGHTASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SHIFTRIGHTASSIGN_VALUE = 11;

	/**
	 * The '<em><b>ROTATERIGHTASSIGN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROTATERIGHTASSIGN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROTATERIGHTASSIGN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROTATERIGHTASSIGN_VALUE = 12;

	/**
	 * An array of all the '<em><b>Assignment Operations</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final AssignmentOperations[] VALUES_ARRAY =
		new AssignmentOperations[] {
			UNSIGNEDSHIFTRIGHTASSIGN,
			ASSIGN,
			ADDASSIGN,
			SUBASSIGN,
			MULASSIGN,
			DIVASSIGN,
			MODASSIGN,
			BITANDASSIGN,
			BITORASSIGN,
			BITXORASSIGN,
			SHIFTLEFTASSIGN,
			SHIFTRIGHTASSIGN,
			ROTATERIGHTASSIGN,
		};

	/**
	 * A public read-only list of all the '<em><b>Assignment Operations</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<AssignmentOperations> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Assignment Operations</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AssignmentOperations get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AssignmentOperations result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Assignment Operations</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AssignmentOperations getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AssignmentOperations result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Assignment Operations</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AssignmentOperations get(int value) {
		switch (value) {
			case UNSIGNEDSHIFTRIGHTASSIGN_VALUE: return UNSIGNEDSHIFTRIGHTASSIGN;
			case ASSIGN_VALUE: return ASSIGN;
			case ADDASSIGN_VALUE: return ADDASSIGN;
			case SUBASSIGN_VALUE: return SUBASSIGN;
			case MULASSIGN_VALUE: return MULASSIGN;
			case DIVASSIGN_VALUE: return DIVASSIGN;
			case MODASSIGN_VALUE: return MODASSIGN;
			case BITANDASSIGN_VALUE: return BITANDASSIGN;
			case BITORASSIGN_VALUE: return BITORASSIGN;
			case BITXORASSIGN_VALUE: return BITXORASSIGN;
			case SHIFTLEFTASSIGN_VALUE: return SHIFTLEFTASSIGN;
			case SHIFTRIGHTASSIGN_VALUE: return SHIFTRIGHTASSIGN;
			case ROTATERIGHTASSIGN_VALUE: return ROTATERIGHTASSIGN;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private AssignmentOperations(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //AssignmentOperations
