/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.core.util.coreSwitch;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.expressions.util.expressionsAdapterFactory;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.statementsPackage;
import de.fzi.gast.statements.util.statementsSwitch;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class expressionsItemProviderAdapterFactory extends expressionsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public expressionsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ExpPosition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpPositionItemProvider expPositionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ExpPosition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpPositionAdapter() {
		if (expPositionItemProvider == null) {
			expPositionItemProvider = new ExpPositionItemProvider(this);
		}

		return expPositionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ArrayValueSelection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayValueSelectionItemProvider arrayValueSelectionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ArrayValueSelection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayValueSelectionAdapter() {
		if (arrayValueSelectionItemProvider == null) {
			arrayValueSelectionItemProvider = new ArrayValueSelectionItemProvider(this);
		}

		return arrayValueSelectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.TermExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TermExpressionItemProvider termExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.TermExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTermExpressionAdapter() {
		if (termExpressionItemProvider == null) {
			termExpressionItemProvider = new TermExpressionItemProvider(this);
		}

		return termExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ProductExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProductExpressionItemProvider productExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ProductExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProductExpressionAdapter() {
		if (productExpressionItemProvider == null) {
			productExpressionItemProvider = new ProductExpressionItemProvider(this);
		}

		return productExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ParenthesisExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParenthesisExpressionItemProvider parenthesisExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ParenthesisExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParenthesisExpressionAdapter() {
		if (parenthesisExpressionItemProvider == null) {
			parenthesisExpressionItemProvider = new ParenthesisExpressionItemProvider(this);
		}

		return parenthesisExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.IntLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntLiteralItemProvider intLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.IntLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntLiteralAdapter() {
		if (intLiteralItemProvider == null) {
			intLiteralItemProvider = new IntLiteralItemProvider(this);
		}

		return intLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.DoubleLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleLiteralItemProvider doubleLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.DoubleLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoubleLiteralAdapter() {
		if (doubleLiteralItemProvider == null) {
			doubleLiteralItemProvider = new DoubleLiteralItemProvider(this);
		}

		return doubleLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.CompareExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompareExpressionItemProvider compareExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.CompareExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompareExpressionAdapter() {
		if (compareExpressionItemProvider == null) {
			compareExpressionItemProvider = new CompareExpressionItemProvider(this);
		}

		return compareExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.BoolLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoolLiteralItemProvider boolLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.BoolLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBoolLiteralAdapter() {
		if (boolLiteralItemProvider == null) {
			boolLiteralItemProvider = new BoolLiteralItemProvider(this);
		}

		return boolLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.StringLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringLiteralItemProvider stringLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.StringLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringLiteralAdapter() {
		if (stringLiteralItemProvider == null) {
			stringLiteralItemProvider = new StringLiteralItemProvider(this);
		}

		return stringLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.BooleanOperatorExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanOperatorExpressionItemProvider booleanOperatorExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.BooleanOperatorExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanOperatorExpressionAdapter() {
		if (booleanOperatorExpressionItemProvider == null) {
			booleanOperatorExpressionItemProvider = new BooleanOperatorExpressionItemProvider(this);
		}

		return booleanOperatorExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.NotExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotExpressionItemProvider notExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.NotExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNotExpressionAdapter() {
		if (notExpressionItemProvider == null) {
			notExpressionItemProvider = new NotExpressionItemProvider(this);
		}

		return notExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.UnaryArithmeticExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnaryArithmeticExpressionItemProvider unaryArithmeticExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.UnaryArithmeticExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnaryArithmeticExpressionAdapter() {
		if (unaryArithmeticExpressionItemProvider == null) {
			unaryArithmeticExpressionItemProvider = new UnaryArithmeticExpressionItemProvider(this);
		}

		return unaryArithmeticExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.FunctionCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionCallItemProvider functionCallItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.FunctionCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionCallAdapter() {
		if (functionCallItemProvider == null) {
			functionCallItemProvider = new FunctionCallItemProvider(this);
		}

		return functionCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.Conditional} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalItemProvider conditionalItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.Conditional}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalAdapter() {
		if (conditionalItemProvider == null) {
			conditionalItemProvider = new ConditionalItemProvider(this);
		}

		return conditionalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.MemberAccessor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemberAccessorItemProvider memberAccessorItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.MemberAccessor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemberAccessorAdapter() {
		if (memberAccessorItemProvider == null) {
			memberAccessorItemProvider = new MemberAccessorItemProvider(this);
		}

		return memberAccessorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.TypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeReferenceItemProvider typeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.TypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeReferenceAdapter() {
		if (typeReferenceItemProvider == null) {
			typeReferenceItemProvider = new TypeReferenceItemProvider(this);
		}

		return typeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.CastExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CastExpressionItemProvider castExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.CastExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCastExpressionAdapter() {
		if (castExpressionItemProvider == null) {
			castExpressionItemProvider = new CastExpressionItemProvider(this);
		}

		return castExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.AssignmentOperatorExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssignmentOperatorExpressionItemProvider assignmentOperatorExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.AssignmentOperatorExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssignmentOperatorExpressionAdapter() {
		if (assignmentOperatorExpressionItemProvider == null) {
			assignmentOperatorExpressionItemProvider = new AssignmentOperatorExpressionItemProvider(this);
		}

		return assignmentOperatorExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.CharLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CharLiteralItemProvider charLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.CharLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCharLiteralAdapter() {
		if (charLiteralItemProvider == null) {
			charLiteralItemProvider = new CharLiteralItemProvider(this);
		}

		return charLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.VariablePlaceholder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariablePlaceholderItemProvider variablePlaceholderItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.VariablePlaceholder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariablePlaceholderAdapter() {
		if (variablePlaceholderItemProvider == null) {
			variablePlaceholderItemProvider = new VariablePlaceholderItemProvider(this);
		}

		return variablePlaceholderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.FunctionCallPlaceholder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionCallPlaceholderItemProvider functionCallPlaceholderItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.FunctionCallPlaceholder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionCallPlaceholderAdapter() {
		if (functionCallPlaceholderItemProvider == null) {
			functionCallPlaceholderItemProvider = new FunctionCallPlaceholderItemProvider(this);
		}

		return functionCallPlaceholderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.TypeReferencePlaceholder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeReferencePlaceholderItemProvider typeReferencePlaceholderItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.TypeReferencePlaceholder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeReferencePlaceholderAdapter() {
		if (typeReferencePlaceholderItemProvider == null) {
			typeReferencePlaceholderItemProvider = new TypeReferencePlaceholderItemProvider(this);
		}

		return typeReferencePlaceholderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ExpressionAnchor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionAnchorItemProvider expressionAnchorItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ExpressionAnchor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionAnchorAdapter() {
		if (expressionAnchorItemProvider == null) {
			expressionAnchorItemProvider = new ExpressionAnchorItemProvider(this);
		}

		return expressionAnchorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.ExpressionsRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionsRootItemProvider expressionsRootItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.ExpressionsRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionsRootAdapter() {
		if (expressionsRootItemProvider == null) {
			expressionsRootItemProvider = new ExpressionsRootItemProvider(this);
		}

		return expressionsRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.expressions.NullLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullLiteralItemProvider nullLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.expressions.NullLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullLiteralAdapter() {
		if (nullLiteralItemProvider == null) {
			nullLiteralItemProvider = new NullLiteralItemProvider(this);
		}

		return nullLiteralItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (variableItemProvider != null) variableItemProvider.dispose();
		if (expPositionItemProvider != null) expPositionItemProvider.dispose();
		if (arrayValueSelectionItemProvider != null) arrayValueSelectionItemProvider.dispose();
		if (termExpressionItemProvider != null) termExpressionItemProvider.dispose();
		if (productExpressionItemProvider != null) productExpressionItemProvider.dispose();
		if (parenthesisExpressionItemProvider != null) parenthesisExpressionItemProvider.dispose();
		if (intLiteralItemProvider != null) intLiteralItemProvider.dispose();
		if (doubleLiteralItemProvider != null) doubleLiteralItemProvider.dispose();
		if (compareExpressionItemProvider != null) compareExpressionItemProvider.dispose();
		if (boolLiteralItemProvider != null) boolLiteralItemProvider.dispose();
		if (stringLiteralItemProvider != null) stringLiteralItemProvider.dispose();
		if (booleanOperatorExpressionItemProvider != null) booleanOperatorExpressionItemProvider.dispose();
		if (notExpressionItemProvider != null) notExpressionItemProvider.dispose();
		if (unaryArithmeticExpressionItemProvider != null) unaryArithmeticExpressionItemProvider.dispose();
		if (functionCallItemProvider != null) functionCallItemProvider.dispose();
		if (conditionalItemProvider != null) conditionalItemProvider.dispose();
		if (memberAccessorItemProvider != null) memberAccessorItemProvider.dispose();
		if (typeReferenceItemProvider != null) typeReferenceItemProvider.dispose();
		if (castExpressionItemProvider != null) castExpressionItemProvider.dispose();
		if (assignmentOperatorExpressionItemProvider != null) assignmentOperatorExpressionItemProvider.dispose();
		if (charLiteralItemProvider != null) charLiteralItemProvider.dispose();
		if (variablePlaceholderItemProvider != null) variablePlaceholderItemProvider.dispose();
		if (functionCallPlaceholderItemProvider != null) functionCallPlaceholderItemProvider.dispose();
		if (typeReferencePlaceholderItemProvider != null) typeReferencePlaceholderItemProvider.dispose();
		if (expressionAnchorItemProvider != null) expressionAnchorItemProvider.dispose();
		if (expressionsRootItemProvider != null) expressionsRootItemProvider.dispose();
		if (nullLiteralItemProvider != null) nullLiteralItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link statementsPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class statementsChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends statementsSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseBranch(Branch object) {
				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.BRANCH__CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseJumpStatement(JumpStatement object) {
				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.JUMP_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseLoopStatement(LoopStatement object) {
				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INIT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.LOOP_STATEMENT__INCREMENT_EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseSimpleStatement(SimpleStatement object) {
				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(statementsPackage.Literals.SIMPLE_STATEMENT__EXPRESSION,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return ExpressionsDecoratorEditPlugin.INSTANCE;
		}
	}

	/**
	 * A child creation extender for the {@link corePackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class coreChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends coreSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseRoot(Root object) {
				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createVariable()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createArrayValueSelection()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createTermExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createProductExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createParenthesisExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createIntLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createDoubleLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createCompareExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createBoolLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createStringLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createNotExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createFunctionCall()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createConditional()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createMemberAccessor()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createTypeReference()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createCastExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createCharLiteral()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

				newChildDescriptors.add
					(createChildParameter
						(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
						 expressionsFactory.eINSTANCE.createNullLiteral()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return ExpressionsDecoratorEditPlugin.INSTANCE;
		}
	}

}
