/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.expressions.provider;


import de.fzi.gast.core.provider.IdentifierItemProvider;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.expressions.expressionsPackage;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.expressions.ExpressionAnchor} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ExpressionAnchorItemProvider
	extends IdentifierItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionAnchorItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSissyModelElementIDPropertyDescriptor(object);
			addGastexpressionproxyPropertyDescriptor(object);
			addExpressionanchorkindPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Sissy Model Element ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSissyModelElementIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SISSyPlaceholder_SissyModelElementID_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SISSyPlaceholder_SissyModelElementID_feature", "_UI_SISSyPlaceholder_type"),
				 expressionsPackage.Literals.SIS_SY_PLACEHOLDER__SISSY_MODEL_ELEMENT_ID,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Gastexpressionproxy feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addGastexpressionproxyPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ExpressionAnchor_gastexpressionproxy_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_ExpressionAnchor_gastexpressionproxy_feature", "_UI_ExpressionAnchor_type"),
				 expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Expressionanchorkind feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addExpressionanchorkindPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ExpressionAnchor_expressionanchorkind_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_ExpressionAnchor_expressionanchorkind_feature", "_UI_ExpressionAnchor_type"),
				 expressionsPackage.Literals.EXPRESSION_ANCHOR__EXPRESSIONANCHORKIND,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns ExpressionAnchor.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/ExpressionAnchor"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((ExpressionAnchor)object).getId();
		return label == null || label.length() == 0 ?
			getString("_UI_ExpressionAnchor_type") :
			getString("_UI_ExpressionAnchor_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ExpressionAnchor.class)) {
			case expressionsPackage.EXPRESSION_ANCHOR__SISSY_MODEL_ELEMENT_ID:
			case expressionsPackage.EXPRESSION_ANCHOR__EXPRESSIONANCHORKIND:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createVariable()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createArrayValueSelection()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createTermExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createProductExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createParenthesisExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createIntLiteral()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createDoubleLiteral()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createCompareExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createBoolLiteral()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createStringLiteral()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createBooleanOperatorExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createNotExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createUnaryArithmeticExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createFunctionCall()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createConditional()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createMemberAccessor()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createTypeReference()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createCastExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createAssignmentOperatorExpression()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createCharLiteral()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createVariablePlaceholder()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createFunctionCallPlaceholder()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createTypeReferencePlaceholder()));

		newChildDescriptors.add
			(createChildParameter
				(expressionsPackage.Literals.EXPRESSION_ANCHOR__GASTEXPRESSIONPROXY,
				 expressionsFactory.eINSTANCE.createNullLiteral()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return ExpressionsDecoratorEditPlugin.INSTANCE;
	}

}
