/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.types.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.gast.types.util.typesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class typesItemProviderAdapterFactory extends typesAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public typesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.Reference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceItemProvider referenceItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.Reference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceAdapter() {
		if (referenceItemProvider == null) {
			referenceItemProvider = new ReferenceItemProvider(this);
		}

		return referenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GASTArray} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTArrayItemProvider gastArrayItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GASTArray}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTArrayAdapter() {
		if (gastArrayItemProvider == null) {
			gastArrayItemProvider = new GASTArrayItemProvider(this);
		}

		return gastArrayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.TypeAlias} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeAliasItemProvider typeAliasItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.TypeAlias}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeAliasAdapter() {
		if (typeAliasItemProvider == null) {
			typeAliasItemProvider = new TypeAliasItemProvider(this);
		}

		return typeAliasItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.TypeParameterClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeParameterClassItemProvider typeParameterClassItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.TypeParameterClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeParameterClassAdapter() {
		if (typeParameterClassItemProvider == null) {
			typeParameterClassItemProvider = new TypeParameterClassItemProvider(this);
		}

		return typeParameterClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GenericClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericClassItemProvider genericClassItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GenericClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericClassAdapter() {
		if (genericClassItemProvider == null) {
			genericClassItemProvider = new GenericClassItemProvider(this);
		}

		return genericClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GASTEnumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTEnumerationItemProvider gastEnumerationItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GASTEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTEnumerationAdapter() {
		if (gastEnumerationItemProvider == null) {
			gastEnumerationItemProvider = new GASTEnumerationItemProvider(this);
		}

		return gastEnumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GASTStruct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTStructItemProvider gastStructItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GASTStruct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTStructAdapter() {
		if (gastStructItemProvider == null) {
			gastStructItemProvider = new GASTStructItemProvider(this);
		}

		return gastStructItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GASTUnion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTUnionItemProvider gastUnionItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GASTUnion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTUnionAdapter() {
		if (gastUnionItemProvider == null) {
			gastUnionItemProvider = new GASTUnionItemProvider(this);
		}

		return gastUnionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.types.GASTClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTClassItemProvider gastClassItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTClassAdapter() {
		if (gastClassItemProvider == null) {
			gastClassItemProvider = new GASTClassItemProvider(this);
		}

		return gastClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (referenceItemProvider != null) referenceItemProvider.dispose();
		if (gastArrayItemProvider != null) gastArrayItemProvider.dispose();
		if (typeAliasItemProvider != null) typeAliasItemProvider.dispose();
		if (typeParameterClassItemProvider != null) typeParameterClassItemProvider.dispose();
		if (genericClassItemProvider != null) genericClassItemProvider.dispose();
		if (gastEnumerationItemProvider != null) gastEnumerationItemProvider.dispose();
		if (gastStructItemProvider != null) gastStructItemProvider.dispose();
		if (gastUnionItemProvider != null) gastUnionItemProvider.dispose();
		if (gastClassItemProvider != null) gastClassItemProvider.dispose();
	}

}
