/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.types.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.accesses.accessesFactory;
import de.fzi.gast.annotations.annotationsFactory;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.functionsFactory;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.typesFactory;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.variablesFactory;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.types.GASTClass} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GASTClassItemProvider
	extends MemberItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClassItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSimpleNamePropertyDescriptor(object);
			addQualifiedNamePropertyDescriptor(object);
			addReferenceTypePropertyDescriptor(object);
			addSurroundingFunctionPropertyDescriptor(object);
			addSuperTypesPropertyDescriptor(object);
			addLinesOfCommentsPropertyDescriptor(object);
			addLocalPropertyDescriptor(object);
			addPrimitivePropertyDescriptor(object);
			addInterfacePropertyDescriptor(object);
			addAnonymousPropertyDescriptor(object);
			addSelfPropertyDescriptor(object);
			addFriendClassesPropertyDescriptor(object);
			addAllAccessesPropertyDescriptor(object);
			addAllAccessedClassesPropertyDescriptor(object);
			addInnerPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Simple Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSimpleNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_NamedModelElement_simpleName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_NamedModelElement_simpleName_feature", "_UI_NamedModelElement_type"),
				 corePackage.Literals.NAMED_MODEL_ELEMENT__SIMPLE_NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Qualified Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addQualifiedNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTType_qualifiedName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTType_qualifiedName_feature", "_UI_GASTType_type"),
				 typesPackage.Literals.GAST_TYPE__QUALIFIED_NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Reference Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addReferenceTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTType_referenceType_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTType_referenceType_feature", "_UI_GASTType_type"),
				 typesPackage.Literals.GAST_TYPE__REFERENCE_TYPE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Super Types feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSuperTypesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_superTypes_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_superTypes_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__SUPER_TYPES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Comments feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCommentsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_linesOfComments_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_linesOfComments_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__LINES_OF_COMMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Local feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLocalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_local_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_local_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__LOCAL,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Primitive feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPrimitivePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_primitive_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_primitive_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__PRIMITIVE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Surrounding Function feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSurroundingFunctionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_surroundingFunction_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_surroundingFunction_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__SURROUNDING_FUNCTION,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Interface feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInterfacePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_interface_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_interface_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__INTERFACE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Anonymous feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAnonymousPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_anonymous_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_anonymous_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__ANONYMOUS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Self feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSelfPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_self_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_self_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__SELF,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Friend Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addFriendClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_friendClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_friendClasses_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__FRIEND_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Accesses feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllAccessesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_allAccesses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_allAccesses_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__ALL_ACCESSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Accessed Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllAccessedClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_allAccessedClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_allAccessedClasses_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__ALL_ACCESSED_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Inner feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInnerPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_GASTClass_inner_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_GASTClass_inner_feature", "_UI_GASTClass_type"),
				 typesPackage.Literals.GAST_CLASS__INNER,
				 false,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__INNER_TYPE_ALIASES);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__INNER_DELEGATES);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__CONSTRUCTORS);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__DESTRUCTORS);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__FIELDS);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__METHODS);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__INNER_CLASSES);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__INHERITANCE_TYPE_ACCESSES);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS);
			childrenFeatures.add(typesPackage.Literals.GAST_CLASS__PROPERTY);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns GASTClass.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/GASTClass"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		String label = ((GASTClass)object).getQualifiedName();
		return label == null || label.length() == 0 ?
			getString("_UI_GASTClass_type") :
			getString("_UI_GASTClass_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(GASTClass.class)) {
			case typesPackage.GAST_CLASS__SIMPLE_NAME:
			case typesPackage.GAST_CLASS__QUALIFIED_NAME:
			case typesPackage.GAST_CLASS__REFERENCE_TYPE:
			case typesPackage.GAST_CLASS__LINES_OF_COMMENTS:
			case typesPackage.GAST_CLASS__LOCAL:
			case typesPackage.GAST_CLASS__PRIMITIVE:
			case typesPackage.GAST_CLASS__INTERFACE:
			case typesPackage.GAST_CLASS__ANONYMOUS:
			case typesPackage.GAST_CLASS__INNER:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
			case typesPackage.GAST_CLASS__DESTRUCTORS:
			case typesPackage.GAST_CLASS__FIELDS:
			case typesPackage.GAST_CLASS__METHODS:
			case typesPackage.GAST_CLASS__INNER_CLASSES:
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
			case typesPackage.GAST_CLASS__PROPERTY:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_TYPE_ALIASES,
				 typesFactory.eINSTANCE.createTypeAlias()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_DELEGATES,
				 functionsFactory.eINSTANCE.createDelegate()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__CONSTRUCTORS,
				 functionsFactory.eINSTANCE.createConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__CONSTRUCTORS,
				 functionsFactory.eINSTANCE.createGenericConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__DESTRUCTORS,
				 functionsFactory.eINSTANCE.createDestructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FIELDS,
				 variablesFactory.eINSTANCE.createField()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FIELDS,
				 variablesFactory.eINSTANCE.createProperty()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__METHODS,
				 functionsFactory.eINSTANCE.createMethod()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__METHODS,
				 functionsFactory.eINSTANCE.createGenericMethod()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createGASTClass()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createTypeParameterClass()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createGenericClass()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createGASTEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createGASTStruct()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 typesFactory.eINSTANCE.createGASTUnion()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INNER_CLASSES,
				 annotationsFactory.eINSTANCE.createAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__INHERITANCE_TYPE_ACCESSES,
				 accessesFactory.eINSTANCE.createInheritanceTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createDelegate()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createDestructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGlobalFunction()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGenericFunction()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createMethod()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGenericMethod()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGenericConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(typesPackage.Literals.GAST_CLASS__PROPERTY,
				 variablesFactory.eINSTANCE.createProperty()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == typesPackage.Literals.GAST_CLASS__INNER_DELEGATES ||
			childFeature == typesPackage.Literals.GAST_CLASS__FRIEND_FUNCTIONS ||
			childFeature == typesPackage.Literals.GAST_CLASS__CONSTRUCTORS ||
			childFeature == typesPackage.Literals.GAST_CLASS__DESTRUCTORS ||
			childFeature == typesPackage.Literals.GAST_CLASS__FIELDS ||
			childFeature == typesPackage.Literals.GAST_CLASS__PROPERTY ||
			childFeature == typesPackage.Literals.GAST_CLASS__METHODS;

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
