/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.statements.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.gast.statements.util.statementsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class statementsItemProviderAdapterFactory extends statementsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public statementsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.ExceptionHandler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExceptionHandlerItemProvider exceptionHandlerItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.ExceptionHandler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExceptionHandlerAdapter() {
		if (exceptionHandlerItemProvider == null) {
			exceptionHandlerItemProvider = new ExceptionHandlerItemProvider(this);
		}

		return exceptionHandlerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.BlockStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockStatementItemProvider blockStatementItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.BlockStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockStatementAdapter() {
		if (blockStatementItemProvider == null) {
			blockStatementItemProvider = new BlockStatementItemProvider(this);
		}

		return blockStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.CatchBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CatchBlockItemProvider catchBlockItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.CatchBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCatchBlockAdapter() {
		if (catchBlockItemProvider == null) {
			catchBlockItemProvider = new CatchBlockItemProvider(this);
		}

		return catchBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.BranchStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BranchStatementItemProvider branchStatementItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.BranchStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBranchStatementAdapter() {
		if (branchStatementItemProvider == null) {
			branchStatementItemProvider = new BranchStatementItemProvider(this);
		}

		return branchStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.Branch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BranchItemProvider branchItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.Branch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBranchAdapter() {
		if (branchItemProvider == null) {
			branchItemProvider = new BranchItemProvider(this);
		}

		return branchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.JumpStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JumpStatementItemProvider jumpStatementItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.JumpStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJumpStatementAdapter() {
		if (jumpStatementItemProvider == null) {
			jumpStatementItemProvider = new JumpStatementItemProvider(this);
		}

		return jumpStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.LoopStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoopStatementItemProvider loopStatementItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.LoopStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLoopStatementAdapter() {
		if (loopStatementItemProvider == null) {
			loopStatementItemProvider = new LoopStatementItemProvider(this);
		}

		return loopStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.SimpleStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleStatementItemProvider simpleStatementItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.SimpleStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSimpleStatementAdapter() {
		if (simpleStatementItemProvider == null) {
			simpleStatementItemProvider = new SimpleStatementItemProvider(this);
		}

		return simpleStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.statements.GASTBehaviour} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTBehaviourItemProvider gastBehaviourItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.statements.GASTBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGASTBehaviourAdapter() {
		if (gastBehaviourItemProvider == null) {
			gastBehaviourItemProvider = new GASTBehaviourItemProvider(this);
		}

		return gastBehaviourItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (exceptionHandlerItemProvider != null) exceptionHandlerItemProvider.dispose();
		if (blockStatementItemProvider != null) blockStatementItemProvider.dispose();
		if (branchItemProvider != null) branchItemProvider.dispose();
		if (branchStatementItemProvider != null) branchStatementItemProvider.dispose();
		if (loopStatementItemProvider != null) loopStatementItemProvider.dispose();
		if (catchBlockItemProvider != null) catchBlockItemProvider.dispose();
		if (jumpStatementItemProvider != null) jumpStatementItemProvider.dispose();
		if (simpleStatementItemProvider != null) simpleStatementItemProvider.dispose();
		if (gastBehaviourItemProvider != null) gastBehaviourItemProvider.dispose();
	}

}
