/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.statements.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.accesses.accessesFactory;
import de.fzi.gast.core.provider.SourceEntityItemProvider;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.statements.Statement} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class StatementItemProvider
	extends SourceEntityItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatementItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSurroundingStatementPropertyDescriptor(object);
			addNumberOfStatementsPropertyDescriptor(object);
			addMaximumNestingLevelPropertyDescriptor(object);
			addNumberOfCommentsPropertyDescriptor(object);
			addLinesOfCodePropertyDescriptor(object);
			addNumberOfEdgesInCFGPropertyDescriptor(object);
			addNumberOfNodesInCFGPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Surrounding Statement feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSurroundingStatementPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_surroundingStatement_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_surroundingStatement_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__SURROUNDING_STATEMENT,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Statements feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfStatementsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_numberOfStatements_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_numberOfStatements_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__NUMBER_OF_STATEMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Maximum Nesting Level feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addMaximumNestingLevelPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_maximumNestingLevel_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_maximumNestingLevel_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__MAXIMUM_NESTING_LEVEL,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Comments feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfCommentsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_numberOfComments_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_numberOfComments_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__NUMBER_OF_COMMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_linesOfCode_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_linesOfCode_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__LINES_OF_CODE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Edges In CFG feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfEdgesInCFGPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_numberOfEdgesInCFG_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_numberOfEdgesInCFG_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__NUMBER_OF_EDGES_IN_CFG,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Nodes In CFG feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfNodesInCFGPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Statement_numberOfNodesInCFG_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Statement_numberOfNodesInCFG_feature", "_UI_Statement_type"),
				 statementsPackage.Literals.STATEMENT__NUMBER_OF_NODES_IN_CFG,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(statementsPackage.Literals.STATEMENT__ACCESSES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((Statement)object).getId();
		return label == null || label.length() == 0 ?
			getString("_UI_Statement_type") :
			getString("_UI_Statement_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Statement.class)) {
			case statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS:
			case statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL:
			case statementsPackage.STATEMENT__NUMBER_OF_COMMENTS:
			case statementsPackage.STATEMENT__LINES_OF_CODE:
			case statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG:
			case statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case statementsPackage.STATEMENT__ACCESSES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createParameterInstantiationTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createCastTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createCompositeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createDeclarationTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createThrowTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createFunctionAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createDelegateAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createInheritanceTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createVariableAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createRunTimeTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createSelfAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createStaticTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(statementsPackage.Literals.STATEMENT__ACCESSES,
				 accessesFactory.eINSTANCE.createPropertyAccess()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return SissyModelEditPlugin.INSTANCE;
	}

}
