/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.functions.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.accesses.accessesFactory;
import de.fzi.gast.annotations.annotationsFactory;
import de.fzi.gast.core.coreFactory;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.core.provider.NamedModelElementItemProvider;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.statements.statementsFactory;
import de.fzi.gast.statements.provider.SissyModelEditPlugin;
import de.fzi.gast.types.typesFactory;
import de.fzi.gast.variables.variablesFactory;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.functions.Function} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FunctionItemProvider
	extends NamedModelElementItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FunctionItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addAllStatementsPropertyDescriptor(object);
			addThrowTypeAccessesPropertyDescriptor(object);
			addAccessesPropertyDescriptor(object);
			addNumberOfStatementsPropertyDescriptor(object);
			addMaximumNestingLevelPropertyDescriptor(object);
			addLinesOfCommentsPropertyDescriptor(object);
			addLinesOfCodePropertyDescriptor(object);
			addNumberOfEdgesInCFGPropertyDescriptor(object);
			addNumberOfNodesInCFGPropertyDescriptor(object);
			addOperatorPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the All Statements feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllStatementsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_allStatements_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_allStatements_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__ALL_STATEMENTS,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Throw Type Accesses feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addThrowTypeAccessesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_throwTypeAccesses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_throwTypeAccesses_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__THROW_TYPE_ACCESSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Accesses feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAccessesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_accesses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_accesses_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__ACCESSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Statements feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfStatementsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_numberOfStatements_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_numberOfStatements_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__NUMBER_OF_STATEMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Maximum Nesting Level feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addMaximumNestingLevelPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_maximumNestingLevel_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_maximumNestingLevel_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__MAXIMUM_NESTING_LEVEL,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Comments feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCommentsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_linesOfComments_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_linesOfComments_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__LINES_OF_COMMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_linesOfCode_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_linesOfCode_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__LINES_OF_CODE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Edges In CFG feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfEdgesInCFGPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_numberOfEdgesInCFG_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_numberOfEdgesInCFG_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__NUMBER_OF_EDGES_IN_CFG,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Number Of Nodes In CFG feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addNumberOfNodesInCFGPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_numberOfNodesInCFG_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_numberOfNodesInCFG_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__NUMBER_OF_NODES_IN_CFG,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Operator feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOperatorPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Function_operator_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Function_operator_feature", "_UI_Function_type"),
				 functionsPackage.Literals.FUNCTION__OPERATOR,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(corePackage.Literals.SOURCE_ENTITY__POSITION);
			childrenFeatures.add(functionsPackage.Literals.FUNCTION__RETURN_TYPE_DECLARATION);
			childrenFeatures.add(functionsPackage.Literals.FUNCTION__FORMAL_PARAMETERS);
			childrenFeatures.add(functionsPackage.Literals.FUNCTION__LOCAL_VARIABLES);
			childrenFeatures.add(functionsPackage.Literals.FUNCTION__BODY);
			childrenFeatures.add(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		String label = NamedModelElementItemProvider.getLabel(object);
		return label == null || label.length() == 0 ?
			getString("_UI_Function_type") :
			getString("_UI_Function_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Function.class)) {
			case functionsPackage.FUNCTION__NUMBER_OF_STATEMENTS:
			case functionsPackage.FUNCTION__MAXIMUM_NESTING_LEVEL:
			case functionsPackage.FUNCTION__LINES_OF_COMMENTS:
			case functionsPackage.FUNCTION__LINES_OF_CODE:
			case functionsPackage.FUNCTION__NUMBER_OF_EDGES_IN_CFG:
			case functionsPackage.FUNCTION__NUMBER_OF_NODES_IN_CFG:
			case functionsPackage.FUNCTION__OPERATOR:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case functionsPackage.FUNCTION__POSITION:
			case functionsPackage.FUNCTION__RETURN_TYPE_DECLARATION:
			case functionsPackage.FUNCTION__FORMAL_PARAMETERS:
			case functionsPackage.FUNCTION__LOCAL_VARIABLES:
			case functionsPackage.FUNCTION__BODY:
			case functionsPackage.FUNCTION__LOCAL_CLASSES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.SOURCE_ENTITY__POSITION,
				 coreFactory.eINSTANCE.createPosition()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__RETURN_TYPE_DECLARATION,
				 accessesFactory.eINSTANCE.createDeclarationTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__FORMAL_PARAMETERS,
				 variablesFactory.eINSTANCE.createFormalParameter()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_VARIABLES,
				 variablesFactory.eINSTANCE.createLocalVariable()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__BODY,
				 statementsFactory.eINSTANCE.createBlockStatement()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__BODY,
				 statementsFactory.eINSTANCE.createCatchBlock()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 annotationsFactory.eINSTANCE.createAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createGASTClass()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createTypeParameterClass()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createGenericClass()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createGASTEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createGASTStruct()));

		newChildDescriptors.add
			(createChildParameter
				(functionsPackage.Literals.FUNCTION__LOCAL_CLASSES,
				 typesFactory.eINSTANCE.createGASTUnion()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return SissyModelEditPlugin.INSTANCE;
	}

}
