/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.core.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.accesses.accessesFactory;
import de.fzi.gast.annotations.annotationsFactory;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.coreFactory;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.functionsFactory;
import de.fzi.gast.statements.statementsFactory;
import de.fzi.gast.types.typesFactory;
import de.fzi.gast.variables.variablesFactory;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.core.Root} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RootItemProvider
	extends ModelElementItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RootItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addAllAccessesPropertyDescriptor(object);
			addAllInnerClassesPropertyDescriptor(object);
			addAllInterfacesPropertyDescriptor(object);
			addAllLocalClassesPropertyDescriptor(object);
			addAllNormalClassesPropertyDescriptor(object);
			addAllModelElementsPropertyDescriptor(object);
			addLinesOfCommentsPropertyDescriptor(object);
			addLinesOfCodePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the All Accesses feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllAccessesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allAccesses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allAccesses_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_ACCESSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Inner Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllInnerClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allInnerClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allInnerClasses_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_INNER_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Interfaces feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllInterfacesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allInterfaces_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allInterfaces_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_INTERFACES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Local Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllLocalClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allLocalClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allLocalClasses_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_LOCAL_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Normal Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllNormalClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allNormalClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allNormalClasses_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_NORMAL_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Model Elements feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllModelElementsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_allModelElements_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_allModelElements_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__ALL_MODEL_ELEMENTS,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Comments feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCommentsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_linesOfComments_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_linesOfComments_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__LINES_OF_COMMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Root_linesOfCode_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Root_linesOfCode_feature", "_UI_Root_type"),
				 corePackage.Literals.ROOT__LINES_OF_CODE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(corePackage.Literals.ROOT__GLOBAL_FUNCTIONS);
			childrenFeatures.add(corePackage.Literals.ROOT__GLOBAL_VARIABLES);
			childrenFeatures.add(corePackage.Literals.ROOT__CLONES);
			childrenFeatures.add(corePackage.Literals.ROOT__STRUCTURAL_ABSTRACTIONS);
			childrenFeatures.add(corePackage.Literals.ROOT__TYPES);
			childrenFeatures.add(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS);
			childrenFeatures.add(corePackage.Literals.ROOT__DIRECTORIES);
			childrenFeatures.add(corePackage.Literals.ROOT__PACKAGES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	protected boolean isWrappingNeeded(Object object)
	  {
		return true;
	    /*
		if (wrappingNeeded == null)
	    {
	      wrappingNeeded = Boolean.FALSE;
	      
	      for (EStructuralFeature f : getAnyChildrenFeatures(object))
	      {
	        if (f instanceof EAttribute)
	        {
	          wrappingNeeded = Boolean.TRUE;
	        }
	      }
	    }
	    return wrappingNeeded;
	    */
	  }
	
	/**
	 * This returns Root.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Root"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((Root)object).getId();
		return label == null || label.length() == 0 ?
			getString("_UI_Root_type") :
			getString("_UI_Root_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Root.class)) {
			case corePackage.ROOT__LINES_OF_COMMENTS:
			case corePackage.ROOT__LINES_OF_CODE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case corePackage.ROOT__GLOBAL_FUNCTIONS:
			case corePackage.ROOT__GLOBAL_VARIABLES:
			case corePackage.ROOT__CLONES:
			case corePackage.ROOT__STRUCTURAL_ABSTRACTIONS:
			case corePackage.ROOT__TYPES:
			case corePackage.ROOT__DANGLING_MODEL_ELEMENTS:
			case corePackage.ROOT__DIRECTORIES:
			case corePackage.ROOT__PACKAGES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__GLOBAL_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGlobalFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__GLOBAL_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGenericFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__GLOBAL_VARIABLES,
				 variablesFactory.eINSTANCE.createGlobalVariable()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__CLONES,
				 annotationsFactory.eINSTANCE.createClone()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__STRUCTURAL_ABSTRACTIONS,
				 annotationsFactory.eINSTANCE.createSubsystem()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__STRUCTURAL_ABSTRACTIONS,
				 annotationsFactory.eINSTANCE.createLayer()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 annotationsFactory.eINSTANCE.createAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createReference()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGASTArray()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createTypeAlias()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGASTClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createTypeParameterClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGenericClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGASTEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGASTStruct()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 typesFactory.eINSTANCE.createGASTUnion()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__TYPES,
				 functionsFactory.eINSTANCE.createDelegate()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 coreFactory.eINSTANCE.createFile()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 coreFactory.eINSTANCE.createPackage()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 coreFactory.eINSTANCE.createRoot()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 coreFactory.eINSTANCE.createDirectory()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 coreFactory.eINSTANCE.createPackageAlias()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createExceptionHandler()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createBlockStatement()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createBranch()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createBranchStatement()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createLoopStatement()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createCatchBlock()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createJumpStatement()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 statementsFactory.eINSTANCE.createSimpleStatement()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createClone()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createCloneInstance()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createComment()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createSubsystem()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 annotationsFactory.eINSTANCE.createLayer()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createReference()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGASTArray()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createTypeAlias()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGASTClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createTypeParameterClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGenericClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGASTEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGASTStruct()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 typesFactory.eINSTANCE.createGASTUnion()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createParameterInstantiationTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createCastTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createCompositeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createDeclarationTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createThrowTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createFunctionAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createDelegateAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createInheritanceTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createVariableAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createRunTimeTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createSelfAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createStaticTypeAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 accessesFactory.eINSTANCE.createPropertyAccess()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createDelegate()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createDestructor()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createGlobalFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createGenericFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createMethod()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createGenericMethod()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 functionsFactory.eINSTANCE.createGenericConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createFormalParameter()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createCatchParameter()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createField()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createGlobalVariable()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createLocalVariable()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS,
				 variablesFactory.eINSTANCE.createProperty()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__DIRECTORIES,
				 coreFactory.eINSTANCE.createDirectory()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__PACKAGES,
				 coreFactory.eINSTANCE.createPackage()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.ROOT__PACKAGES,
				 coreFactory.eINSTANCE.createPackageAlias()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == corePackage.Literals.ROOT__GLOBAL_FUNCTIONS ||
			childFeature == corePackage.Literals.ROOT__DANGLING_MODEL_ELEMENTS ||
			childFeature == corePackage.Literals.ROOT__GLOBAL_VARIABLES ||
			childFeature == corePackage.Literals.ROOT__CLONES ||
			childFeature == corePackage.Literals.ROOT__STRUCTURAL_ABSTRACTIONS ||
			childFeature == corePackage.Literals.ROOT__TYPES ||
			childFeature == corePackage.Literals.ROOT__PACKAGES ||
			childFeature == corePackage.Literals.ROOT__DIRECTORIES;

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

	 public Collection<?> getChildren(Object object) {
		Collection<?> children = super.getChildren(object);
		
		return children; 
	 }

}
