/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.core.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.gast.annotations.annotationsFactory;
import de.fzi.gast.core.coreFactory;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.functionsFactory;
import de.fzi.gast.types.typesFactory;
import de.fzi.gast.variables.variablesFactory;

/**
 * This is the item provider adapter for a {@link de.fzi.gast.core.Package} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class PackageItemProvider
	extends NamedModelElementItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackageItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addAllLocalClassesPropertyDescriptor(object);
			addAllInnerClassesPropertyDescriptor(object);
			addAllNormalClassesPropertyDescriptor(object);
			addAllInterfacesPropertyDescriptor(object);
			addAllAccessesPropertyDescriptor(object);
			addLinesOfCommentsPropertyDescriptor(object);
			addLinesOfCodePropertyDescriptor(object);
			addQualifiedNamePropertyDescriptor(object);
			addAllAccessedPackagesPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the All Local Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllLocalClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allLocalClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allLocalClasses_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_LOCAL_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Inner Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllInnerClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allInnerClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allInnerClasses_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_INNER_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Normal Classes feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllNormalClassesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allNormalClasses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allNormalClasses_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_NORMAL_CLASSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Interfaces feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllInterfacesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allInterfaces_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allInterfaces_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_INTERFACES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Accesses feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllAccessesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allAccesses_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allAccesses_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_ACCESSES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Comments feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCommentsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_linesOfComments_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_linesOfComments_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__LINES_OF_COMMENTS,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Lines Of Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLinesOfCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_linesOfCode_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_linesOfCode_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__LINES_OF_CODE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Qualified Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addQualifiedNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_qualifiedName_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_qualifiedName_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__QUALIFIED_NAME,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the All Accessed Packages feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAllAccessedPackagesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_Package_allAccessedPackages_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Package_allAccessedPackages_feature", "_UI_Package_type"),
				 corePackage.Literals.PACKAGE__ALL_ACCESSED_PACKAGES,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(corePackage.Literals.PACKAGE__DELEGATES);
			childrenFeatures.add(corePackage.Literals.PACKAGE__GLOBAL_FUNCTIONS);
			childrenFeatures.add(corePackage.Literals.PACKAGE__GLOBAL_VARIABLES);
			childrenFeatures.add(corePackage.Literals.PACKAGE__CLASSES);
			childrenFeatures.add(corePackage.Literals.PACKAGE__SUB_PACKAGES);
			childrenFeatures.add(corePackage.Literals.PACKAGE__TYPE_ALIASES);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns Package.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Package"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String getText(Object object) {
		String label = ((de.fzi.gast.core.Package)object).getQualifiedName();
		return label == null || label.length() == 0 ?
			getString("_UI_Package_type") :
			getString("_UI_Package_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(de.fzi.gast.core.Package.class)) {
			case corePackage.PACKAGE__LINES_OF_COMMENTS:
			case corePackage.PACKAGE__LINES_OF_CODE:
			case corePackage.PACKAGE__QUALIFIED_NAME:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case corePackage.PACKAGE__DELEGATES:
			case corePackage.PACKAGE__GLOBAL_FUNCTIONS:
			case corePackage.PACKAGE__GLOBAL_VARIABLES:
			case corePackage.PACKAGE__CLASSES:
			case corePackage.PACKAGE__SUB_PACKAGES:
			case corePackage.PACKAGE__TYPE_ALIASES:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__DELEGATES,
				 functionsFactory.eINSTANCE.createDelegate()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__GLOBAL_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGlobalFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__GLOBAL_FUNCTIONS,
				 functionsFactory.eINSTANCE.createGenericFunction()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__GLOBAL_VARIABLES,
				 variablesFactory.eINSTANCE.createGlobalVariable()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 annotationsFactory.eINSTANCE.createAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createGASTClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createTypeParameterClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createGenericClass()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createGASTEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createGASTStruct()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__CLASSES,
				 typesFactory.eINSTANCE.createGASTUnion()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__SUB_PACKAGES,
				 coreFactory.eINSTANCE.createPackage()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__SUB_PACKAGES,
				 coreFactory.eINSTANCE.createPackageAlias()));

		newChildDescriptors.add
			(createChildParameter
				(corePackage.Literals.PACKAGE__TYPE_ALIASES,
				 typesFactory.eINSTANCE.createTypeAlias()));
	}

}
