/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.gast.accesses.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.gast.accesses.util.accessesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class accessesItemProviderAdapterFactory extends accessesAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public accessesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.ParameterInstantiationTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterInstantiationTypeAccessItemProvider parameterInstantiationTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.ParameterInstantiationTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterInstantiationTypeAccessAdapter() {
		if (parameterInstantiationTypeAccessItemProvider == null) {
			parameterInstantiationTypeAccessItemProvider = new ParameterInstantiationTypeAccessItemProvider(this);
		}

		return parameterInstantiationTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.CompositeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeAccessItemProvider compositeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.CompositeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeAccessAdapter() {
		if (compositeAccessItemProvider == null) {
			compositeAccessItemProvider = new CompositeAccessItemProvider(this);
		}

		return compositeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.CastTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CastTypeAccessItemProvider castTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.CastTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCastTypeAccessAdapter() {
		if (castTypeAccessItemProvider == null) {
			castTypeAccessItemProvider = new CastTypeAccessItemProvider(this);
		}

		return castTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.DeclarationTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeclarationTypeAccessItemProvider declarationTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.DeclarationTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeclarationTypeAccessAdapter() {
		if (declarationTypeAccessItemProvider == null) {
			declarationTypeAccessItemProvider = new DeclarationTypeAccessItemProvider(this);
		}

		return declarationTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.DelegateAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelegateAccessItemProvider delegateAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.DelegateAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelegateAccessAdapter() {
		if (delegateAccessItemProvider == null) {
			delegateAccessItemProvider = new DelegateAccessItemProvider(this);
		}

		return delegateAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.FunctionAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionAccessItemProvider functionAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.FunctionAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionAccessAdapter() {
		if (functionAccessItemProvider == null) {
			functionAccessItemProvider = new FunctionAccessItemProvider(this);
		}

		return functionAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.InheritanceTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InheritanceTypeAccessItemProvider inheritanceTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.InheritanceTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInheritanceTypeAccessAdapter() {
		if (inheritanceTypeAccessItemProvider == null) {
			inheritanceTypeAccessItemProvider = new InheritanceTypeAccessItemProvider(this);
		}

		return inheritanceTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.VariableAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableAccessItemProvider variableAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.VariableAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAccessAdapter() {
		if (variableAccessItemProvider == null) {
			variableAccessItemProvider = new VariableAccessItemProvider(this);
		}

		return variableAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.RunTimeTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunTimeTypeAccessItemProvider runTimeTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.RunTimeTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunTimeTypeAccessAdapter() {
		if (runTimeTypeAccessItemProvider == null) {
			runTimeTypeAccessItemProvider = new RunTimeTypeAccessItemProvider(this);
		}

		return runTimeTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.SelfAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SelfAccessItemProvider selfAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.SelfAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSelfAccessAdapter() {
		if (selfAccessItemProvider == null) {
			selfAccessItemProvider = new SelfAccessItemProvider(this);
		}

		return selfAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.StaticTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticTypeAccessItemProvider staticTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.StaticTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStaticTypeAccessAdapter() {
		if (staticTypeAccessItemProvider == null) {
			staticTypeAccessItemProvider = new StaticTypeAccessItemProvider(this);
		}

		return staticTypeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.PropertyAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyAccessItemProvider propertyAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.PropertyAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyAccessAdapter() {
		if (propertyAccessItemProvider == null) {
			propertyAccessItemProvider = new PropertyAccessItemProvider(this);
		}

		return propertyAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.fzi.gast.accesses.ThrowTypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThrowTypeAccessItemProvider throwTypeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link de.fzi.gast.accesses.ThrowTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThrowTypeAccessAdapter() {
		if (throwTypeAccessItemProvider == null) {
			throwTypeAccessItemProvider = new ThrowTypeAccessItemProvider(this);
		}

		return throwTypeAccessItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (parameterInstantiationTypeAccessItemProvider != null) parameterInstantiationTypeAccessItemProvider.dispose();
		if (castTypeAccessItemProvider != null) castTypeAccessItemProvider.dispose();
		if (compositeAccessItemProvider != null) compositeAccessItemProvider.dispose();
		if (declarationTypeAccessItemProvider != null) declarationTypeAccessItemProvider.dispose();
		if (throwTypeAccessItemProvider != null) throwTypeAccessItemProvider.dispose();
		if (delegateAccessItemProvider != null) delegateAccessItemProvider.dispose();
		if (functionAccessItemProvider != null) functionAccessItemProvider.dispose();
		if (inheritanceTypeAccessItemProvider != null) inheritanceTypeAccessItemProvider.dispose();
		if (variableAccessItemProvider != null) variableAccessItemProvider.dispose();
		if (runTimeTypeAccessItemProvider != null) runTimeTypeAccessItemProvider.dispose();
		if (selfAccessItemProvider != null) selfAccessItemProvider.dispose();
		if (staticTypeAccessItemProvider != null) staticTypeAccessItemProvider.dispose();
		if (propertyAccessItemProvider != null) propertyAccessItemProvider.dispose();
	}

}
