/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.workplan.*;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Refactoring;
import de.fzi.maintainabilitymodel.workplan.Refinement;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.ToplevelActivity;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workplan.WorkplanPackage
 * @generated
 */
public class WorkplanSwitch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static WorkplanPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkplanSwitch() {
        if (modelPackage == null) {
            modelPackage = WorkplanPackage.eINSTANCE;
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case WorkplanPackage.ACTIVITY: {
                Activity activity = (Activity)theEObject;
                T result = caseActivity(activity);
                if (result == null) result = caseNamedEntity(activity);
                if (result == null) result = caseEntity(activity);
                if (result == null) result = caseIdentifier(activity);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.ARCHITECTURAL_ALTERNATIVE: {
                ArchitecturalAlternative architecturalAlternative = (ArchitecturalAlternative)theEObject;
                T result = caseArchitecturalAlternative(architecturalAlternative);
                if (result == null) result = caseNamedEntity(architecturalAlternative);
                if (result == null) result = caseEntity(architecturalAlternative);
                if (result == null) result = caseIdentifier(architecturalAlternative);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.CHANGE_REQUEST: {
                ChangeRequest changeRequest = (ChangeRequest)theEObject;
                T result = caseChangeRequest(changeRequest);
                if (result == null) result = caseNamedEntity(changeRequest);
                if (result == null) result = caseEntity(changeRequest);
                if (result == null) result = caseIdentifier(changeRequest);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.WORKPLAN: {
                Workplan workplan = (Workplan)theEObject;
                T result = caseWorkplan(workplan);
                if (result == null) result = caseNamedEntity(workplan);
                if (result == null) result = caseEntity(workplan);
                if (result == null) result = caseIdentifier(workplan);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.TASK: {
                Task task = (Task)theEObject;
                T result = caseTask(task);
                if (result == null) result = caseActivity(task);
                if (result == null) result = caseNamedEntity(task);
                if (result == null) result = caseEntity(task);
                if (result == null) result = caseIdentifier(task);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.COMPOSITE_TASK: {
                CompositeTask compositeTask = (CompositeTask)theEObject;
                T result = caseCompositeTask(compositeTask);
                if (result == null) result = caseTask(compositeTask);
                if (result == null) result = caseActivity(compositeTask);
                if (result == null) result = caseNamedEntity(compositeTask);
                if (result == null) result = caseEntity(compositeTask);
                if (result == null) result = caseIdentifier(compositeTask);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.TASK_RATIONALE: {
                TaskRationale taskRationale = (TaskRationale)theEObject;
                T result = caseTaskRationale(taskRationale);
                if (result == null) result = caseEntity(taskRationale);
                if (result == null) result = caseIdentifier(taskRationale);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.REFINEMENT: {
                Refinement refinement = (Refinement)theEObject;
                T result = caseRefinement(refinement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.REFACTORING: {
                Refactoring refactoring = (Refactoring)theEObject;
                T result = caseRefactoring(refactoring);
                if (result == null) result = caseNamedEntity(refactoring);
                if (result == null) result = caseEntity(refactoring);
                if (result == null) result = caseIdentifier(refactoring);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkplanPackage.TOPLEVEL_ACTIVITY: {
                ToplevelActivity toplevelActivity = (ToplevelActivity)theEObject;
                T result = caseToplevelActivity(toplevelActivity);
                if (result == null) result = caseTask(toplevelActivity);
                if (result == null) result = caseActivity(toplevelActivity);
                if (result == null) result = caseNamedEntity(toplevelActivity);
                if (result == null) result = caseEntity(toplevelActivity);
                if (result == null) result = caseIdentifier(toplevelActivity);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Task</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Task</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTask(Task object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Toplevel Activity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Toplevel Activity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseToplevelActivity(ToplevelActivity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Workplan</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Workplan</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseWorkplan(Workplan object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Composite Task</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Composite Task</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseCompositeTask(CompositeTask object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Task Rationale</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Task Rationale</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTaskRationale(TaskRationale object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Refinement</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Refinement</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseRefinement(Refinement object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Refactoring</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Refactoring</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseRefactoring(Refactoring object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseIdentifier(Identifier object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEntity(Entity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseNamedEntity(NamedEntity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Activity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Activity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseActivity(Activity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Architectural Alternative</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Architectural Alternative</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseArchitecturalAlternative(ArchitecturalAlternative object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Change Request</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Change Request</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseChangeRequest(ChangeRequest object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public T defaultCase(EObject object) {
        return null;
    }

} //WorkplanSwitch
