/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.workplan.*;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Refactoring;
import de.fzi.maintainabilitymodel.workplan.Refinement;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.ToplevelActivity;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workplan.WorkplanPackage
 * @generated
 */
public class WorkplanAdapterFactory extends AdapterFactoryImpl {
	/**
     * The cached model package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static WorkplanPackage modelPackage;

	/**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkplanAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = WorkplanPackage.eINSTANCE;
        }
    }

	/**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

	/**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WorkplanSwitch<Adapter> modelSwitch =
		new WorkplanSwitch<Adapter>() {
            @Override
            public Adapter caseActivity(Activity object) {
                return createActivityAdapter();
            }
            @Override
            public Adapter caseArchitecturalAlternative(ArchitecturalAlternative object) {
                return createArchitecturalAlternativeAdapter();
            }
            @Override
            public Adapter caseChangeRequest(ChangeRequest object) {
                return createChangeRequestAdapter();
            }
            @Override
            public Adapter caseWorkplan(Workplan object) {
                return createWorkplanAdapter();
            }
            @Override
            public Adapter caseTask(Task object) {
                return createTaskAdapter();
            }
            @Override
            public Adapter caseCompositeTask(CompositeTask object) {
                return createCompositeTaskAdapter();
            }
            @Override
            public Adapter caseTaskRationale(TaskRationale object) {
                return createTaskRationaleAdapter();
            }
            @Override
            public Adapter caseRefinement(Refinement object) {
                return createRefinementAdapter();
            }
            @Override
            public Adapter caseRefactoring(Refactoring object) {
                return createRefactoringAdapter();
            }
            @Override
            public Adapter caseToplevelActivity(ToplevelActivity object) {
                return createToplevelActivityAdapter();
            }
            @Override
            public Adapter caseIdentifier(Identifier object) {
                return createIdentifierAdapter();
            }
            @Override
            public Adapter caseEntity(Entity object) {
                return createEntityAdapter();
            }
            @Override
            public Adapter caseNamedEntity(NamedEntity object) {
                return createNamedEntityAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

	/**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
	@Override
	public Adapter createAdapter(Notifier target) {
        return modelSwitch.doSwitch((EObject)target);
    }


	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.Task <em>Task</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.Task
     * @generated
     */
	public Adapter createTaskAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.ToplevelActivity <em>Toplevel Activity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.ToplevelActivity
     * @generated
     */
	public Adapter createToplevelActivityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.Workplan <em>Workplan</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.Workplan
     * @generated
     */
	public Adapter createWorkplanAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.CompositeTask <em>Composite Task</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.CompositeTask
     * @generated
     */
	public Adapter createCompositeTaskAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.TaskRationale <em>Task Rationale</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.TaskRationale
     * @generated
     */
	public Adapter createTaskRationaleAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.Refinement <em>Refinement</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.Refinement
     * @generated
     */
	public Adapter createRefinementAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.Refactoring <em>Refactoring</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.Refactoring
     * @generated
     */
	public Adapter createRefactoringAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link eu.qimpress.identifier.Identifier <em>Identifier</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see eu.qimpress.identifier.Identifier
     * @generated
     */
	public Adapter createIdentifierAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.Entity <em>Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.Entity
     * @generated
     */
	public Adapter createEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.NamedEntity <em>Named Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.NamedEntity
     * @generated
     */
	public Adapter createNamedEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.Activity <em>Activity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.Activity
     * @generated
     */
	public Adapter createActivityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative <em>Architectural Alternative</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative
     * @generated
     */
	public Adapter createArchitecturalAlternativeAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest <em>Change Request</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest
     * @generated
     */
	public Adapter createChangeRequestAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
	public Adapter createEObjectAdapter() {
        return null;
    }

} //WorkplanAdapterFactory
