/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.SelectioncontainerPackage;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Parameter;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interface Selection Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.InterfaceSelectionContainerImpl#getDataTypesOfInterface <em>Data Types Of Interface</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.InterfaceSelectionContainerImpl#getReferencedInterface <em>Referenced Interface</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.InterfaceSelectionContainerImpl#getDatatypeselectioncontainer <em>Datatypeselectioncontainer</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.InterfaceSelectionContainerImpl#getOperationDefinitionSelectionContainer <em>Operation Definition Selection Container</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.InterfaceSelectionContainerImpl#getFollowups <em>Followups</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InterfaceSelectionContainerImpl extends AbstractContainerImpl implements InterfaceSelectionContainer {
	/**
     * The cached value of the '{@link #getReferencedInterface() <em>Referenced Interface</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getReferencedInterface()
     * @generated
     * @ordered
     */
	protected AbstractInterface referencedInterface;

	/**
     * The cached value of the '{@link #getDatatypeselectioncontainer() <em>Datatypeselectioncontainer</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDatatypeselectioncontainer()
     * @generated
     * @ordered
     */
	protected EList<DataTypeSelectionContainer> datatypeselectioncontainer;

	/**
     * The cached value of the '{@link #getOperationDefinitionSelectionContainer() <em>Operation Definition Selection Container</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOperationDefinitionSelectionContainer()
     * @generated
     * @ordered
     */
    protected EList<OperationDefinitionSelectionContainer> operationDefinitionSelectionContainer;

    /**
     * The cached value of the '{@link #getFollowups() <em>Followups</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getFollowups()
     * @generated
     * @ordered
     */
	protected EList<InterfacePortSelectionContainer> followups;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected InterfaceSelectionContainerImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SelectioncontainerPackage.Literals.INTERFACE_SELECTION_CONTAINER;
    }
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Type> getDataTypesOfInterface() {
		EList<Type> list = new BasicInternalEList(Type.class);
		//EList<Type> list = new BasicEList<Type>();
		
		SAMMInterfaceProxy interfaceProxy = (SAMMInterfaceProxy) this.getReferencedInterface();
		
		for(Operation operation : interfaceProxy.getInterface().getSignatures()) {
			if (operation.getInput()!=null)
				getDatatypeFromMessageType(operation.getInput(), list);
			if (operation.getOutput()!=null)
				getDatatypeFromMessageType(operation.getOutput(), list);
		}
		
		return list;
	} 

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	private void getDatatypeFromMessageType(MessageType messageType, List<Type> list){
		for(Parameter parameter : messageType.getParameters()){
			if (parameter.getType() != null)
				if(!list.contains(parameter.getType()))
					list.add(parameter.getType());
		}	
	}

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<InterfacePortSelectionContainer> getFollowups() {
        if (followups == null) {
            followups = new EObjectWithInverseResolvingEList<InterfacePortSelectionContainer>(InterfacePortSelectionContainer.class, this, SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS, SelectioncontainerPackage.INTERFACE_PORT_SELECTION_CONTAINER__INTERFACE_SELECTION_CONTAINER);
        }
        return followups;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getDatatypeselectioncontainer()).basicAdd(otherEnd, msgs);
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getOperationDefinitionSelectionContainer()).basicAdd(otherEnd, msgs);
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getFollowups()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                return ((InternalEList<?>)getDatatypeselectioncontainer()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                return ((InternalEList<?>)getOperationDefinitionSelectionContainer()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                return ((InternalEList<?>)getFollowups()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public AbstractInterface getReferencedInterface() {
        if (referencedInterface != null && referencedInterface.eIsProxy()) {
            InternalEObject oldReferencedInterface = (InternalEObject)referencedInterface;
            referencedInterface = (AbstractInterface)eResolveProxy(oldReferencedInterface);
            if (referencedInterface != oldReferencedInterface) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE, oldReferencedInterface, referencedInterface));
            }
        }
        return referencedInterface;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public AbstractInterface basicGetReferencedInterface() {
        return referencedInterface;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setReferencedInterface(AbstractInterface newReferencedInterface) {
        AbstractInterface oldReferencedInterface = referencedInterface;
        referencedInterface = newReferencedInterface;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE, oldReferencedInterface, referencedInterface));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<DataTypeSelectionContainer> getDatatypeselectioncontainer() {
        if (datatypeselectioncontainer == null) {
            datatypeselectioncontainer = new EObjectWithInverseResolvingEList.ManyInverse<DataTypeSelectionContainer>(DataTypeSelectionContainer.class, this, SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER, SelectioncontainerPackage.DATA_TYPE_SELECTION_CONTAINER__COMPLETE_INTERFACE_SELECTION_CONTAINERS);
        }
        return datatypeselectioncontainer;
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList<OperationDefinitionSelectionContainer> getOperationDefinitionSelectionContainer() {
        if (operationDefinitionSelectionContainer == null) {
            operationDefinitionSelectionContainer = new EObjectContainmentWithInverseEList<OperationDefinitionSelectionContainer>(OperationDefinitionSelectionContainer.class, this, SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER, SelectioncontainerPackage.OPERATION_DEFINITION_SELECTION_CONTAINER__INTERFACESELECTIONCONTAINER);
        }
        return operationDefinitionSelectionContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATA_TYPES_OF_INTERFACE:
                return getDataTypesOfInterface();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE:
                if (resolve) return getReferencedInterface();
                return basicGetReferencedInterface();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                return getDatatypeselectioncontainer();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                return getOperationDefinitionSelectionContainer();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                return getFollowups();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATA_TYPES_OF_INTERFACE:
                getDataTypesOfInterface().clear();
                getDataTypesOfInterface().addAll((Collection<? extends Type>)newValue);
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE:
                setReferencedInterface((AbstractInterface)newValue);
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                getDatatypeselectioncontainer().clear();
                getDatatypeselectioncontainer().addAll((Collection<? extends DataTypeSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                getOperationDefinitionSelectionContainer().clear();
                getOperationDefinitionSelectionContainer().addAll((Collection<? extends OperationDefinitionSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                getFollowups().clear();
                getFollowups().addAll((Collection<? extends InterfacePortSelectionContainer>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATA_TYPES_OF_INTERFACE:
                getDataTypesOfInterface().clear();
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE:
                setReferencedInterface((AbstractInterface)null);
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                getDatatypeselectioncontainer().clear();
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                getOperationDefinitionSelectionContainer().clear();
                return;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                getFollowups().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATA_TYPES_OF_INTERFACE:
                return !getDataTypesOfInterface().isEmpty();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__REFERENCED_INTERFACE:
                return referencedInterface != null;
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__DATATYPESELECTIONCONTAINER:
                return datatypeselectioncontainer != null && !datatypeselectioncontainer.isEmpty();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__OPERATION_DEFINITION_SELECTION_CONTAINER:
                return operationDefinitionSelectionContainer != null && !operationDefinitionSelectionContainer.isEmpty();
            case SelectioncontainerPackage.INTERFACE_SELECTION_CONTAINER__FOLLOWUPS:
                return followups != null && !followups.isEmpty();
        }
        return super.eIsSet(featureID);
    }

} //InterfaceSelectionContainerImpl
