/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.SelectioncontainerPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Composite Task Derivation Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getDataTypeSelectionContainers <em>Data Type Selection Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getComponentContainers <em>Component Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownComponentContainers <em>Last Shown Component Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownInterfaceportContainers <em>Last Shown Interfaceport Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getInterfaceSelectionContainers <em>Interface Selection Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownInterfaceContainers <em>Last Shown Interface Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownDataTypeSelectionContainers <em>Last Shown Data Type Selection Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownOperationSelectionContainer <em>Last Shown Operation Selection Container</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getTopLevelActivityContainer <em>Top Level Activity Container</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getCompositeComponentSelectionContainer <em>Composite Component Selection Container</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getLastShownCompositeComponentContainers <em>Last Shown Composite Component Containers</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getCompositeTaskDerivationContainer <em>Composite Task Derivation Container</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.CompositeTaskDerivationContainerImpl#getWorkplan <em>Workplan</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CompositeTaskDerivationContainerImpl extends AbstractContainerImpl implements CompositeTaskDerivationContainer {
	
	/**
     * The cached value of the '{@link #getDataTypeSelectionContainers() <em>Data Type Selection Containers</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDataTypeSelectionContainers()
     * @generated
     * @ordered
     */
	protected EList<DataTypeSelectionContainer> dataTypeSelectionContainers;

	/**
     * The cached value of the '{@link #getComponentContainers() <em>Component Containers</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getComponentContainers()
     * @generated
     * @ordered
     */
	protected EList<ComponentSelectionContainer> componentContainers;

	/**
     * The cached value of the '{@link #getLastShownComponentContainers() <em>Last Shown Component Containers</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLastShownComponentContainers()
     * @generated
     * @ordered
     */
	protected EList<ComponentSelectionContainer> lastShownComponentContainers;

	/**
     * The cached value of the '{@link #getLastShownInterfaceportContainers() <em>Last Shown Interfaceport Containers</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLastShownInterfaceportContainers()
     * @generated
     * @ordered
     */
	protected EList<InterfacePortSelectionContainer> lastShownInterfaceportContainers;

	/**
     * The cached value of the '{@link #getInterfaceSelectionContainers() <em>Interface Selection Containers</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getInterfaceSelectionContainers()
     * @generated
     * @ordered
     */
	protected EList<InterfaceSelectionContainer> interfaceSelectionContainers;

	/**
     * The cached value of the '{@link #getLastShownInterfaceContainers() <em>Last Shown Interface Containers</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLastShownInterfaceContainers()
     * @generated
     * @ordered
     */
	protected EList<InterfaceSelectionContainer> lastShownInterfaceContainers;

	/**
     * The cached value of the '{@link #getLastShownDataTypeSelectionContainers() <em>Last Shown Data Type Selection Containers</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLastShownDataTypeSelectionContainers()
     * @generated
     * @ordered
     */
	protected EList<DataTypeSelectionContainer> lastShownDataTypeSelectionContainers;

	/**
     * The cached value of the '{@link #getLastShownOperationSelectionContainer() <em>Last Shown Operation Selection Container</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLastShownOperationSelectionContainer()
     * @generated
     * @ordered
     */
	protected EList<OperationImplementationSelectionContainer> lastShownOperationSelectionContainer;

	/**
     * The cached value of the '{@link #getTopLevelActivityContainer() <em>Top Level Activity Container</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTopLevelActivityContainer()
     * @generated
     * @ordered
     */
	protected EList<AbstractContainer> topLevelActivityContainer;

	/**
     * The cached value of the '{@link #getCompositeComponentSelectionContainer() <em>Composite Component Selection Container</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCompositeComponentSelectionContainer()
     * @generated
     * @ordered
     */
    protected EList<CompositeComponentSelectionContainer> compositeComponentSelectionContainer;

    /**
     * The cached value of the '{@link #getLastShownCompositeComponentContainers() <em>Last Shown Composite Component Containers</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLastShownCompositeComponentContainers()
     * @generated
     * @ordered
     */
    protected EList<CompositeComponentSelectionContainer> lastShownCompositeComponentContainers;

    /**
     * The cached value of the '{@link #getCompositeTaskDerivationContainer() <em>Composite Task Derivation Container</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCompositeTaskDerivationContainer()
     * @generated
     * @ordered
     */
    protected EList<CompositeTaskDerivationContainer> compositeTaskDerivationContainer;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CompositeTaskDerivationContainerImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SelectioncontainerPackage.Literals.COMPOSITE_TASK_DERIVATION_CONTAINER;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<DataTypeSelectionContainer> getDataTypeSelectionContainers() {
        if (dataTypeSelectionContainers == null) {
            dataTypeSelectionContainers = new EObjectContainmentWithInverseEList<DataTypeSelectionContainer>(DataTypeSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS, SelectioncontainerPackage.DATA_TYPE_SELECTION_CONTAINER__WORKPLANDERIVATIONCONTAINER);
        }
        return dataTypeSelectionContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<ComponentSelectionContainer> getComponentContainers() {
        if (componentContainers == null) {
            componentContainers = new EObjectContainmentEList<ComponentSelectionContainer>(ComponentSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS);
        }
        return componentContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<ComponentSelectionContainer> getLastShownComponentContainers() {
        if (lastShownComponentContainers == null) {
            lastShownComponentContainers = new EObjectResolvingEList<ComponentSelectionContainer>(ComponentSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPONENT_CONTAINERS);
        }
        return lastShownComponentContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<InterfacePortSelectionContainer> getLastShownInterfaceportContainers() {
        if (lastShownInterfaceportContainers == null) {
            lastShownInterfaceportContainers = new EObjectResolvingEList<InterfacePortSelectionContainer>(InterfacePortSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACEPORT_CONTAINERS);
        }
        return lastShownInterfaceportContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<InterfaceSelectionContainer> getInterfaceSelectionContainers() {
        if (interfaceSelectionContainers == null) {
            interfaceSelectionContainers = new EObjectContainmentEList<InterfaceSelectionContainer>(InterfaceSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS);
        }
        return interfaceSelectionContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<InterfaceSelectionContainer> getLastShownInterfaceContainers() {
        if (lastShownInterfaceContainers == null) {
            lastShownInterfaceContainers = new EObjectResolvingEList<InterfaceSelectionContainer>(InterfaceSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACE_CONTAINERS);
        }
        return lastShownInterfaceContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<DataTypeSelectionContainer> getLastShownDataTypeSelectionContainers() {
        if (lastShownDataTypeSelectionContainers == null) {
            lastShownDataTypeSelectionContainers = new EObjectResolvingEList<DataTypeSelectionContainer>(DataTypeSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_DATA_TYPE_SELECTION_CONTAINERS);
        }
        return lastShownDataTypeSelectionContainers;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<OperationImplementationSelectionContainer> getLastShownOperationSelectionContainer() {
        if (lastShownOperationSelectionContainer == null) {
            lastShownOperationSelectionContainer = new EObjectResolvingEList<OperationImplementationSelectionContainer>(OperationImplementationSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_OPERATION_SELECTION_CONTAINER);
        }
        return lastShownOperationSelectionContainer;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<AbstractContainer> getTopLevelActivityContainer() {
        if (topLevelActivityContainer == null) {
            topLevelActivityContainer = new EObjectResolvingEList<AbstractContainer>(AbstractContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__TOP_LEVEL_ACTIVITY_CONTAINER);
        }
        return topLevelActivityContainer;
    }

	/**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList<CompositeComponentSelectionContainer> getCompositeComponentSelectionContainer() {
        if (compositeComponentSelectionContainer == null) {
            compositeComponentSelectionContainer = new EObjectContainmentEList<CompositeComponentSelectionContainer>(CompositeComponentSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER);
        }
        return compositeComponentSelectionContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList<CompositeComponentSelectionContainer> getLastShownCompositeComponentContainers() {
        if (lastShownCompositeComponentContainers == null) {
            lastShownCompositeComponentContainers = new EObjectResolvingEList<CompositeComponentSelectionContainer>(CompositeComponentSelectionContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPOSITE_COMPONENT_CONTAINERS);
        }
        return lastShownCompositeComponentContainers;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList<CompositeTaskDerivationContainer> getCompositeTaskDerivationContainer() {
        if (compositeTaskDerivationContainer == null) {
            compositeTaskDerivationContainer = new EObjectContainmentEList<CompositeTaskDerivationContainer>(CompositeTaskDerivationContainer.class, this, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER);
        }
        return compositeTaskDerivationContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Workplan getWorkplan() {
		if (eContainerFeatureID() != SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN) return null;
        return (Workplan)eContainer();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetWorkplan(Workplan newWorkplan, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newWorkplan, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN, msgs);
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setWorkplan(Workplan newWorkplan) {
        if (newWorkplan != eInternalContainer() || (eContainerFeatureID() != SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN && newWorkplan != null)) {
            if (EcoreUtil.isAncestor(this, newWorkplan))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newWorkplan != null)
                msgs = ((InternalEObject)newWorkplan).eInverseAdd(this, WorkplanPackage.WORKPLAN__COMPOSITETASKDERIVATIONCONTAINER, Workplan.class, msgs);
            msgs = basicSetWorkplan(newWorkplan, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN, newWorkplan, newWorkplan));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getDataTypeSelectionContainers()).basicAdd(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetWorkplan((Workplan)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                return ((InternalEList<?>)getDataTypeSelectionContainers()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS:
                return ((InternalEList<?>)getComponentContainers()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS:
                return ((InternalEList<?>)getInterfaceSelectionContainers()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER:
                return ((InternalEList<?>)getCompositeComponentSelectionContainer()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER:
                return ((InternalEList<?>)getCompositeTaskDerivationContainer()).basicRemove(otherEnd, msgs);
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                return basicSetWorkplan(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID()) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                return eInternalContainer().eInverseRemove(this, WorkplanPackage.WORKPLAN__COMPOSITETASKDERIVATIONCONTAINER, Workplan.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                return getDataTypeSelectionContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS:
                return getComponentContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPONENT_CONTAINERS:
                return getLastShownComponentContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACEPORT_CONTAINERS:
                return getLastShownInterfaceportContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS:
                return getInterfaceSelectionContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACE_CONTAINERS:
                return getLastShownInterfaceContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_DATA_TYPE_SELECTION_CONTAINERS:
                return getLastShownDataTypeSelectionContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_OPERATION_SELECTION_CONTAINER:
                return getLastShownOperationSelectionContainer();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__TOP_LEVEL_ACTIVITY_CONTAINER:
                return getTopLevelActivityContainer();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER:
                return getCompositeComponentSelectionContainer();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPOSITE_COMPONENT_CONTAINERS:
                return getLastShownCompositeComponentContainers();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER:
                return getCompositeTaskDerivationContainer();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                return getWorkplan();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                getDataTypeSelectionContainers().clear();
                getDataTypeSelectionContainers().addAll((Collection<? extends DataTypeSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS:
                getComponentContainers().clear();
                getComponentContainers().addAll((Collection<? extends ComponentSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPONENT_CONTAINERS:
                getLastShownComponentContainers().clear();
                getLastShownComponentContainers().addAll((Collection<? extends ComponentSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACEPORT_CONTAINERS:
                getLastShownInterfaceportContainers().clear();
                getLastShownInterfaceportContainers().addAll((Collection<? extends InterfacePortSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS:
                getInterfaceSelectionContainers().clear();
                getInterfaceSelectionContainers().addAll((Collection<? extends InterfaceSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACE_CONTAINERS:
                getLastShownInterfaceContainers().clear();
                getLastShownInterfaceContainers().addAll((Collection<? extends InterfaceSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_DATA_TYPE_SELECTION_CONTAINERS:
                getLastShownDataTypeSelectionContainers().clear();
                getLastShownDataTypeSelectionContainers().addAll((Collection<? extends DataTypeSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_OPERATION_SELECTION_CONTAINER:
                getLastShownOperationSelectionContainer().clear();
                getLastShownOperationSelectionContainer().addAll((Collection<? extends OperationImplementationSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__TOP_LEVEL_ACTIVITY_CONTAINER:
                getTopLevelActivityContainer().clear();
                getTopLevelActivityContainer().addAll((Collection<? extends AbstractContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER:
                getCompositeComponentSelectionContainer().clear();
                getCompositeComponentSelectionContainer().addAll((Collection<? extends CompositeComponentSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPOSITE_COMPONENT_CONTAINERS:
                getLastShownCompositeComponentContainers().clear();
                getLastShownCompositeComponentContainers().addAll((Collection<? extends CompositeComponentSelectionContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER:
                getCompositeTaskDerivationContainer().clear();
                getCompositeTaskDerivationContainer().addAll((Collection<? extends CompositeTaskDerivationContainer>)newValue);
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                setWorkplan((Workplan)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                getDataTypeSelectionContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS:
                getComponentContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPONENT_CONTAINERS:
                getLastShownComponentContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACEPORT_CONTAINERS:
                getLastShownInterfaceportContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS:
                getInterfaceSelectionContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACE_CONTAINERS:
                getLastShownInterfaceContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_DATA_TYPE_SELECTION_CONTAINERS:
                getLastShownDataTypeSelectionContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_OPERATION_SELECTION_CONTAINER:
                getLastShownOperationSelectionContainer().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__TOP_LEVEL_ACTIVITY_CONTAINER:
                getTopLevelActivityContainer().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER:
                getCompositeComponentSelectionContainer().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPOSITE_COMPONENT_CONTAINERS:
                getLastShownCompositeComponentContainers().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER:
                getCompositeTaskDerivationContainer().clear();
                return;
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                setWorkplan((Workplan)null);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__DATA_TYPE_SELECTION_CONTAINERS:
                return dataTypeSelectionContainers != null && !dataTypeSelectionContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPONENT_CONTAINERS:
                return componentContainers != null && !componentContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPONENT_CONTAINERS:
                return lastShownComponentContainers != null && !lastShownComponentContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACEPORT_CONTAINERS:
                return lastShownInterfaceportContainers != null && !lastShownInterfaceportContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__INTERFACE_SELECTION_CONTAINERS:
                return interfaceSelectionContainers != null && !interfaceSelectionContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_INTERFACE_CONTAINERS:
                return lastShownInterfaceContainers != null && !lastShownInterfaceContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_DATA_TYPE_SELECTION_CONTAINERS:
                return lastShownDataTypeSelectionContainers != null && !lastShownDataTypeSelectionContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_OPERATION_SELECTION_CONTAINER:
                return lastShownOperationSelectionContainer != null && !lastShownOperationSelectionContainer.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__TOP_LEVEL_ACTIVITY_CONTAINER:
                return topLevelActivityContainer != null && !topLevelActivityContainer.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_COMPONENT_SELECTION_CONTAINER:
                return compositeComponentSelectionContainer != null && !compositeComponentSelectionContainer.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__LAST_SHOWN_COMPOSITE_COMPONENT_CONTAINERS:
                return lastShownCompositeComponentContainers != null && !lastShownCompositeComponentContainers.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__COMPOSITE_TASK_DERIVATION_CONTAINER:
                return compositeTaskDerivationContainer != null && !compositeTaskDerivationContainer.isEmpty();
            case SelectioncontainerPackage.COMPOSITE_TASK_DERIVATION_CONTAINER__WORKPLAN:
                return getWorkplan() != null;
        }
        return super.eIsSet(featureID);
    }
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public List<OperationImplementationSelectionContainer> getAlreadyExistingOperationsSelectionContainer(){
		List<OperationImplementationSelectionContainer> operationContainers = new LinkedList<OperationImplementationSelectionContainer>();		
		for(InterfacePortSelectionContainer portContainer : this.getInterfacePortSelectionContainer()){
			
			if(portContainer.getRefinements() != null)
				operationContainers.addAll(portContainer.getRefinements());
		}		
		return operationContainers;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public List<InterfacePortSelectionContainer> getInterfacePortSelectionContainer() {
		
		List<InterfacePortSelectionContainer> result = new ArrayList<InterfacePortSelectionContainer>();
		
		for (ComponentSelectionContainer componentContainer : this.getComponentContainers()) {
			result.addAll(componentContainer.getRefinements());
		}
		
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public List<OperationImplementationSelectionContainer> getOperationImplementationSelectionContainer() {
		 
		 List<OperationImplementationSelectionContainer> result = new ArrayList<OperationImplementationSelectionContainer>();
			
		 for (InterfacePortSelectionContainer interfacePortContainer : this.getInterfacePortSelectionContainer()) {
			 result.addAll(interfacePortContainer.getRefinements());
		 }

		 return result;
	}	
}
