/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.fzi.maintainabilitymodel.main.impl.EntityImpl;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.SelectioncontainerPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.AbstractContainerImpl#isAlreadyAdded <em>Already Added</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.AbstractContainerImpl#isSelected <em>Selected</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.AbstractContainerImpl#getBasicActivity <em>Basic Activity</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.AbstractContainerImpl#getActivity <em>Activity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AbstractContainerImpl extends EntityImpl implements AbstractContainer {
	/**
     * The default value of the '{@link #isAlreadyAdded() <em>Already Added</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isAlreadyAdded()
     * @generated
     * @ordered
     */
	protected static final boolean ALREADY_ADDED_EDEFAULT = false;

	/**
     * The cached value of the '{@link #isAlreadyAdded() <em>Already Added</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isAlreadyAdded()
     * @generated
     * @ordered
     */
	protected boolean alreadyAdded = ALREADY_ADDED_EDEFAULT;

	/**
     * The default value of the '{@link #isSelected() <em>Selected</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isSelected()
     * @generated
     * @ordered
     */
	protected static final boolean SELECTED_EDEFAULT = false;

	/**
     * The cached value of the '{@link #isSelected() <em>Selected</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #isSelected()
     * @generated
     * @ordered
     */
	protected boolean selected = SELECTED_EDEFAULT;

	/**
     * The default value of the '{@link #getBasicActivity() <em>Basic Activity</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getBasicActivity()
     * @generated
     * @ordered
     */
	protected static final BasicActivity BASIC_ACTIVITY_EDEFAULT = BasicActivity.ADD;

	/**
     * The cached value of the '{@link #getBasicActivity() <em>Basic Activity</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getBasicActivity()
     * @generated
     * @ordered
     */
	protected BasicActivity basicActivity = BASIC_ACTIVITY_EDEFAULT;

	/**
     * The cached value of the '{@link #getActivity() <em>Activity</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getActivity()
     * @generated
     * @ordered
     */
	protected Activity activity;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AbstractContainerImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SelectioncontainerPackage.Literals.ABSTRACT_CONTAINER;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isAlreadyAdded() {
        return alreadyAdded;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setAlreadyAdded(boolean newAlreadyAdded) {
        boolean oldAlreadyAdded = alreadyAdded;
        alreadyAdded = newAlreadyAdded;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.ABSTRACT_CONTAINER__ALREADY_ADDED, oldAlreadyAdded, alreadyAdded));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isSelected() {
        return selected;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSelected(boolean newSelected) {
        boolean oldSelected = selected;
        selected = newSelected;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.ABSTRACT_CONTAINER__SELECTED, oldSelected, selected));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BasicActivity getBasicActivity() {
        return basicActivity;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setBasicActivity(BasicActivity newBasicActivity) {
        BasicActivity oldBasicActivity = basicActivity;
        basicActivity = newBasicActivity == null ? BASIC_ACTIVITY_EDEFAULT : newBasicActivity;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.ABSTRACT_CONTAINER__BASIC_ACTIVITY, oldBasicActivity, basicActivity));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Activity getActivity() {
        if (activity != null && activity.eIsProxy()) {
            InternalEObject oldActivity = (InternalEObject)activity;
            activity = (Activity)eResolveProxy(oldActivity);
            if (activity != oldActivity) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, oldActivity, activity));
            }
        }
        return activity;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Activity basicGetActivity() {
        return activity;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetActivity(Activity newActivity, NotificationChain msgs) {
        Activity oldActivity = activity;
        activity = newActivity;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, oldActivity, newActivity);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setActivity(Activity newActivity) {
        if (newActivity != activity) {
            NotificationChain msgs = null;
            if (activity != null)
                msgs = ((InternalEObject)activity).eInverseRemove(this, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, Activity.class, msgs);
            if (newActivity != null)
                msgs = ((InternalEObject)newActivity).eInverseAdd(this, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, Activity.class, msgs);
            msgs = basicSetActivity(newActivity, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, newActivity, newActivity));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                if (activity != null)
                    msgs = ((InternalEObject)activity).eInverseRemove(this, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, Activity.class, msgs);
                return basicSetActivity((Activity)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                return basicSetActivity(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ALREADY_ADDED:
                return isAlreadyAdded();
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__SELECTED:
                return isSelected();
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__BASIC_ACTIVITY:
                return getBasicActivity();
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                if (resolve) return getActivity();
                return basicGetActivity();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ALREADY_ADDED:
                setAlreadyAdded((Boolean)newValue);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__SELECTED:
                setSelected((Boolean)newValue);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__BASIC_ACTIVITY:
                setBasicActivity((BasicActivity)newValue);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                setActivity((Activity)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ALREADY_ADDED:
                setAlreadyAdded(ALREADY_ADDED_EDEFAULT);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__SELECTED:
                setSelected(SELECTED_EDEFAULT);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__BASIC_ACTIVITY:
                setBasicActivity(BASIC_ACTIVITY_EDEFAULT);
                return;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                setActivity((Activity)null);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ALREADY_ADDED:
                return alreadyAdded != ALREADY_ADDED_EDEFAULT;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__SELECTED:
                return selected != SELECTED_EDEFAULT;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__BASIC_ACTIVITY:
                return basicActivity != BASIC_ACTIVITY_EDEFAULT;
            case SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY:
                return activity != null;
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (alreadyAdded: ");
        result.append(alreadyAdded);
        result.append(", selected: ");
        result.append(selected);
        result.append(", basicActivity: ");
        result.append(basicActivity);
        result.append(')');
        return result.toString();
    }

} //AbstractContainerImpl
