/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.impl;

import de.fzi.maintainabilitymodel.workplan.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Refactoring;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class WorkplanFactoryImpl extends EFactoryImpl implements WorkplanFactory {
	/**
     * Creates the default factory implementation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static WorkplanFactory init() {
        try {
            WorkplanFactory theWorkplanFactory = (WorkplanFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fzi.de/maintainabilitymodel/workplan"); 
            if (theWorkplanFactory != null) {
                return theWorkplanFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new WorkplanFactoryImpl();
    }

	/**
     * Creates an instance of the factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkplanFactoryImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case WorkplanPackage.ARCHITECTURAL_ALTERNATIVE: return createArchitecturalAlternative();
            case WorkplanPackage.CHANGE_REQUEST: return createChangeRequest();
            case WorkplanPackage.WORKPLAN: return createWorkplan();
            case WorkplanPackage.COMPOSITE_TASK: return createCompositeTask();
            case WorkplanPackage.TASK_RATIONALE: return createTaskRationale();
            case WorkplanPackage.REFACTORING: return createRefactoring();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ArchitecturalAlternative createArchitecturalAlternative() {
        ArchitecturalAlternativeImpl architecturalAlternative = new ArchitecturalAlternativeImpl();
        return architecturalAlternative;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ChangeRequest createChangeRequest() {
        ChangeRequestImpl changeRequest = new ChangeRequestImpl();
        return changeRequest;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Workplan createWorkplan() {
        WorkplanImpl workplan = new WorkplanImpl();
        return workplan;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CompositeTask createCompositeTask() {
        CompositeTaskImpl compositeTask = new CompositeTaskImpl();
        return compositeTask;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TaskRationale createTaskRationale() {
        TaskRationaleImpl taskRationale = new TaskRationaleImpl();
        return taskRationale;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Refactoring createRefactoring() {
        RefactoringImpl refactoring = new RefactoringImpl();
        return refactoring;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkplanPackage getWorkplanPackage() {
        return (WorkplanPackage)getEPackage();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
	@Deprecated
	public static WorkplanPackage getPackage() {
        return WorkplanPackage.eINSTANCE;
    }

} //WorkplanFactoryImpl
