/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.maintainabilitymodel.main.impl.NamedEntityImpl;
import de.fzi.maintainabilitymodel.metrics.Estimate;
import de.fzi.maintainabilitymodel.workorganisation.Role;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.SelectioncontainerPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Activity</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getSelectioncontainer <em>Selectioncontainer</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getAggregatedCostEstimate <em>Aggregated Cost Estimate</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getAggregatedTimeEstimate <em>Aggregated Time Estimate</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getCostEstimate <em>Cost Estimate</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getWorkTimeEstimate <em>Work Time Estimate</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getEstimates <em>Estimates</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl#getRole <em>Role</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ActivityImpl extends NamedEntityImpl implements Activity {
	/**
     * The cached value of the '{@link #getSelectioncontainer() <em>Selectioncontainer</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSelectioncontainer()
     * @generated
     * @ordered
     */
	protected AbstractContainer selectioncontainer;

	/**
     * The default value of the '{@link #getAggregatedCostEstimate() <em>Aggregated Cost Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAggregatedCostEstimate()
     * @generated
     * @ordered
     */
	protected static final double AGGREGATED_COST_ESTIMATE_EDEFAULT = 0.0;

	/**
     * The default value of the '{@link #getAggregatedTimeEstimate() <em>Aggregated Time Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAggregatedTimeEstimate()
     * @generated
     * @ordered
     */
	protected static final double AGGREGATED_TIME_ESTIMATE_EDEFAULT = 0.0;

	/**
     * The default value of the '{@link #getCostEstimate() <em>Cost Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getCostEstimate()
     * @generated
     * @ordered
     */
	protected static final double COST_ESTIMATE_EDEFAULT = 0.0;

	/**
     * The cached value of the '{@link #getCostEstimate() <em>Cost Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getCostEstimate()
     * @generated
     * @ordered
     */
	protected double costEstimate = COST_ESTIMATE_EDEFAULT;

	/**
     * The default value of the '{@link #getWorkTimeEstimate() <em>Work Time Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getWorkTimeEstimate()
     * @generated
     * @ordered
     */
	protected static final double WORK_TIME_ESTIMATE_EDEFAULT = 0.0;

	/**
     * The cached value of the '{@link #getWorkTimeEstimate() <em>Work Time Estimate</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getWorkTimeEstimate()
     * @generated
     * @ordered
     */
	protected double workTimeEstimate = WORK_TIME_ESTIMATE_EDEFAULT;

	/**
     * The cached value of the '{@link #getEstimates() <em>Estimates</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getEstimates()
     * @generated
     * @ordered
     */
	protected EList<Estimate> estimates;

	/**
     * The cached value of the '{@link #getRole() <em>Role</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getRole()
     * @generated
     * @ordered
     */
	protected Role role;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ActivityImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return WorkplanPackage.Literals.ACTIVITY;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public AbstractContainer getSelectioncontainer() {
        if (selectioncontainer != null && selectioncontainer.eIsProxy()) {
            InternalEObject oldSelectioncontainer = (InternalEObject)selectioncontainer;
            selectioncontainer = (AbstractContainer)eResolveProxy(oldSelectioncontainer);
            if (selectioncontainer != oldSelectioncontainer) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, oldSelectioncontainer, selectioncontainer));
            }
        }
        return selectioncontainer;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public AbstractContainer basicGetSelectioncontainer() {
        return selectioncontainer;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetSelectioncontainer(AbstractContainer newSelectioncontainer, NotificationChain msgs) {
        AbstractContainer oldSelectioncontainer = selectioncontainer;
        selectioncontainer = newSelectioncontainer;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, oldSelectioncontainer, newSelectioncontainer);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setSelectioncontainer(AbstractContainer newSelectioncontainer) {
        if (newSelectioncontainer != selectioncontainer) {
            NotificationChain msgs = null;
            if (selectioncontainer != null)
                msgs = ((InternalEObject)selectioncontainer).eInverseRemove(this, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, AbstractContainer.class, msgs);
            if (newSelectioncontainer != null)
                msgs = ((InternalEObject)newSelectioncontainer).eInverseAdd(this, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, AbstractContainer.class, msgs);
            msgs = basicSetSelectioncontainer(newSelectioncontainer, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, WorkplanPackage.ACTIVITY__SELECTIONCONTAINER, newSelectioncontainer, newSelectioncontainer));
    }

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public double getAggregatedCostEstimate() {
		double result = 0.0;

		result = this.getCostEstimate();
		
		Iterator<EObject> itr = this.eAllContents();
		while (itr.hasNext()) {
			EObject obj = itr.next();
			
			if (obj instanceof Activity) {
				result += ((Activity)obj).getCostEstimate();
			}
		}
		
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAggregatedCostEstimate(double newAggregatedCostEstimate) {
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public double getAggregatedTimeEstimate() {
		double result = 0.0;

		result = this.getWorkTimeEstimate();
		
		Iterator<EObject> itr = this.eAllContents();
		while (itr.hasNext()) {
			EObject obj = itr.next();
			
			if (obj instanceof Activity) {
				result += ((Activity)obj).getWorkTimeEstimate();
			}
		}
		
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAggregatedTimeEstimate(double newAggregatedTimeEstimate) {
	}

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public double getCostEstimate() {
        return costEstimate;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setCostEstimate(double newCostEstimate) {
        double oldCostEstimate = costEstimate;
        costEstimate = newCostEstimate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, WorkplanPackage.ACTIVITY__COST_ESTIMATE, oldCostEstimate, costEstimate));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public double getWorkTimeEstimate() {
        return workTimeEstimate;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setWorkTimeEstimate(double newWorkTimeEstimate) {
        double oldWorkTimeEstimate = workTimeEstimate;
        workTimeEstimate = newWorkTimeEstimate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, WorkplanPackage.ACTIVITY__WORK_TIME_ESTIMATE, oldWorkTimeEstimate, workTimeEstimate));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<Estimate> getEstimates() {
        if (estimates == null) {
            estimates = new EObjectContainmentEList<Estimate>(Estimate.class, this, WorkplanPackage.ACTIVITY__ESTIMATES);
        }
        return estimates;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Role getRole() {
        if (role != null && role.eIsProxy()) {
            InternalEObject oldRole = (InternalEObject)role;
            role = (Role)eResolveProxy(oldRole);
            if (role != oldRole) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, WorkplanPackage.ACTIVITY__ROLE, oldRole, role));
            }
        }
        return role;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Role basicGetRole() {
        return role;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setRole(Role newRole) {
        Role oldRole = role;
        role = newRole;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, WorkplanPackage.ACTIVITY__ROLE, oldRole, role));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                if (selectioncontainer != null)
                    msgs = ((InternalEObject)selectioncontainer).eInverseRemove(this, SelectioncontainerPackage.ABSTRACT_CONTAINER__ACTIVITY, AbstractContainer.class, msgs);
                return basicSetSelectioncontainer((AbstractContainer)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                return basicSetSelectioncontainer(null, msgs);
            case WorkplanPackage.ACTIVITY__ESTIMATES:
                return ((InternalEList<?>)getEstimates()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                if (resolve) return getSelectioncontainer();
                return basicGetSelectioncontainer();
            case WorkplanPackage.ACTIVITY__AGGREGATED_COST_ESTIMATE:
                return getAggregatedCostEstimate();
            case WorkplanPackage.ACTIVITY__AGGREGATED_TIME_ESTIMATE:
                return getAggregatedTimeEstimate();
            case WorkplanPackage.ACTIVITY__COST_ESTIMATE:
                return getCostEstimate();
            case WorkplanPackage.ACTIVITY__WORK_TIME_ESTIMATE:
                return getWorkTimeEstimate();
            case WorkplanPackage.ACTIVITY__ESTIMATES:
                return getEstimates();
            case WorkplanPackage.ACTIVITY__ROLE:
                if (resolve) return getRole();
                return basicGetRole();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                setSelectioncontainer((AbstractContainer)newValue);
                return;
            case WorkplanPackage.ACTIVITY__AGGREGATED_COST_ESTIMATE:
                setAggregatedCostEstimate((Double)newValue);
                return;
            case WorkplanPackage.ACTIVITY__AGGREGATED_TIME_ESTIMATE:
                setAggregatedTimeEstimate((Double)newValue);
                return;
            case WorkplanPackage.ACTIVITY__COST_ESTIMATE:
                setCostEstimate((Double)newValue);
                return;
            case WorkplanPackage.ACTIVITY__WORK_TIME_ESTIMATE:
                setWorkTimeEstimate((Double)newValue);
                return;
            case WorkplanPackage.ACTIVITY__ESTIMATES:
                getEstimates().clear();
                getEstimates().addAll((Collection<? extends Estimate>)newValue);
                return;
            case WorkplanPackage.ACTIVITY__ROLE:
                setRole((Role)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                setSelectioncontainer((AbstractContainer)null);
                return;
            case WorkplanPackage.ACTIVITY__AGGREGATED_COST_ESTIMATE:
                setAggregatedCostEstimate(AGGREGATED_COST_ESTIMATE_EDEFAULT);
                return;
            case WorkplanPackage.ACTIVITY__AGGREGATED_TIME_ESTIMATE:
                setAggregatedTimeEstimate(AGGREGATED_TIME_ESTIMATE_EDEFAULT);
                return;
            case WorkplanPackage.ACTIVITY__COST_ESTIMATE:
                setCostEstimate(COST_ESTIMATE_EDEFAULT);
                return;
            case WorkplanPackage.ACTIVITY__WORK_TIME_ESTIMATE:
                setWorkTimeEstimate(WORK_TIME_ESTIMATE_EDEFAULT);
                return;
            case WorkplanPackage.ACTIVITY__ESTIMATES:
                getEstimates().clear();
                return;
            case WorkplanPackage.ACTIVITY__ROLE:
                setRole((Role)null);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case WorkplanPackage.ACTIVITY__SELECTIONCONTAINER:
                return selectioncontainer != null;
            case WorkplanPackage.ACTIVITY__AGGREGATED_COST_ESTIMATE:
                return getAggregatedCostEstimate() != AGGREGATED_COST_ESTIMATE_EDEFAULT;
            case WorkplanPackage.ACTIVITY__AGGREGATED_TIME_ESTIMATE:
                return getAggregatedTimeEstimate() != AGGREGATED_TIME_ESTIMATE_EDEFAULT;
            case WorkplanPackage.ACTIVITY__COST_ESTIMATE:
                return costEstimate != COST_ESTIMATE_EDEFAULT;
            case WorkplanPackage.ACTIVITY__WORK_TIME_ESTIMATE:
                return workTimeEstimate != WORK_TIME_ESTIMATE_EDEFAULT;
            case WorkplanPackage.ACTIVITY__ESTIMATES:
                return estimates != null && !estimates.isEmpty();
            case WorkplanPackage.ACTIVITY__ROLE:
                return role != null;
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (costEstimate: ");
        result.append(costEstimate);
        result.append(", workTimeEstimate: ");
        result.append(workTimeEstimate);
        result.append(')');
        return result.toString();
    }

} //ActivityImpl
