/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.maintainabilitymodel.main.MainPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workplan.WorkplanFactory
 * @model kind="package"
 * @generated
 */
public interface WorkplanPackage extends EPackage {
	/**
     * The package name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNAME = "workplan";

	/**
     * The package namespace URI.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_URI = "http://www.fzi.de/maintainabilitymodel/workplan";

	/**
     * The package namespace name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_PREFIX = "workplan";

	/**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	WorkplanPackage eINSTANCE = de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl.init();

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl <em>Activity</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getActivity()
     * @generated
     */
	int ACTIVITY = 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Selectioncontainer</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__SELECTIONCONTAINER = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Aggregated Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__AGGREGATED_COST_ESTIMATE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Aggregated Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__AGGREGATED_TIME_ESTIMATE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The feature id for the '<em><b>Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__COST_ESTIMATE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The feature id for the '<em><b>Work Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__WORK_TIME_ESTIMATE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
     * The feature id for the '<em><b>Estimates</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__ESTIMATES = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
     * The feature id for the '<em><b>Role</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY__ROLE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 6;

	/**
     * The number of structural features of the '<em>Activity</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ACTIVITY_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 7;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ArchitecturalAlternativeImpl <em>Architectural Alternative</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.ArchitecturalAlternativeImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getArchitecturalAlternative()
     * @generated
     */
	int ARCHITECTURAL_ALTERNATIVE = 1;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE__DESCRIPTION = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Architecturemodel</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE__ARCHITECTUREMODEL = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Maintainabilityanalysismodel</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE__MAINTAINABILITYANALYSISMODEL = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Architectural Alternative</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ARCHITECTURAL_ALTERNATIVE_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ChangeRequestImpl <em>Change Request</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.ChangeRequestImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getChangeRequest()
     * @generated
     */
	int CHANGE_REQUEST = 2;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST__DESCRIPTION = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Automatic Derivation</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST__AUTOMATIC_DERIVATION = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Maintainabilityanalysismodel</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST__MAINTAINABILITYANALYSISMODEL = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Change Request</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CHANGE_REQUEST_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.TaskImpl <em>Task</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.TaskImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getTask()
     * @generated
     */
	int TASK = 4;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ToplevelActivityImpl <em>Toplevel Activity</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.ToplevelActivityImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getToplevelActivity()
     * @generated
     */
	int TOPLEVEL_ACTIVITY = 9;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.WorkplanImpl <em>Workplan</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getWorkplan()
     * @generated
     */
	int WORKPLAN = 3;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Tasks</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN__TASKS = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Compositetaskderivationcontainer</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN__COMPOSITETASKDERIVATIONCONTAINER = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Effortanalaysisinstance</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN__EFFORTANALAYSISINSTANCE = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Workplan</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKPLAN_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__ID = ACTIVITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__NAME = ACTIVITY__NAME;

	/**
     * The feature id for the '<em><b>Selectioncontainer</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__SELECTIONCONTAINER = ACTIVITY__SELECTIONCONTAINER;

	/**
     * The feature id for the '<em><b>Aggregated Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__AGGREGATED_COST_ESTIMATE = ACTIVITY__AGGREGATED_COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Aggregated Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__AGGREGATED_TIME_ESTIMATE = ACTIVITY__AGGREGATED_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__COST_ESTIMATE = ACTIVITY__COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Work Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__WORK_TIME_ESTIMATE = ACTIVITY__WORK_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Estimates</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__ESTIMATES = ACTIVITY__ESTIMATES;

	/**
     * The feature id for the '<em><b>Role</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__ROLE = ACTIVITY__ROLE;

	/**
     * The feature id for the '<em><b>Compositetask</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__COMPOSITETASK = ACTIVITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Workplan</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__WORKPLAN = ACTIVITY_FEATURE_COUNT + 1;

	/**
     * The number of structural features of the '<em>Task</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_FEATURE_COUNT = ACTIVITY_FEATURE_COUNT + 2;

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.Activity <em>Activity</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Activity</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity
     * @generated
     */
	EClass getActivity();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.workplan.Activity#getSelectioncontainer <em>Selectioncontainer</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Selectioncontainer</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getSelectioncontainer()
     * @see #getActivity()
     * @generated
     */
	EReference getActivity_Selectioncontainer();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.Activity#getAggregatedCostEstimate <em>Aggregated Cost Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Aggregated Cost Estimate</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getAggregatedCostEstimate()
     * @see #getActivity()
     * @generated
     */
	EAttribute getActivity_AggregatedCostEstimate();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.Activity#getAggregatedTimeEstimate <em>Aggregated Time Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Aggregated Time Estimate</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getAggregatedTimeEstimate()
     * @see #getActivity()
     * @generated
     */
	EAttribute getActivity_AggregatedTimeEstimate();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.Activity#getCostEstimate <em>Cost Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Cost Estimate</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getCostEstimate()
     * @see #getActivity()
     * @generated
     */
	EAttribute getActivity_CostEstimate();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.Activity#getWorkTimeEstimate <em>Work Time Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Work Time Estimate</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getWorkTimeEstimate()
     * @see #getActivity()
     * @generated
     */
	EAttribute getActivity_WorkTimeEstimate();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workplan.Activity#getEstimates <em>Estimates</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Estimates</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getEstimates()
     * @see #getActivity()
     * @generated
     */
	EReference getActivity_Estimates();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.workplan.Activity#getRole <em>Role</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Role</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Activity#getRole()
     * @see #getActivity()
     * @generated
     */
	EReference getActivity_Role();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative <em>Architectural Alternative</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Architectural Alternative</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative
     * @generated
     */
	EClass getArchitecturalAlternative();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getDescription <em>Description</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Description</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getDescription()
     * @see #getArchitecturalAlternative()
     * @generated
     */
	EAttribute getArchitecturalAlternative_Description();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getArchitecturemodel <em>Architecturemodel</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Architecturemodel</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getArchitecturemodel()
     * @see #getArchitecturalAlternative()
     * @generated
     */
	EReference getArchitecturalAlternative_Architecturemodel();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getMaintainabilityanalysismodel <em>Maintainabilityanalysismodel</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Maintainabilityanalysismodel</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getMaintainabilityanalysismodel()
     * @see #getArchitecturalAlternative()
     * @generated
     */
	EReference getArchitecturalAlternative_Maintainabilityanalysismodel();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest <em>Change Request</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Change Request</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest
     * @generated
     */
	EClass getChangeRequest();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest#getDescription <em>Description</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Description</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest#getDescription()
     * @see #getChangeRequest()
     * @generated
     */
	EAttribute getChangeRequest_Description();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest#isAutomaticDerivation <em>Automatic Derivation</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Automatic Derivation</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest#isAutomaticDerivation()
     * @see #getChangeRequest()
     * @generated
     */
	EAttribute getChangeRequest_AutomaticDerivation();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest#getMaintainabilityanalysismodel <em>Maintainabilityanalysismodel</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Maintainabilityanalysismodel</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest#getMaintainabilityanalysismodel()
     * @see #getChangeRequest()
     * @generated
     */
	EReference getChangeRequest_Maintainabilityanalysismodel();

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.CompositeTaskImpl <em>Composite Task</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.CompositeTaskImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getCompositeTask()
     * @generated
     */
	int COMPOSITE_TASK = 5;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__ID = TASK__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__NAME = TASK__NAME;

	/**
     * The feature id for the '<em><b>Selectioncontainer</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__SELECTIONCONTAINER = TASK__SELECTIONCONTAINER;

	/**
     * The feature id for the '<em><b>Aggregated Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__AGGREGATED_COST_ESTIMATE = TASK__AGGREGATED_COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Aggregated Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__AGGREGATED_TIME_ESTIMATE = TASK__AGGREGATED_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__COST_ESTIMATE = TASK__COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Work Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__WORK_TIME_ESTIMATE = TASK__WORK_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Estimates</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__ESTIMATES = TASK__ESTIMATES;

	/**
     * The feature id for the '<em><b>Role</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__ROLE = TASK__ROLE;

	/**
     * The feature id for the '<em><b>Compositetask</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__COMPOSITETASK = TASK__COMPOSITETASK;

	/**
     * The feature id for the '<em><b>Workplan</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__WORKPLAN = TASK__WORKPLAN;

	/**
     * The feature id for the '<em><b>Taskrationale</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__TASKRATIONALE = TASK_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Subtasks</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK__SUBTASKS = TASK_FEATURE_COUNT + 1;

	/**
     * The number of structural features of the '<em>Composite Task</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPOSITE_TASK_FEATURE_COUNT = TASK_FEATURE_COUNT + 2;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.TaskRationaleImpl <em>Task Rationale</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.TaskRationaleImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getTaskRationale()
     * @generated
     */
	int TASK_RATIONALE = 6;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_RATIONALE__ID = MainPackage.ENTITY__ID;

	/**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_RATIONALE__DESCRIPTION = MainPackage.ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Keyword</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_RATIONALE__KEYWORD = MainPackage.ENTITY_FEATURE_COUNT + 1;

	/**
     * The number of structural features of the '<em>Task Rationale</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_RATIONALE_FEATURE_COUNT = MainPackage.ENTITY_FEATURE_COUNT + 2;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.RefinementImpl <em>Refinement</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.RefinementImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getRefinement()
     * @generated
     */
	int REFINEMENT = 7;

	/**
     * The number of structural features of the '<em>Refinement</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFINEMENT_FEATURE_COUNT = 0;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workplan.impl.RefactoringImpl <em>Refactoring</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workplan.impl.RefactoringImpl
     * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getRefactoring()
     * @generated
     */
	int REFACTORING = 8;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFACTORING__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFACTORING__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The number of structural features of the '<em>Refactoring</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFACTORING_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__ID = TASK__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__NAME = TASK__NAME;

	/**
     * The feature id for the '<em><b>Selectioncontainer</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__SELECTIONCONTAINER = TASK__SELECTIONCONTAINER;

	/**
     * The feature id for the '<em><b>Aggregated Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__AGGREGATED_COST_ESTIMATE = TASK__AGGREGATED_COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Aggregated Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__AGGREGATED_TIME_ESTIMATE = TASK__AGGREGATED_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Cost Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__COST_ESTIMATE = TASK__COST_ESTIMATE;

	/**
     * The feature id for the '<em><b>Work Time Estimate</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__WORK_TIME_ESTIMATE = TASK__WORK_TIME_ESTIMATE;

	/**
     * The feature id for the '<em><b>Estimates</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__ESTIMATES = TASK__ESTIMATES;

	/**
     * The feature id for the '<em><b>Role</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__ROLE = TASK__ROLE;

	/**
     * The feature id for the '<em><b>Compositetask</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__COMPOSITETASK = TASK__COMPOSITETASK;

	/**
     * The feature id for the '<em><b>Workplan</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__WORKPLAN = TASK__WORKPLAN;

	/**
     * The feature id for the '<em><b>Responsiblerole</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__RESPONSIBLEROLE = TASK_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Level</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY__LEVEL = TASK_FEATURE_COUNT + 1;

	/**
     * The number of structural features of the '<em>Toplevel Activity</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TOPLEVEL_ACTIVITY_FEATURE_COUNT = TASK_FEATURE_COUNT + 2;

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.Task <em>Task</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Task</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Task
     * @generated
     */
	EClass getTask();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workplan.Task#getWorkplan <em>Workplan</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Workplan</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Task#getWorkplan()
     * @see #getTask()
     * @generated
     */
	EReference getTask_Workplan();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workplan.Task#getCompositetask <em>Compositetask</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Compositetask</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Task#getCompositetask()
     * @see #getTask()
     * @generated
     */
	EReference getTask_Compositetask();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.ToplevelActivity <em>Toplevel Activity</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Toplevel Activity</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ToplevelActivity
     * @generated
     */
	EClass getToplevelActivity();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.workplan.ToplevelActivity#getResponsiblerole <em>Responsiblerole</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Responsiblerole</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ToplevelActivity#getResponsiblerole()
     * @see #getToplevelActivity()
     * @generated
     */
	EReference getToplevelActivity_Responsiblerole();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.ToplevelActivity#getLevel <em>Level</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Level</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.ToplevelActivity#getLevel()
     * @see #getToplevelActivity()
     * @generated
     */
	EAttribute getToplevelActivity_Level();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.Workplan <em>Workplan</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Workplan</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Workplan
     * @generated
     */
	EClass getWorkplan();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workplan.Workplan#getEffortanalaysisinstance <em>Effortanalaysisinstance</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Effortanalaysisinstance</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Workplan#getEffortanalaysisinstance()
     * @see #getWorkplan()
     * @generated
     */
	EReference getWorkplan_Effortanalaysisinstance();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workplan.Workplan#getTasks <em>Tasks</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Tasks</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Workplan#getTasks()
     * @see #getWorkplan()
     * @generated
     */
	EReference getWorkplan_Tasks();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workplan.Workplan#getCompositetaskderivationcontainer <em>Compositetaskderivationcontainer</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Compositetaskderivationcontainer</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Workplan#getCompositetaskderivationcontainer()
     * @see #getWorkplan()
     * @generated
     */
	EReference getWorkplan_Compositetaskderivationcontainer();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.CompositeTask <em>Composite Task</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Composite Task</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.CompositeTask
     * @generated
     */
	EClass getCompositeTask();

	/**
     * Returns the meta object for the containment reference '{@link de.fzi.maintainabilitymodel.workplan.CompositeTask#getTaskrationale <em>Taskrationale</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Taskrationale</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.CompositeTask#getTaskrationale()
     * @see #getCompositeTask()
     * @generated
     */
	EReference getCompositeTask_Taskrationale();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workplan.CompositeTask#getSubtasks <em>Subtasks</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Subtasks</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.CompositeTask#getSubtasks()
     * @see #getCompositeTask()
     * @generated
     */
	EReference getCompositeTask_Subtasks();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.TaskRationale <em>Task Rationale</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Task Rationale</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.TaskRationale
     * @generated
     */
	EClass getTaskRationale();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.TaskRationale#getDescription <em>Description</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Description</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.TaskRationale#getDescription()
     * @see #getTaskRationale()
     * @generated
     */
	EAttribute getTaskRationale_Description();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.workplan.TaskRationale#getKeyword <em>Keyword</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Keyword</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.TaskRationale#getKeyword()
     * @see #getTaskRationale()
     * @generated
     */
	EAttribute getTaskRationale_Keyword();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.Refinement <em>Refinement</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Refinement</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Refinement
     * @generated
     */
	EClass getRefinement();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workplan.Refactoring <em>Refactoring</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Refactoring</em>'.
     * @see de.fzi.maintainabilitymodel.workplan.Refactoring
     * @generated
     */
	EClass getRefactoring();

	/**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	WorkplanFactory getWorkplanFactory();

	/**
     * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
     * @generated
     */
	interface Literals {
		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl <em>Activity</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.ActivityImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getActivity()
         * @generated
         */
		EClass ACTIVITY = eINSTANCE.getActivity();

		/**
         * The meta object literal for the '<em><b>Selectioncontainer</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ACTIVITY__SELECTIONCONTAINER = eINSTANCE.getActivity_Selectioncontainer();

		/**
         * The meta object literal for the '<em><b>Aggregated Cost Estimate</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ACTIVITY__AGGREGATED_COST_ESTIMATE = eINSTANCE.getActivity_AggregatedCostEstimate();

		/**
         * The meta object literal for the '<em><b>Aggregated Time Estimate</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ACTIVITY__AGGREGATED_TIME_ESTIMATE = eINSTANCE.getActivity_AggregatedTimeEstimate();

		/**
         * The meta object literal for the '<em><b>Cost Estimate</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ACTIVITY__COST_ESTIMATE = eINSTANCE.getActivity_CostEstimate();

		/**
         * The meta object literal for the '<em><b>Work Time Estimate</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ACTIVITY__WORK_TIME_ESTIMATE = eINSTANCE.getActivity_WorkTimeEstimate();

		/**
         * The meta object literal for the '<em><b>Estimates</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ACTIVITY__ESTIMATES = eINSTANCE.getActivity_Estimates();

		/**
         * The meta object literal for the '<em><b>Role</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ACTIVITY__ROLE = eINSTANCE.getActivity_Role();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ArchitecturalAlternativeImpl <em>Architectural Alternative</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.ArchitecturalAlternativeImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getArchitecturalAlternative()
         * @generated
         */
		EClass ARCHITECTURAL_ALTERNATIVE = eINSTANCE.getArchitecturalAlternative();

		/**
         * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ARCHITECTURAL_ALTERNATIVE__DESCRIPTION = eINSTANCE.getArchitecturalAlternative_Description();

		/**
         * The meta object literal for the '<em><b>Architecturemodel</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ARCHITECTURAL_ALTERNATIVE__ARCHITECTUREMODEL = eINSTANCE.getArchitecturalAlternative_Architecturemodel();

		/**
         * The meta object literal for the '<em><b>Maintainabilityanalysismodel</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ARCHITECTURAL_ALTERNATIVE__MAINTAINABILITYANALYSISMODEL = eINSTANCE.getArchitecturalAlternative_Maintainabilityanalysismodel();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ChangeRequestImpl <em>Change Request</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.ChangeRequestImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getChangeRequest()
         * @generated
         */
		EClass CHANGE_REQUEST = eINSTANCE.getChangeRequest();

		/**
         * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute CHANGE_REQUEST__DESCRIPTION = eINSTANCE.getChangeRequest_Description();

		/**
         * The meta object literal for the '<em><b>Automatic Derivation</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute CHANGE_REQUEST__AUTOMATIC_DERIVATION = eINSTANCE.getChangeRequest_AutomaticDerivation();

		/**
         * The meta object literal for the '<em><b>Maintainabilityanalysismodel</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference CHANGE_REQUEST__MAINTAINABILITYANALYSISMODEL = eINSTANCE.getChangeRequest_Maintainabilityanalysismodel();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.TaskImpl <em>Task</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.TaskImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getTask()
         * @generated
         */
		EClass TASK = eINSTANCE.getTask();

		/**
         * The meta object literal for the '<em><b>Workplan</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TASK__WORKPLAN = eINSTANCE.getTask_Workplan();

		/**
         * The meta object literal for the '<em><b>Compositetask</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TASK__COMPOSITETASK = eINSTANCE.getTask_Compositetask();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.ToplevelActivityImpl <em>Toplevel Activity</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.ToplevelActivityImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getToplevelActivity()
         * @generated
         */
		EClass TOPLEVEL_ACTIVITY = eINSTANCE.getToplevelActivity();

		/**
         * The meta object literal for the '<em><b>Responsiblerole</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TOPLEVEL_ACTIVITY__RESPONSIBLEROLE = eINSTANCE.getToplevelActivity_Responsiblerole();

		/**
         * The meta object literal for the '<em><b>Level</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute TOPLEVEL_ACTIVITY__LEVEL = eINSTANCE.getToplevelActivity_Level();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.WorkplanImpl <em>Workplan</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getWorkplan()
         * @generated
         */
		EClass WORKPLAN = eINSTANCE.getWorkplan();

		/**
         * The meta object literal for the '<em><b>Effortanalaysisinstance</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference WORKPLAN__EFFORTANALAYSISINSTANCE = eINSTANCE.getWorkplan_Effortanalaysisinstance();

		/**
         * The meta object literal for the '<em><b>Tasks</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference WORKPLAN__TASKS = eINSTANCE.getWorkplan_Tasks();

		/**
         * The meta object literal for the '<em><b>Compositetaskderivationcontainer</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference WORKPLAN__COMPOSITETASKDERIVATIONCONTAINER = eINSTANCE.getWorkplan_Compositetaskderivationcontainer();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.CompositeTaskImpl <em>Composite Task</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.CompositeTaskImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getCompositeTask()
         * @generated
         */
		EClass COMPOSITE_TASK = eINSTANCE.getCompositeTask();

		/**
         * The meta object literal for the '<em><b>Taskrationale</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPOSITE_TASK__TASKRATIONALE = eINSTANCE.getCompositeTask_Taskrationale();

		/**
         * The meta object literal for the '<em><b>Subtasks</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPOSITE_TASK__SUBTASKS = eINSTANCE.getCompositeTask_Subtasks();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.TaskRationaleImpl <em>Task Rationale</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.TaskRationaleImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getTaskRationale()
         * @generated
         */
		EClass TASK_RATIONALE = eINSTANCE.getTaskRationale();

		/**
         * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute TASK_RATIONALE__DESCRIPTION = eINSTANCE.getTaskRationale_Description();

		/**
         * The meta object literal for the '<em><b>Keyword</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute TASK_RATIONALE__KEYWORD = eINSTANCE.getTaskRationale_Keyword();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.RefinementImpl <em>Refinement</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.RefinementImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getRefinement()
         * @generated
         */
		EClass REFINEMENT = eINSTANCE.getRefinement();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workplan.impl.RefactoringImpl <em>Refactoring</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workplan.impl.RefactoringImpl
         * @see de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl#getRefactoring()
         * @generated
         */
		EClass REFACTORING = eINSTANCE.getRefactoring();

	}

} //WorkplanPackage
