/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.workorganisation.*;
import de.fzi.maintainabilitymodel.workorganisation.Company;
import de.fzi.maintainabilitymodel.workorganisation.Department;
import de.fzi.maintainabilitymodel.workorganisation.Person;
import de.fzi.maintainabilitymodel.workorganisation.Role;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage
 * @generated
 */
public class WorkorganisationSwitch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static WorkorganisationPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkorganisationSwitch() {
        if (modelPackage == null) {
            modelPackage = WorkorganisationPackage.eINSTANCE;
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case WorkorganisationPackage.ROLE: {
                Role role = (Role)theEObject;
                T result = caseRole(role);
                if (result == null) result = caseWorkOrganisationElement(role);
                if (result == null) result = caseNamedEntity(role);
                if (result == null) result = caseEntity(role);
                if (result == null) result = caseIdentifier(role);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.WORK_ORGANISATION_ELEMENT: {
                WorkOrganisationElement workOrganisationElement = (WorkOrganisationElement)theEObject;
                T result = caseWorkOrganisationElement(workOrganisationElement);
                if (result == null) result = caseNamedEntity(workOrganisationElement);
                if (result == null) result = caseEntity(workOrganisationElement);
                if (result == null) result = caseIdentifier(workOrganisationElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.PERSON: {
                Person person = (Person)theEObject;
                T result = casePerson(person);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.COMPANY: {
                Company company = (Company)theEObject;
                T result = caseCompany(company);
                if (result == null) result = caseWorkOrganisationElement(company);
                if (result == null) result = caseNamedEntity(company);
                if (result == null) result = caseEntity(company);
                if (result == null) result = caseIdentifier(company);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.DEPARTMENT: {
                Department department = (Department)theEObject;
                T result = caseDepartment(department);
                if (result == null) result = caseWorkOrganisationElement(department);
                if (result == null) result = caseNamedEntity(department);
                if (result == null) result = caseEntity(department);
                if (result == null) result = caseIdentifier(department);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.TEAM: {
                Team team = (Team)theEObject;
                T result = caseTeam(team);
                if (result == null) result = caseWorkOrganisationElement(team);
                if (result == null) result = caseNamedEntity(team);
                if (result == null) result = caseEntity(team);
                if (result == null) result = caseIdentifier(team);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.SOFTWARE_ARCHITECT: {
                SoftwareArchitect softwareArchitect = (SoftwareArchitect)theEObject;
                T result = caseSoftwareArchitect(softwareArchitect);
                if (result == null) result = caseRole(softwareArchitect);
                if (result == null) result = caseWorkOrganisationElement(softwareArchitect);
                if (result == null) result = caseNamedEntity(softwareArchitect);
                if (result == null) result = caseEntity(softwareArchitect);
                if (result == null) result = caseIdentifier(softwareArchitect);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.SOFTWARE_DEVELOPER: {
                SoftwareDeveloper softwareDeveloper = (SoftwareDeveloper)theEObject;
                T result = caseSoftwareDeveloper(softwareDeveloper);
                if (result == null) result = caseRole(softwareDeveloper);
                if (result == null) result = caseWorkOrganisationElement(softwareDeveloper);
                if (result == null) result = caseNamedEntity(softwareDeveloper);
                if (result == null) result = caseEntity(softwareDeveloper);
                if (result == null) result = caseIdentifier(softwareDeveloper);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case WorkorganisationPackage.WORK_ORGANISATION_MODEL: {
                WorkOrganisationModel workOrganisationModel = (WorkOrganisationModel)theEObject;
                T result = caseWorkOrganisationModel(workOrganisationModel);
                if (result == null) result = caseNamedEntity(workOrganisationModel);
                if (result == null) result = caseEntity(workOrganisationModel);
                if (result == null) result = caseIdentifier(workOrganisationModel);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Role</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Role</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseRole(Role object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Work Organisation Element</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Work Organisation Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseWorkOrganisationElement(WorkOrganisationElement object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Person</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Person</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T casePerson(Person object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Company</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Company</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseCompany(Company object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Department</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Department</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseDepartment(Department object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Team</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Team</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTeam(Team object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Software Architect</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Software Architect</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSoftwareArchitect(SoftwareArchitect object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Software Developer</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Software Developer</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSoftwareDeveloper(SoftwareDeveloper object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Work Organisation Model</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Work Organisation Model</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseWorkOrganisationModel(WorkOrganisationModel object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseIdentifier(Identifier object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEntity(Entity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseNamedEntity(NamedEntity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public T defaultCase(EObject object) {
        return null;
    }

} //WorkorganisationSwitch
