/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.workorganisation.*;
import de.fzi.maintainabilitymodel.workorganisation.Company;
import de.fzi.maintainabilitymodel.workorganisation.Department;
import de.fzi.maintainabilitymodel.workorganisation.Person;
import de.fzi.maintainabilitymodel.workorganisation.Role;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage
 * @generated
 */
public class WorkorganisationAdapterFactory extends AdapterFactoryImpl {
	/**
     * The cached model package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static WorkorganisationPackage modelPackage;

	/**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkorganisationAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = WorkorganisationPackage.eINSTANCE;
        }
    }

	/**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

	/**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WorkorganisationSwitch<Adapter> modelSwitch =
		new WorkorganisationSwitch<Adapter>() {
            @Override
            public Adapter caseRole(Role object) {
                return createRoleAdapter();
            }
            @Override
            public Adapter caseWorkOrganisationElement(WorkOrganisationElement object) {
                return createWorkOrganisationElementAdapter();
            }
            @Override
            public Adapter casePerson(Person object) {
                return createPersonAdapter();
            }
            @Override
            public Adapter caseCompany(Company object) {
                return createCompanyAdapter();
            }
            @Override
            public Adapter caseDepartment(Department object) {
                return createDepartmentAdapter();
            }
            @Override
            public Adapter caseTeam(Team object) {
                return createTeamAdapter();
            }
            @Override
            public Adapter caseSoftwareArchitect(SoftwareArchitect object) {
                return createSoftwareArchitectAdapter();
            }
            @Override
            public Adapter caseSoftwareDeveloper(SoftwareDeveloper object) {
                return createSoftwareDeveloperAdapter();
            }
            @Override
            public Adapter caseWorkOrganisationModel(WorkOrganisationModel object) {
                return createWorkOrganisationModelAdapter();
            }
            @Override
            public Adapter caseIdentifier(Identifier object) {
                return createIdentifierAdapter();
            }
            @Override
            public Adapter caseEntity(Entity object) {
                return createEntityAdapter();
            }
            @Override
            public Adapter caseNamedEntity(NamedEntity object) {
                return createNamedEntityAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

	/**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
	@Override
	public Adapter createAdapter(Notifier target) {
        return modelSwitch.doSwitch((EObject)target);
    }


	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.Role <em>Role</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.Role
     * @generated
     */
	public Adapter createRoleAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement <em>Work Organisation Element</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement
     * @generated
     */
	public Adapter createWorkOrganisationElementAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.Person <em>Person</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.Person
     * @generated
     */
	public Adapter createPersonAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.Company <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company
     * @generated
     */
	public Adapter createCompanyAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.Department <em>Department</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.Department
     * @generated
     */
	public Adapter createDepartmentAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.Team <em>Team</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.Team
     * @generated
     */
	public Adapter createTeamAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect <em>Software Architect</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect
     * @generated
     */
	public Adapter createSoftwareArchitectAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper <em>Software Developer</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper
     * @generated
     */
	public Adapter createSoftwareDeveloperAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel <em>Work Organisation Model</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel
     * @generated
     */
	public Adapter createWorkOrganisationModelAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link eu.qimpress.identifier.Identifier <em>Identifier</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see eu.qimpress.identifier.Identifier
     * @generated
     */
	public Adapter createIdentifierAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.Entity <em>Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.Entity
     * @generated
     */
	public Adapter createEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.NamedEntity <em>Named Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.NamedEntity
     * @generated
     */
	public Adapter createNamedEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
	public Adapter createEObjectAdapter() {
        return null;
    }

} //WorkorganisationAdapterFactory
