/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation.impl;

import de.fzi.maintainabilitymodel.workorganisation.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.fzi.maintainabilitymodel.workorganisation.Company;
import de.fzi.maintainabilitymodel.workorganisation.Department;
import de.fzi.maintainabilitymodel.workorganisation.Person;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationFactory;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class WorkorganisationFactoryImpl extends EFactoryImpl implements WorkorganisationFactory {
	/**
     * Creates the default factory implementation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static WorkorganisationFactory init() {
        try {
            WorkorganisationFactory theWorkorganisationFactory = (WorkorganisationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fzi.de/maintainabilitymodel/workorganisation"); 
            if (theWorkorganisationFactory != null) {
                return theWorkorganisationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new WorkorganisationFactoryImpl();
    }

	/**
     * Creates an instance of the factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkorganisationFactoryImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case WorkorganisationPackage.PERSON: return createPerson();
            case WorkorganisationPackage.COMPANY: return createCompany();
            case WorkorganisationPackage.DEPARTMENT: return createDepartment();
            case WorkorganisationPackage.TEAM: return createTeam();
            case WorkorganisationPackage.SOFTWARE_ARCHITECT: return createSoftwareArchitect();
            case WorkorganisationPackage.SOFTWARE_DEVELOPER: return createSoftwareDeveloper();
            case WorkorganisationPackage.WORK_ORGANISATION_MODEL: return createWorkOrganisationModel();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Person createPerson() {
        PersonImpl person = new PersonImpl();
        return person;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Company createCompany() {
        CompanyImpl company = new CompanyImpl();
        return company;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Department createDepartment() {
        DepartmentImpl department = new DepartmentImpl();
        return department;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Team createTeam() {
        TeamImpl team = new TeamImpl();
        return team;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public SoftwareArchitect createSoftwareArchitect() {
        SoftwareArchitectImpl softwareArchitect = new SoftwareArchitectImpl();
        return softwareArchitect;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public SoftwareDeveloper createSoftwareDeveloper() {
        SoftwareDeveloperImpl softwareDeveloper = new SoftwareDeveloperImpl();
        return softwareDeveloper;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkOrganisationModel createWorkOrganisationModel() {
        WorkOrganisationModelImpl workOrganisationModel = new WorkOrganisationModelImpl();
        return workOrganisationModel;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkorganisationPackage getWorkorganisationPackage() {
        return (WorkorganisationPackage)getEPackage();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
	@Deprecated
	public static WorkorganisationPackage getPackage() {
        return WorkorganisationPackage.eINSTANCE;
    }

} //WorkorganisationFactoryImpl
