/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.maintainabilitymodel.workorganisation.Company;
import de.fzi.maintainabilitymodel.workorganisation.Department;
import de.fzi.maintainabilitymodel.workorganisation.Person;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Company</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl#getDepartments <em>Departments</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl#getChiefarchitects <em>Chiefarchitects</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl#getWorkorganisationmodel <em>Workorganisationmodel</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl#getStaff <em>Staff</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CompanyImpl extends WorkOrganisationElementImpl implements Company {
	/**
     * The cached value of the '{@link #getDepartments() <em>Departments</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDepartments()
     * @generated
     * @ordered
     */
	protected EList<Department> departments;

	/**
     * The cached value of the '{@link #getChiefarchitects() <em>Chiefarchitects</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getChiefarchitects()
     * @generated
     * @ordered
     */
	protected EList<SoftwareArchitect> chiefarchitects;

	/**
     * The cached value of the '{@link #getStaff() <em>Staff</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getStaff()
     * @generated
     * @ordered
     */
	protected EList<Person> staff;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CompanyImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return WorkorganisationPackage.Literals.COMPANY;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<Department> getDepartments() {
        if (departments == null) {
            departments = new EObjectContainmentWithInverseEList<Department>(Department.class, this, WorkorganisationPackage.COMPANY__DEPARTMENTS, WorkorganisationPackage.DEPARTMENT__COMPANY);
        }
        return departments;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<SoftwareArchitect> getChiefarchitects() {
        if (chiefarchitects == null) {
            chiefarchitects = new EObjectContainmentWithInverseEList<SoftwareArchitect>(SoftwareArchitect.class, this, WorkorganisationPackage.COMPANY__CHIEFARCHITECTS, WorkorganisationPackage.SOFTWARE_ARCHITECT__COMPANY);
        }
        return chiefarchitects;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkOrganisationModel getWorkorganisationmodel() {
        if (eContainerFeatureID() != WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL) return null;
        return (WorkOrganisationModel)eContainer();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetWorkorganisationmodel(WorkOrganisationModel newWorkorganisationmodel, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newWorkorganisationmodel, WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL, msgs);
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setWorkorganisationmodel(WorkOrganisationModel newWorkorganisationmodel) {
        if (newWorkorganisationmodel != eInternalContainer() || (eContainerFeatureID() != WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL && newWorkorganisationmodel != null)) {
            if (EcoreUtil.isAncestor(this, newWorkorganisationmodel))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newWorkorganisationmodel != null)
                msgs = ((InternalEObject)newWorkorganisationmodel).eInverseAdd(this, WorkorganisationPackage.WORK_ORGANISATION_MODEL__COMPANIES, WorkOrganisationModel.class, msgs);
            msgs = basicSetWorkorganisationmodel(newWorkorganisationmodel, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL, newWorkorganisationmodel, newWorkorganisationmodel));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<Person> getStaff() {
        if (staff == null) {
            staff = new EObjectContainmentWithInverseEList<Person>(Person.class, this, WorkorganisationPackage.COMPANY__STAFF, WorkorganisationPackage.PERSON__COMPANY);
        }
        return staff;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getDepartments()).basicAdd(otherEnd, msgs);
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getChiefarchitects()).basicAdd(otherEnd, msgs);
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetWorkorganisationmodel((WorkOrganisationModel)otherEnd, msgs);
            case WorkorganisationPackage.COMPANY__STAFF:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getStaff()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                return ((InternalEList<?>)getDepartments()).basicRemove(otherEnd, msgs);
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                return ((InternalEList<?>)getChiefarchitects()).basicRemove(otherEnd, msgs);
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                return basicSetWorkorganisationmodel(null, msgs);
            case WorkorganisationPackage.COMPANY__STAFF:
                return ((InternalEList<?>)getStaff()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID()) {
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                return eInternalContainer().eInverseRemove(this, WorkorganisationPackage.WORK_ORGANISATION_MODEL__COMPANIES, WorkOrganisationModel.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                return getDepartments();
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                return getChiefarchitects();
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                return getWorkorganisationmodel();
            case WorkorganisationPackage.COMPANY__STAFF:
                return getStaff();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                getDepartments().clear();
                getDepartments().addAll((Collection<? extends Department>)newValue);
                return;
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                getChiefarchitects().clear();
                getChiefarchitects().addAll((Collection<? extends SoftwareArchitect>)newValue);
                return;
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                setWorkorganisationmodel((WorkOrganisationModel)newValue);
                return;
            case WorkorganisationPackage.COMPANY__STAFF:
                getStaff().clear();
                getStaff().addAll((Collection<? extends Person>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                getDepartments().clear();
                return;
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                getChiefarchitects().clear();
                return;
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                setWorkorganisationmodel((WorkOrganisationModel)null);
                return;
            case WorkorganisationPackage.COMPANY__STAFF:
                getStaff().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case WorkorganisationPackage.COMPANY__DEPARTMENTS:
                return departments != null && !departments.isEmpty();
            case WorkorganisationPackage.COMPANY__CHIEFARCHITECTS:
                return chiefarchitects != null && !chiefarchitects.isEmpty();
            case WorkorganisationPackage.COMPANY__WORKORGANISATIONMODEL:
                return getWorkorganisationmodel() != null;
            case WorkorganisationPackage.COMPANY__STAFF:
                return staff != null && !staff.isEmpty();
        }
        return super.eIsSet(featureID);
    }

} //CompanyImpl
