/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.maintainabilitymodel.main.MainPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationFactory
 * @model kind="package"
 * @generated
 */
public interface WorkorganisationPackage extends EPackage {
	/**
     * The package name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNAME = "workorganisation";

	/**
     * The package namespace URI.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_URI = "http://www.fzi.de/maintainabilitymodel/workorganisation";

	/**
     * The package namespace name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_PREFIX = "workorganisation";

	/**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	WorkorganisationPackage eINSTANCE = de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl.init();

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationElementImpl <em>Work Organisation Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationElementImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getWorkOrganisationElement()
     * @generated
     */
	int WORK_ORGANISATION_ELEMENT = 1;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_ELEMENT__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_ELEMENT__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Work Organisation Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_ELEMENT_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.RoleImpl <em>Role</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.RoleImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getRole()
     * @generated
     */
	int ROLE = 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ROLE__ID = WORK_ORGANISATION_ELEMENT__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ROLE__NAME = WORK_ORGANISATION_ELEMENT__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ROLE__ARCHITECTUREMODELELEMENT = WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Person</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ROLE__PERSON = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Role</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ROLE_FEATURE_COUNT = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 1;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.PersonImpl <em>Person</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.PersonImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getPerson()
     * @generated
     */
	int PERSON = 2;

	/**
     * The feature id for the '<em><b>Company</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PERSON__COMPANY = 0;

	/**
     * The feature id for the '<em><b>Roles</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PERSON__ROLES = 1;

	/**
     * The number of structural features of the '<em>Person</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PERSON_FEATURE_COUNT = 2;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl <em>Company</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getCompany()
     * @generated
     */
	int COMPANY = 3;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__ID = WORK_ORGANISATION_ELEMENT__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__NAME = WORK_ORGANISATION_ELEMENT__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__ARCHITECTUREMODELELEMENT = WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Departments</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__DEPARTMENTS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Chiefarchitects</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__CHIEFARCHITECTS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Workorganisationmodel</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__WORKORGANISATIONMODEL = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 2;

	/**
     * The feature id for the '<em><b>Staff</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY__STAFF = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 3;

	/**
     * The number of structural features of the '<em>Company</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPANY_FEATURE_COUNT = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 4;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.DepartmentImpl <em>Department</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.DepartmentImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getDepartment()
     * @generated
     */
	int DEPARTMENT = 4;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__ID = WORK_ORGANISATION_ELEMENT__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__NAME = WORK_ORGANISATION_ELEMENT__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__ARCHITECTUREMODELELEMENT = WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Teams</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__TEAMS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Departmentarchitects</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__DEPARTMENTARCHITECTS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Company</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT__COMPANY = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Department</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPARTMENT_FEATURE_COUNT = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.TeamImpl <em>Team</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.TeamImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getTeam()
     * @generated
     */
	int TEAM = 5;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__ID = WORK_ORGANISATION_ELEMENT__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__NAME = WORK_ORGANISATION_ELEMENT__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__ARCHITECTUREMODELELEMENT = WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Teamarchitects</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__TEAMARCHITECTS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Softwaredevelopers</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__SOFTWAREDEVELOPERS = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Department</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM__DEPARTMENT = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Team</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEAM_FEATURE_COUNT = WORK_ORGANISATION_ELEMENT_FEATURE_COUNT + 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareArchitectImpl <em>Software Architect</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareArchitectImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getSoftwareArchitect()
     * @generated
     */
	int SOFTWARE_ARCHITECT = 6;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__ID = ROLE__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__NAME = ROLE__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__ARCHITECTUREMODELELEMENT = ROLE__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Person</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__PERSON = ROLE__PERSON;

	/**
     * The feature id for the '<em><b>Company</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__COMPANY = ROLE_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Department</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__DEPARTMENT = ROLE_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Team</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT__TEAM = ROLE_FEATURE_COUNT + 2;

	/**
     * The number of structural features of the '<em>Software Architect</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_ARCHITECT_FEATURE_COUNT = ROLE_FEATURE_COUNT + 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareDeveloperImpl <em>Software Developer</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareDeveloperImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getSoftwareDeveloper()
     * @generated
     */
	int SOFTWARE_DEVELOPER = 7;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER__ID = ROLE__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER__NAME = ROLE__NAME;

	/**
     * The feature id for the '<em><b>Architecturemodelelement</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER__ARCHITECTUREMODELELEMENT = ROLE__ARCHITECTUREMODELELEMENT;

	/**
     * The feature id for the '<em><b>Person</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER__PERSON = ROLE__PERSON;

	/**
     * The feature id for the '<em><b>Team</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER__TEAM = ROLE_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Software Developer</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SOFTWARE_DEVELOPER_FEATURE_COUNT = ROLE_FEATURE_COUNT + 1;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationModelImpl <em>Work Organisation Model</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationModelImpl
     * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getWorkOrganisationModel()
     * @generated
     */
	int WORK_ORGANISATION_MODEL = 8;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_MODEL__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_MODEL__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Companies</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_MODEL__COMPANIES = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Work Organisation Model</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORK_ORGANISATION_MODEL_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;


	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.Role <em>Role</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Role</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Role
     * @generated
     */
	EClass getRole();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.workorganisation.Role#getPerson <em>Person</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Person</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Role#getPerson()
     * @see #getRole()
     * @generated
     */
	EReference getRole_Person();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement <em>Work Organisation Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Work Organisation Element</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement
     * @generated
     */
	EClass getWorkOrganisationElement();

	/**
     * Returns the meta object for the reference list '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement#getArchitecturemodelelement <em>Architecturemodelelement</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Architecturemodelelement</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement#getArchitecturemodelelement()
     * @see #getWorkOrganisationElement()
     * @generated
     */
	EReference getWorkOrganisationElement_Architecturemodelelement();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.Person <em>Person</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Person</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Person
     * @generated
     */
	EClass getPerson();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.Person#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Company</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Person#getCompany()
     * @see #getPerson()
     * @generated
     */
	EReference getPerson_Company();

	/**
     * Returns the meta object for the reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Person#getRoles <em>Roles</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Roles</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Person#getRoles()
     * @see #getPerson()
     * @generated
     */
	EReference getPerson_Roles();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.Company <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Company</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company
     * @generated
     */
	EClass getCompany();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Company#getDepartments <em>Departments</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Departments</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company#getDepartments()
     * @see #getCompany()
     * @generated
     */
	EReference getCompany_Departments();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Company#getChiefarchitects <em>Chiefarchitects</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Chiefarchitects</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company#getChiefarchitects()
     * @see #getCompany()
     * @generated
     */
	EReference getCompany_Chiefarchitects();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.Company#getWorkorganisationmodel <em>Workorganisationmodel</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Workorganisationmodel</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company#getWorkorganisationmodel()
     * @see #getCompany()
     * @generated
     */
	EReference getCompany_Workorganisationmodel();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Company#getStaff <em>Staff</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Staff</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Company#getStaff()
     * @see #getCompany()
     * @generated
     */
	EReference getCompany_Staff();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.Department <em>Department</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Department</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Department
     * @generated
     */
	EClass getDepartment();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Department#getTeams <em>Teams</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Teams</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Department#getTeams()
     * @see #getDepartment()
     * @generated
     */
	EReference getDepartment_Teams();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Department#getDepartmentarchitects <em>Departmentarchitects</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Departmentarchitects</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Department#getDepartmentarchitects()
     * @see #getDepartment()
     * @generated
     */
	EReference getDepartment_Departmentarchitects();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.Department#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Company</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Department#getCompany()
     * @see #getDepartment()
     * @generated
     */
	EReference getDepartment_Company();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.Team <em>Team</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Team</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Team
     * @generated
     */
	EClass getTeam();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Team#getTeamarchitects <em>Teamarchitects</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Teamarchitects</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Team#getTeamarchitects()
     * @see #getTeam()
     * @generated
     */
	EReference getTeam_Teamarchitects();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.Team#getSoftwaredevelopers <em>Softwaredevelopers</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Softwaredevelopers</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Team#getSoftwaredevelopers()
     * @see #getTeam()
     * @generated
     */
	EReference getTeam_Softwaredevelopers();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.Team#getDepartment <em>Department</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Department</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.Team#getDepartment()
     * @see #getTeam()
     * @generated
     */
	EReference getTeam_Department();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect <em>Software Architect</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Software Architect</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect
     * @generated
     */
	EClass getSoftwareArchitect();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Company</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getCompany()
     * @see #getSoftwareArchitect()
     * @generated
     */
	EReference getSoftwareArchitect_Company();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getDepartment <em>Department</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Department</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getDepartment()
     * @see #getSoftwareArchitect()
     * @generated
     */
	EReference getSoftwareArchitect_Department();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getTeam <em>Team</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Team</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getTeam()
     * @see #getSoftwareArchitect()
     * @generated
     */
	EReference getSoftwareArchitect_Team();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper <em>Software Developer</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Software Developer</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper
     * @generated
     */
	EClass getSoftwareDeveloper();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper#getTeam <em>Team</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Team</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper#getTeam()
     * @see #getSoftwareDeveloper()
     * @generated
     */
	EReference getSoftwareDeveloper_Team();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel <em>Work Organisation Model</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Work Organisation Model</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel
     * @generated
     */
	EClass getWorkOrganisationModel();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel#getCompanies <em>Companies</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Companies</em>'.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel#getCompanies()
     * @see #getWorkOrganisationModel()
     * @generated
     */
	EReference getWorkOrganisationModel_Companies();

	/**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	WorkorganisationFactory getWorkorganisationFactory();

	/**
     * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
     * @generated
     */
	interface Literals {
		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.RoleImpl <em>Role</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.RoleImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getRole()
         * @generated
         */
		EClass ROLE = eINSTANCE.getRole();

		/**
         * The meta object literal for the '<em><b>Person</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ROLE__PERSON = eINSTANCE.getRole_Person();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationElementImpl <em>Work Organisation Element</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationElementImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getWorkOrganisationElement()
         * @generated
         */
		EClass WORK_ORGANISATION_ELEMENT = eINSTANCE.getWorkOrganisationElement();

		/**
         * The meta object literal for the '<em><b>Architecturemodelelement</b></em>' reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference WORK_ORGANISATION_ELEMENT__ARCHITECTUREMODELELEMENT = eINSTANCE.getWorkOrganisationElement_Architecturemodelelement();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.PersonImpl <em>Person</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.PersonImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getPerson()
         * @generated
         */
		EClass PERSON = eINSTANCE.getPerson();

		/**
         * The meta object literal for the '<em><b>Company</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference PERSON__COMPANY = eINSTANCE.getPerson_Company();

		/**
         * The meta object literal for the '<em><b>Roles</b></em>' reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference PERSON__ROLES = eINSTANCE.getPerson_Roles();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl <em>Company</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.CompanyImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getCompany()
         * @generated
         */
		EClass COMPANY = eINSTANCE.getCompany();

		/**
         * The meta object literal for the '<em><b>Departments</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPANY__DEPARTMENTS = eINSTANCE.getCompany_Departments();

		/**
         * The meta object literal for the '<em><b>Chiefarchitects</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPANY__CHIEFARCHITECTS = eINSTANCE.getCompany_Chiefarchitects();

		/**
         * The meta object literal for the '<em><b>Workorganisationmodel</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPANY__WORKORGANISATIONMODEL = eINSTANCE.getCompany_Workorganisationmodel();

		/**
         * The meta object literal for the '<em><b>Staff</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference COMPANY__STAFF = eINSTANCE.getCompany_Staff();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.DepartmentImpl <em>Department</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.DepartmentImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getDepartment()
         * @generated
         */
		EClass DEPARTMENT = eINSTANCE.getDepartment();

		/**
         * The meta object literal for the '<em><b>Teams</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference DEPARTMENT__TEAMS = eINSTANCE.getDepartment_Teams();

		/**
         * The meta object literal for the '<em><b>Departmentarchitects</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference DEPARTMENT__DEPARTMENTARCHITECTS = eINSTANCE.getDepartment_Departmentarchitects();

		/**
         * The meta object literal for the '<em><b>Company</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference DEPARTMENT__COMPANY = eINSTANCE.getDepartment_Company();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.TeamImpl <em>Team</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.TeamImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getTeam()
         * @generated
         */
		EClass TEAM = eINSTANCE.getTeam();

		/**
         * The meta object literal for the '<em><b>Teamarchitects</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TEAM__TEAMARCHITECTS = eINSTANCE.getTeam_Teamarchitects();

		/**
         * The meta object literal for the '<em><b>Softwaredevelopers</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TEAM__SOFTWAREDEVELOPERS = eINSTANCE.getTeam_Softwaredevelopers();

		/**
         * The meta object literal for the '<em><b>Department</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TEAM__DEPARTMENT = eINSTANCE.getTeam_Department();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareArchitectImpl <em>Software Architect</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareArchitectImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getSoftwareArchitect()
         * @generated
         */
		EClass SOFTWARE_ARCHITECT = eINSTANCE.getSoftwareArchitect();

		/**
         * The meta object literal for the '<em><b>Company</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference SOFTWARE_ARCHITECT__COMPANY = eINSTANCE.getSoftwareArchitect_Company();

		/**
         * The meta object literal for the '<em><b>Department</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference SOFTWARE_ARCHITECT__DEPARTMENT = eINSTANCE.getSoftwareArchitect_Department();

		/**
         * The meta object literal for the '<em><b>Team</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference SOFTWARE_ARCHITECT__TEAM = eINSTANCE.getSoftwareArchitect_Team();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareDeveloperImpl <em>Software Developer</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.SoftwareDeveloperImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getSoftwareDeveloper()
         * @generated
         */
		EClass SOFTWARE_DEVELOPER = eINSTANCE.getSoftwareDeveloper();

		/**
         * The meta object literal for the '<em><b>Team</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference SOFTWARE_DEVELOPER__TEAM = eINSTANCE.getSoftwareDeveloper_Team();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationModelImpl <em>Work Organisation Model</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkOrganisationModelImpl
         * @see de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl#getWorkOrganisationModel()
         * @generated
         */
		EClass WORK_ORGANISATION_MODEL = eINSTANCE.getWorkOrganisationModel();

		/**
         * The meta object literal for the '<em><b>Companies</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference WORK_ORGANISATION_MODEL__COMPANIES = eINSTANCE.getWorkOrganisationModel_Companies();

	}

} //WorkorganisationPackage
