/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Company</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.Company#getDepartments <em>Departments</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.Company#getChiefarchitects <em>Chiefarchitects</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.Company#getWorkorganisationmodel <em>Workorganisationmodel</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.workorganisation.Company#getStaff <em>Staff</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage#getCompany()
 * @model
 * @generated
 */
public interface Company extends WorkOrganisationElement {
	/**
     * Returns the value of the '<em><b>Departments</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workorganisation.Department}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workorganisation.Department#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Departments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Departments</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage#getCompany_Departments()
     * @see de.fzi.maintainabilitymodel.workorganisation.Department#getCompany
     * @model opposite="company" containment="true" ordered="false"
     * @generated
     */
	EList<Department> getDepartments();

	/**
     * Returns the value of the '<em><b>Chiefarchitects</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Chiefarchitects</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Chiefarchitects</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage#getCompany_Chiefarchitects()
     * @see de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect#getCompany
     * @model opposite="company" containment="true" ordered="false"
     * @generated
     */
	EList<SoftwareArchitect> getChiefarchitects();

	/**
     * Returns the value of the '<em><b>Workorganisationmodel</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel#getCompanies <em>Companies</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Workorganisationmodel</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Workorganisationmodel</em>' container reference.
     * @see #setWorkorganisationmodel(WorkOrganisationModel)
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage#getCompany_Workorganisationmodel()
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel#getCompanies
     * @model opposite="companies" required="true" transient="false" ordered="false"
     * @generated
     */
	WorkOrganisationModel getWorkorganisationmodel();

	/**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.workorganisation.Company#getWorkorganisationmodel <em>Workorganisationmodel</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Workorganisationmodel</em>' container reference.
     * @see #getWorkorganisationmodel()
     * @generated
     */
	void setWorkorganisationmodel(WorkOrganisationModel value);

	/**
     * Returns the value of the '<em><b>Staff</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workorganisation.Person}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workorganisation.Person#getCompany <em>Company</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Staff</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Staff</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.workorganisation.WorkorganisationPackage#getCompany_Staff()
     * @see de.fzi.maintainabilitymodel.workorganisation.Person#getCompany
     * @model opposite="company" containment="true" ordered="false"
     * @generated
     */
	EList<Person> getStaff();

} // Company
